/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.SAML2CfgSetterFactory;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.write.SAML2EndpointSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatKerberosTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatTransientTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatWindowsSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatX509TrustedIdPSetter;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataEndpoint;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedProvider;
import com.sap.security.saml2.cfg.util.DestinationUtil;
import java.util.ArrayList;
import java.util.List;

public class SAML2MetadataTrustedIdP
extends SAML2MetadataTrustedProvider {
    private Boolean wantAuthnRequestsSigned;
    private List<SAML2MetadataEndpoint> singleSignOnEndpoints;

    SAML2MetadataTrustedIdP() {
    }

    public Boolean isWantAuthnRequestsSigned() {
        return this.wantAuthnRequestsSigned;
    }

    public void setWantAuthnRequestsSigned(Boolean wantAuthnRequestsSigned) {
        this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
    }

    public List<SAML2MetadataEndpoint> getSingleSignOnEndpoints() {
        return this.singleSignOnEndpoints;
    }

    public void setSingleSignOnEndpoints(List<SAML2MetadataEndpoint> singleSignOnEndpoints) {
        this.singleSignOnEndpoints = singleSignOnEndpoints;
    }

    public void fillInModifiableCfg(SAML2ModifiableTrustedIdP modifiableTrustedIdP, String keystoreView, boolean automatic) throws SAML2ConfigurationException {
        String providerName = this.getName();
        String signingCert = this.getSigningCertificateString();
        String signingCertificateName = this.getSigningEntryName();
        if (signingCert != null && signingCert.length() > 0) {
            signingCertificateName = SAML2KeystoreWrapper.getInstance().importCertificate(keystoreView, providerName, "sign", signingCert);
        }
        modifiableTrustedIdP.setSigningCertificateName(signingCertificateName);
        String encCert = this.getEncryptionCertificateString();
        String encCertificateName = this.getEncryptionEntryName();
        if (encCert != null && encCert.length() > 0) {
            encCertificateName = SAML2KeystoreWrapper.getInstance().importCertificate(keystoreView, providerName, "enc", encCert);
        }
        modifiableTrustedIdP.setEncryptionCertificateName(encCertificateName);
        ArrayList<SAML2EndpointSetter> endpoints = new ArrayList<SAML2EndpointSetter>();
        List<SAML2MetadataEndpoint> arsEndpoints = this.getArtifactResolutionEndpoints();
        SAML2MetadataTrustedIdP.calculateDefaultARSEndpoint(arsEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : arsEndpoints) {
            Object cfgEndpointSetter;
            if (SAML2Binding.SOAP_BINDING == metadataEndpoint.getBinding()) {
                String destinationName = DestinationUtil.createDestination(providerName, "ars", metadataEndpoint.getLocation());
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter(destinationName);
            } else {
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            }
            endpoints.add((SAML2EndpointSetter)cfgEndpointSetter);
        }
        List<SAML2MetadataEndpoint> sloEndpoints = this.getSingleLogoutEndpoints();
        SAML2MetadataTrustedIdP.calculateDefaultSLOEndpoint(sloEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : sloEndpoints) {
            Object cfgEndpointSetter;
            if (SAML2Binding.SOAP_BINDING == metadataEndpoint.getBinding()) {
                String destinationName = DestinationUtil.createDestination(providerName, "slo", metadataEndpoint.getLocation());
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter(destinationName);
            } else {
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            }
            endpoints.add((SAML2EndpointSetter)cfgEndpointSetter);
        }
        List<SAML2MetadataEndpoint> mniEndpoints = this.getManageNameIdEndpoints();
        SAML2MetadataTrustedIdP.calculateDefaultMNIEndpoint(mniEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : mniEndpoints) {
            Object cfgEndpointSetter;
            if (SAML2Binding.SOAP_BINDING == metadataEndpoint.getBinding()) {
                String destinationName = DestinationUtil.createDestination(providerName, "mni", metadataEndpoint.getLocation());
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter(destinationName);
            } else {
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            }
            endpoints.add((SAML2EndpointSetter)cfgEndpointSetter);
        }
        List<SAML2MetadataEndpoint> ssoEndpoints = this.getSingleSignOnEndpoints();
        SAML2MetadataTrustedIdP.calculateDefaultSSOEndpoint(ssoEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : ssoEndpoints) {
            SAML2EndpointSetter cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            endpoints.add(cfgEndpointSetter);
        }
        modifiableTrustedIdP.setEndpoints(endpoints);
        List<SAML2NameIdFormat> supportedNameIdFormats = this.getSupportedNameIDFormats();
        if (automatic) {
            if (supportedNameIdFormats.isEmpty()) {
                supportedNameIdFormats.add(SAML2NameIdFormat.UNSPECIFIED);
            }
            modifiableTrustedIdP.setDefaultNameIdFormat(supportedNameIdFormats.get(0));
        }
        for (SAML2NameIdFormat nameIdFormat : supportedNameIdFormats) {
            SAML2NameIdFormatSetter nameIdFormatSetter;
            if (SAML2NameIdFormat.UNSPECIFIED == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatUnspecified();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedIdP.setNameIdFormatUnspecified((SAML2NameIdFormatUnspecifiedSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.PERSISTENT == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatPersistentTrustedIdP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedIdP.setNameIdFormatPersistent((SAML2NameIdFormatPersistentTrustedIdPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.TRANSIENT == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatTransientTrustedIdP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedIdP.setNameIdFormatTransient((SAML2NameIdFormatTransientTrustedIdPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.E_MAIL == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatEmail();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedIdP.setNameIdFormatEmail((SAML2NameIdFormatEmailSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.KERBEROS == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatKerberosTrustedIdP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedIdP.setNameIdFormatKerberos((SAML2NameIdFormatKerberosTrustedIdPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.X509_SUBJECT_NAME == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatX509TrustedIdP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedIdP.setNameIdFormatX509((SAML2NameIdFormatX509TrustedIdPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME != nameIdFormat) continue;
            nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatWindows();
            nameIdFormatSetter.setSupported(true);
            modifiableTrustedIdP.setNameIdFormatWindows((SAML2NameIdFormatWindowsSetter)nameIdFormatSetter);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        result.append(", wantAuthnRequestsSigned: ");
        result.append(this.wantAuthnRequestsSigned);
        result.append(", SSO endpoints: ");
        result.append(this.singleSignOnEndpoints);
        return result.toString();
    }
}

