/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataEndpoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class SAML2MetadataTrustedProvider {
    protected static final String SUFFIX_SLO = "slo";
    protected static final String SUFFIX_ARS = "ars";
    protected static final String SUFFIX_MNI = "mni";
    protected static final String SUFFIX_ENC = "enc";
    protected static final String SUFFIX_SIGN = "sign";
    private String name;
    private String signingEntryName;
    private String encryptionEntryName;
    private String signingCertificateString;
    private String encryptionCertificateString;
    private List<SAML2NameIdFormat> supportedNameIDFormats;
    private List<SAML2MetadataEndpoint> artifactResolutionEndpoints;
    private List<SAML2MetadataEndpoint> singleLogoutEndpoints;
    private List<SAML2MetadataEndpoint> manageNameIdEndpoints;

    SAML2MetadataTrustedProvider() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSigningEntryName() {
        return this.signingEntryName;
    }

    public void setSigningEntryName(String signingEntryName) {
        this.signingEntryName = signingEntryName;
    }

    public String getEncryptionEntryName() {
        return this.encryptionEntryName;
    }

    public void setEncryptionEntryName(String encryptionEntryName) {
        this.encryptionEntryName = encryptionEntryName;
    }

    public String getSigningCertificateString() {
        return this.signingCertificateString;
    }

    public void setSigningCertificateString(String signingCertificateString) {
        this.signingCertificateString = signingCertificateString;
    }

    public String getEncryptionCertificateString() {
        return this.encryptionCertificateString;
    }

    public void setEncryptionCertificateString(String encryptionCertificateString) {
        this.encryptionCertificateString = encryptionCertificateString;
    }

    public List<SAML2NameIdFormat> getSupportedNameIDFormats() {
        return this.supportedNameIDFormats;
    }

    public void setSupportedNameIDFormats(List<SAML2NameIdFormat> nameIDFormats) {
        this.supportedNameIDFormats = nameIDFormats;
    }

    public List<SAML2MetadataEndpoint> getArtifactResolutionEndpoints() {
        return this.artifactResolutionEndpoints;
    }

    public void setArtifactResolutionEndpoints(List<SAML2MetadataEndpoint> artifactResolutionEndpoints) {
        this.artifactResolutionEndpoints = artifactResolutionEndpoints;
    }

    public List<SAML2MetadataEndpoint> getSingleLogoutEndpoints() {
        return this.singleLogoutEndpoints;
    }

    public void setSingleLogoutEndpoints(List<SAML2MetadataEndpoint> singleLogoutEndpoints) {
        this.singleLogoutEndpoints = singleLogoutEndpoints;
    }

    public List<SAML2MetadataEndpoint> getManageNameIdEndpoints() {
        return this.manageNameIdEndpoints;
    }

    public void setManageNameIdEndpoints(List<SAML2MetadataEndpoint> manageNameIdEndpoints) {
        this.manageNameIdEndpoints = manageNameIdEndpoints;
    }

    protected static void calculateDefaultARSEndpoint(List<SAML2MetadataEndpoint> endpoints) {
        if (!SAML2MetadataTrustedProvider.isThereDefaultEndpoint(endpoints)) {
            SAML2MetadataTrustedProvider.chooseDefaultBasedOnIndex(endpoints);
        }
    }

    protected static void calculateDefaultSLOEndpoint(List<SAML2MetadataEndpoint> endpoints) {
        if (!SAML2MetadataTrustedProvider.isThereDefaultEndpoint(endpoints)) {
            SAML2MetadataTrustedProvider.chooseDefaultBasedOnBindings(endpoints, Arrays.asList(SAML2Binding.HTTP_REDIRECT_BINDING, SAML2Binding.HTTP_POST_BINDING, SAML2Binding.SOAP_BINDING, SAML2Binding.HTTP_ARTIFACT_BINDING));
        }
    }

    protected static void calculateDefaultMNIEndpoint(List<SAML2MetadataEndpoint> endpoints) {
        if (!SAML2MetadataTrustedProvider.isThereDefaultEndpoint(endpoints)) {
            SAML2MetadataTrustedProvider.chooseDefaultBasedOnBindings(endpoints, Arrays.asList(SAML2Binding.HTTP_REDIRECT_BINDING, SAML2Binding.HTTP_POST_BINDING, SAML2Binding.SOAP_BINDING, SAML2Binding.HTTP_ARTIFACT_BINDING));
        }
    }

    protected static void calculateDefaultSSOEndpoint(List<SAML2MetadataEndpoint> endpoints) {
        if (!SAML2MetadataTrustedProvider.isThereDefaultEndpoint(endpoints)) {
            SAML2MetadataTrustedProvider.chooseDefaultBasedOnBindings(endpoints, Arrays.asList(SAML2Binding.HTTP_REDIRECT_BINDING, SAML2Binding.HTTP_POST_BINDING, SAML2Binding.HTTP_ARTIFACT_BINDING));
        }
    }

    protected static void calculateDefaultACSEndpoint(List<SAML2MetadataEndpoint> endpoints) {
        if (!SAML2MetadataTrustedProvider.isThereDefaultEndpoint(endpoints)) {
            SAML2MetadataTrustedProvider.chooseDefaultBasedOnBindings(endpoints, Arrays.asList(SAML2Binding.HTTP_POST_BINDING, SAML2Binding.HTTP_ARTIFACT_BINDING));
        }
    }

    private static boolean isThereDefaultEndpoint(List<SAML2MetadataEndpoint> endpoints) {
        for (SAML2MetadataEndpoint metadataEndpoint : endpoints) {
            if (metadataEndpoint.isDefault() == null || !metadataEndpoint.isDefault().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void chooseDefaultBasedOnBindings(List<SAML2MetadataEndpoint> endpoints, List<SAML2Binding> preferredBindings) {
        for (SAML2Binding binding : preferredBindings) {
            List<SAML2MetadataEndpoint> redirectEndpoints = SAML2MetadataTrustedProvider.getEndpointsByBinding(endpoints, binding);
            if (redirectEndpoints.size() <= 0) continue;
            redirectEndpoints.get(0).setDefault(true);
            return;
        }
    }

    private static void chooseDefaultBasedOnIndex(List<SAML2MetadataEndpoint> endpoints) {
        if (endpoints.size() > 0) {
            int defaultEndpoint = 0;
            int minIndex = Integer.MAX_VALUE;
            int i = 0;
            while (i < endpoints.size()) {
                if (endpoints.get(i).getIndex() != null && endpoints.get(i).getIndex() < minIndex) {
                    minIndex = endpoints.get(i).getIndex();
                    defaultEndpoint = i;
                }
                ++i;
            }
            endpoints.get(defaultEndpoint).setDefault(true);
        }
    }

    private static List<SAML2MetadataEndpoint> getEndpointsByBinding(List<SAML2MetadataEndpoint> endpoints, SAML2Binding binding) {
        ArrayList<SAML2MetadataEndpoint> result = new ArrayList<SAML2MetadataEndpoint>();
        for (SAML2MetadataEndpoint e : endpoints) {
            if (!binding.equals(e.getBinding())) continue;
            result.add(e);
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("\n");
        result.append("name: " + this.name);
        result.append(", signing entry name: " + this.signingEntryName);
        result.append(", signing cert: " + this.signingCertificateString);
        result.append(", encryption entry name: " + this.encryptionEntryName);
        result.append(", encryption cert: " + this.encryptionCertificateString);
        result.append(", supported nameId-formats: " + this.supportedNameIDFormats);
        result.append(", ARS endpoints: " + this.artifactResolutionEndpoints);
        result.append(", SLO endpoints: " + this.singleLogoutEndpoints);
        result.append(", MNI endpoints: " + this.manageNameIdEndpoints);
        return result.toString();
    }
}

