/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.metadata;

import com.sap.security.saml2.cfg.SAML2CfgSetterFactory;
import com.sap.security.saml2.cfg.SAML2KeystoreWrapper;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.write.SAML2EndpointSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatKerberosTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatTransientTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatWindowsSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatX509TrustedSPSetter;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataEndpoint;
import com.sap.security.saml2.cfg.metadata.SAML2MetadataTrustedProvider;
import com.sap.security.saml2.cfg.util.DestinationUtil;
import java.util.ArrayList;
import java.util.List;

public class SAML2MetadataTrustedSP
extends SAML2MetadataTrustedProvider {
    private Boolean authnRequestSigned;
    private Boolean wantAssertionsSigned;
    private List<SAML2MetadataEndpoint> assertionConsumerEndpoints;

    SAML2MetadataTrustedSP() {
    }

    public Boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public void setAuthnRequestSigned(Boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    public Boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    public void setWantAssertionsSigned(Boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
    }

    public List<SAML2MetadataEndpoint> getAssertionConsumerEndpoints() {
        return this.assertionConsumerEndpoints;
    }

    public void setAssertionConsumerEndpoints(List<SAML2MetadataEndpoint> assertionConsumerEndpoints) {
        this.assertionConsumerEndpoints = assertionConsumerEndpoints;
    }

    public void fillInModifiableCfg(SAML2ModifiableTrustedSP modifiableTrustedSP, String keystoreView, boolean automatic) throws SAML2ConfigurationException {
        String providerName = this.getName();
        String signingCert = this.getSigningCertificateString();
        String signingCertificateName = this.getSigningEntryName();
        if (signingCert != null && signingCert.length() > 0) {
            signingCertificateName = SAML2KeystoreWrapper.getInstance().importCertificate(keystoreView, providerName, "sign", signingCert);
        }
        modifiableTrustedSP.setSigningCertificateName(signingCertificateName);
        String encCert = this.getEncryptionCertificateString();
        String encCertificateName = this.getEncryptionEntryName();
        if (encCert != null && encCert.length() > 0) {
            encCertificateName = SAML2KeystoreWrapper.getInstance().importCertificate(keystoreView, providerName, "enc", encCert);
        }
        modifiableTrustedSP.setEncryptionCertificateName(encCertificateName);
        ArrayList<SAML2EndpointSetter> endpoints = new ArrayList<SAML2EndpointSetter>();
        List<SAML2MetadataEndpoint> arsEndpoints = this.getArtifactResolutionEndpoints();
        SAML2MetadataTrustedSP.calculateDefaultARSEndpoint(arsEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : arsEndpoints) {
            Object cfgEndpointSetter;
            if (SAML2Binding.SOAP_BINDING == metadataEndpoint.getBinding()) {
                String destinationName = DestinationUtil.createDestination(providerName, "ars", metadataEndpoint.getLocation());
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter(destinationName);
            } else {
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            }
            endpoints.add((SAML2EndpointSetter)cfgEndpointSetter);
        }
        List<SAML2MetadataEndpoint> sloEndpoints = this.getSingleLogoutEndpoints();
        SAML2MetadataTrustedSP.calculateDefaultSLOEndpoint(sloEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : sloEndpoints) {
            Object cfgEndpointSetter;
            if (SAML2Binding.SOAP_BINDING == metadataEndpoint.getBinding()) {
                String destinationName = DestinationUtil.createDestination(providerName, "slo", metadataEndpoint.getLocation());
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter(destinationName);
            } else {
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            }
            endpoints.add((SAML2EndpointSetter)cfgEndpointSetter);
        }
        List<SAML2MetadataEndpoint> mniEndpoints = this.getManageNameIdEndpoints();
        SAML2MetadataTrustedSP.calculateDefaultMNIEndpoint(mniEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : mniEndpoints) {
            Object cfgEndpointSetter;
            if (SAML2Binding.SOAP_BINDING == metadataEndpoint.getBinding()) {
                String destinationName = DestinationUtil.createDestination(providerName, "mni", metadataEndpoint.getLocation());
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter(destinationName);
            } else {
                cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            }
            endpoints.add((SAML2EndpointSetter)cfgEndpointSetter);
        }
        List<SAML2MetadataEndpoint> acsEndpoints = this.getAssertionConsumerEndpoints();
        SAML2MetadataTrustedSP.calculateDefaultACSEndpoint(acsEndpoints);
        for (SAML2MetadataEndpoint metadataEndpoint : acsEndpoints) {
            SAML2EndpointSetter cfgEndpointSetter = metadataEndpoint.convertToCfgSetter();
            endpoints.add(cfgEndpointSetter);
        }
        modifiableTrustedSP.setEndpoints(endpoints);
        List<SAML2NameIdFormat> supportedNameIdFormats = this.getSupportedNameIDFormats();
        if (automatic) {
            if (supportedNameIdFormats.isEmpty()) {
                supportedNameIdFormats.add(SAML2NameIdFormat.UNSPECIFIED);
            }
            modifiableTrustedSP.setDefaultNameIdFormat(supportedNameIdFormats.get(0));
        }
        for (SAML2NameIdFormat nameIdFormat : supportedNameIdFormats) {
            SAML2NameIdFormatSetter nameIdFormatSetter;
            if (SAML2NameIdFormat.UNSPECIFIED == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatUnspecified();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedSP.setNameIdFormatUnspecified((SAML2NameIdFormatUnspecifiedSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.PERSISTENT == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatPersistentTrustedSP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedSP.setNameIdFormatPersistent((SAML2NameIdFormatPersistentTrustedSPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.TRANSIENT == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatTransientTrustedSP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedSP.setNameIdFormatTransient((SAML2NameIdFormatTransientTrustedSPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.E_MAIL == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatEmail();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedSP.setNameIdFormatEmail((SAML2NameIdFormatEmailSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.KERBEROS == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatKerberosTrustedSP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedSP.setNameIdFormatKerberos((SAML2NameIdFormatKerberosTrustedSPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.X509_SUBJECT_NAME == nameIdFormat) {
                nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatX509TrustedSP();
                nameIdFormatSetter.setSupported(true);
                modifiableTrustedSP.setNameIdFormatX509((SAML2NameIdFormatX509TrustedSPSetter)nameIdFormatSetter);
                continue;
            }
            if (SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME != nameIdFormat) continue;
            nameIdFormatSetter = SAML2CfgSetterFactory.getInstance().createSAML2NameIdFormatWindows();
            nameIdFormatSetter.setSupported(true);
            modifiableTrustedSP.setNameIdFormatWindows((SAML2NameIdFormatWindowsSetter)nameIdFormatSetter);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        result.append(", AuthnRequest signed: ");
        result.append(this.authnRequestSigned);
        result.append(", Want signed Assertions: ");
        result.append(this.wantAssertionsSigned);
        result.append(", ACS endpoints: ");
        result.append(this.assertionConsumerEndpoints);
        return result.toString();
    }
}

