/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.migration;

import com.sap.security.saml2.cfg.SAML2CfgFactory;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2GlobalConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2GlobalSettings;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableGlobalSettings;
import com.sap.security.saml2.cfg.migration.SAML2MigrationStep;
import com.sap.tc.logging.Location;

public class SAML2CfgMigrationControler {
    private static final String SAML2_MIGRATION_STEP_CLASS_NAME = "com.sap.security.saml2.cfg.migration.SAML2MigrationStep";
    private static final int TARGET_CONFIGURATION_VERSION = 1;
    private static final Location LOCATION = Location.getLocation(SAML2CfgMigrationControler.class);
    private static final SAML2CfgMigrationControler INSTANCE = new SAML2CfgMigrationControler();

    private SAML2CfgMigrationControler() {
    }

    public static SAML2CfgMigrationControler getInstance() {
        return INSTANCE;
    }

    public void migrateConfiguration() throws SAML2ConfigurationException {
        SAML2GlobalConfig globalConfig = SAML2CfgFactory.getSAML2GlobalConfig();
        SAML2GlobalSettings globalSettings = globalConfig.getGlobalSettings();
        int storedConfigurationVersion = globalSettings.getVersion();
        if (storedConfigurationVersion < 1) {
            if (LOCATION.beInfo()) {
                LOCATION.infoT("SAML2 configuration will be migrated from version: {0} to version: {1}", new Object[]{storedConfigurationVersion, 1});
            }
            int i = storedConfigurationVersion + 1;
            while (i <= 1) {
                try {
                    SAML2MigrationStep migrationStep = (SAML2MigrationStep)Class.forName(SAML2_MIGRATION_STEP_CLASS_NAME + i).newInstance();
                    migrationStep.migrate(globalConfig);
                    SAML2ModifiableGlobalSettings modifiableGlobalSettings = globalSettings.getModifiableGlobalSettings();
                    modifiableGlobalSettings.setVersion(i);
                    modifiableGlobalSettings.write();
                }
                catch (Exception e) {
                    throw new SAML2ConfigurationException("SAML2 configuration could not be migrated to version: " + i, e);
                }
                ++i;
            }
        }
    }
}

