/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.migration;

import com.sap.security.saml2.cfg.SAML2CfgSetterFactory;
import com.sap.security.saml2.cfg.SAML2TrustedIdPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedSPImpl;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.security.saml2.cfg.interfaces.SAML2Config;
import com.sap.security.saml2.cfg.interfaces.SAML2GlobalConfig;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.SAML2TrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2DefaultAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederationTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.SAML2ModifiableTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2DefaultAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2IdentityFederationTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatTransientTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.migration.SAML2MigrationStep;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SAML2MigrationStep1
implements SAML2MigrationStep {
    private static final Location LOCATION = Location.getLocation(SAML2MigrationStep1.class);

    @Override
    public int getTargetVersion() {
        return 1;
    }

    @Override
    public void migrate(SAML2GlobalConfig globalConfig) throws SAML2ConfigurationException {
        if (LOCATION.beInfo()) {
            LOCATION.infoT("Starting migration of SAML2 configuration to version: {0}", new Object[]{this.getTargetVersion()});
        }
        Collection<SAML2Config> saml2Configurations = globalConfig.getSAML2Configurations();
        for (SAML2Config saml2Config : saml2Configurations) {
            Collection<SAML2TrustedIdP> trustedIdPs = saml2Config.getTrustedIdPsConfiguration().getAllTrustedIdPs();
            for (SAML2TrustedIdP trustedIdP : trustedIdPs) {
                this.migrateTrustedIdP(trustedIdP);
            }
            Collection<SAML2TrustedSP> trustedSPs = saml2Config.getTrustedSPsConfiguration().getAllTrustedSPs();
            for (SAML2TrustedSP trustedSP : trustedSPs) {
                this.migrateTrustedSP(trustedSP);
            }
        }
        if (LOCATION.beInfo()) {
            LOCATION.infoT("SAML2 configuration is migrated to version: {0}", new Object[]{this.getTargetVersion()});
        }
    }

    private void migrateTrustedSP(SAML2TrustedSP trustedSP) throws SAML2ConfigurationException {
        List<SAML2ProfileAttributeTrustedSP> userBasedAttributes;
        List<SAML2ProfileAttributeTrustedSPSetter> updatedUserAttributes;
        SAML2NameIdFormatPersistentTrustedSP nameIdFormatPersistent;
        List<SAML2ProfileAttributeTrustedSP> userBasedAttributes2;
        List<SAML2ProfileAttributeTrustedSPSetter> updatedUserAttributes2;
        SAML2ModifiableTrustedSP modifiableTrustedSP = trustedSP.getModifiableTrustedSP();
        boolean isTrustedSPNeedsMigration = false;
        SAML2NameIdFormatTransientTrustedSP nameIdFormatTransient = trustedSP.getNameIdFormatTransient();
        if (nameIdFormatTransient.isSupported() && (updatedUserAttributes2 = this.getUpdatedUserBasedAttributes(trustedSP, modifiableTrustedSP, userBasedAttributes2 = nameIdFormatTransient.getProfileAttributes())) != null) {
            isTrustedSPNeedsMigration = true;
            SAML2NameIdFormatTransientTrustedSPSetter updatedTransientNameIdFormat = modifiableTrustedSP.getNameIdFormatTransient();
            updatedTransientNameIdFormat.setProfileAttributes(updatedUserAttributes2);
            modifiableTrustedSP.setNameIdFormatTransient(updatedTransientNameIdFormat);
        }
        if ((nameIdFormatPersistent = trustedSP.getNameIdFormatPersistent()).isSupported() && (updatedUserAttributes = this.getUpdatedUserBasedAttributes(trustedSP, modifiableTrustedSP, userBasedAttributes = nameIdFormatPersistent.getProfileAttributes())) != null) {
            isTrustedSPNeedsMigration = true;
            SAML2NameIdFormatPersistentTrustedSPSetter updatedPersistentNameIdFormat = modifiableTrustedSP.getNameIdFormatPersistent();
            updatedPersistentNameIdFormat.setProfileAttributes(updatedUserAttributes);
            modifiableTrustedSP.setNameIdFormatPersistent(updatedPersistentNameIdFormat);
        }
        if (isTrustedSPNeedsMigration) {
            modifiableTrustedSP.writeProvider();
        }
    }

    private List<SAML2ProfileAttributeTrustedSPSetter> getUpdatedUserBasedAttributes(SAML2TrustedSP trustedSP, SAML2ModifiableTrustedSP modifiableTrustedSP, List<SAML2ProfileAttributeTrustedSP> userBasedAttributes) {
        boolean isUserBasedAttributesNeedsMigration = false;
        ArrayList<SAML2ProfileAttributeTrustedSPSetter> result = new ArrayList<SAML2ProfileAttributeTrustedSPSetter>();
        if (userBasedAttributes != null && !userBasedAttributes.isEmpty()) {
            for (SAML2ProfileAttributeTrustedSP userBasedAtribute : userBasedAttributes) {
                SAML2ProfileAttributeTrustedSPSetter updatedAttribute = SAML2CfgSetterFactory.getInstance().createSAML2ProfileAttributeTrustedSP();
                updatedAttribute.setSAML2AttributeName(userBasedAtribute.getSAML2AttributeName());
                updatedAttribute.setSAML2AttributeFormat(userBasedAtribute.getSAML2AttributeFormat());
                if (userBasedAtribute.getUMEAttributeName() != null) {
                    isUserBasedAttributesNeedsMigration = true;
                    SAML2CfgUMEAttribute umeAttribute = ((SAML2TrustedSPImpl)trustedSP).getUMEAttribute(userBasedAtribute.getUMEAttributeName(), userBasedAtribute.getUMEAttributeNamespace());
                    if (umeAttribute != null) {
                        updatedAttribute.setUMEAttributeAlias(umeAttribute.getAlias());
                    } else if (LOCATION.beWarning()) {
                        LOCATION.warningT("Could not migrate the UME attribute name and namespace to alias of pre-defined UME attribute, as such is not found. Details ofthe migrated configuration: {0}", new Object[]{userBasedAtribute});
                    }
                } else {
                    updatedAttribute.setUMEAttributeAlias(userBasedAtribute.getUMEAttributeAlias());
                }
                result.add(updatedAttribute);
            }
        }
        if (isUserBasedAttributesNeedsMigration) {
            return result;
        }
        return null;
    }

    private void migrateTrustedIdP(SAML2TrustedIdP trustedIdP) throws SAML2ConfigurationException {
        SAML2ModifiableTrustedIdP modifiableTrustedIdP = trustedIdP.getModifiableTrustedIdP();
        ArrayList<SAML2IdentityFederationTrustedIdPSetter> migratedIdentityFederations = new ArrayList<SAML2IdentityFederationTrustedIdPSetter>();
        Collection<SAML2IdentityFederationTrustedIdP> identityfederations = trustedIdP.getAllIdentityFederations().values();
        for (SAML2IdentityFederationTrustedIdP identityFederationTrustedIdP : identityfederations) {
            SAML2IdentityFederationTrustedIdPSetter updatedIdentityFederation;
            if (!identityFederationTrustedIdP.isSupported() || (updatedIdentityFederation = this.getUpdatedIdentityFederation(identityFederationTrustedIdP, trustedIdP, modifiableTrustedIdP)) == null) continue;
            migratedIdentityFederations.add(updatedIdentityFederation);
        }
        if (!migratedIdentityFederations.isEmpty()) {
            modifiableTrustedIdP.setIdentityFederations(migratedIdentityFederations);
            modifiableTrustedIdP.writeProvider();
        }
    }

    private SAML2IdentityFederationTrustedIdPSetter getUpdatedIdentityFederation(SAML2IdentityFederationTrustedIdP identityFederationTrustedIdP, SAML2TrustedIdP trustedIdP, SAML2ModifiableTrustedIdP modifiableTrustedIdP) {
        if (!identityFederationTrustedIdP.isSupported()) {
            return null;
        }
        Collection<SAML2DefaultAttributeTrustedIdP> defaultAttributes = identityFederationTrustedIdP.getDefaultAttributes();
        Collection<SAML2ProfileAttributeTrustedIdP> assertionBasedAttributes = identityFederationTrustedIdP.getAssertionBasedAttributes();
        if (defaultAttributes != null && !defaultAttributes.isEmpty() || assertionBasedAttributes != null && !assertionBasedAttributes.isEmpty()) {
            boolean needsMigration = false;
            SAML2IdentityFederationTrustedIdPSetter identityFederationSetter = modifiableTrustedIdP.getIdentityFederation(identityFederationTrustedIdP.getNameIdFormat());
            ArrayList<SAML2DefaultAttributeTrustedIdPSetter> updatedDefaultAttributes = new ArrayList<SAML2DefaultAttributeTrustedIdPSetter>();
            for (SAML2DefaultAttributeTrustedIdP defaultAttribute : defaultAttributes) {
                SAML2DefaultAttributeTrustedIdPSetter updatedAttribute = SAML2CfgSetterFactory.getInstance().createSAML2DefaultAttributeTrustedIdP();
                updatedAttribute.setDefaultValue(defaultAttribute.getDefaultValue());
                if (defaultAttribute.getUMEAttributeName() != null) {
                    needsMigration = true;
                    SAML2CfgUMEAttribute umeAttribute = ((SAML2TrustedIdPImpl)trustedIdP).getUMEAttribute(defaultAttribute.getUMEAttributeName(), defaultAttribute.getUMEAttributeNamespace());
                    if (umeAttribute != null) {
                        updatedAttribute.setUMEAttributeAlias(umeAttribute.getAlias());
                    } else if (LOCATION.beWarning()) {
                        LOCATION.warningT("Could not migrate the UME attribute name and namespace to alias of pre-defined UME attribute, as such is not found. Details of the migrated configuration: {0}", new Object[]{defaultAttribute});
                    }
                } else {
                    updatedAttribute.setUMEAttributeAlias(defaultAttribute.getUMEAttributeAlias());
                }
                updatedDefaultAttributes.add(updatedAttribute);
            }
            identityFederationSetter.setDefaultAttributes(updatedDefaultAttributes);
            ArrayList<SAML2ProfileAttributeTrustedIdPSetter> updatedAssertionBasedAttributes = new ArrayList<SAML2ProfileAttributeTrustedIdPSetter>();
            for (SAML2ProfileAttributeTrustedIdP assertionBasedAttribute : assertionBasedAttributes) {
                SAML2ProfileAttributeTrustedIdPSetter updatedAttribute = SAML2CfgSetterFactory.getInstance().createSAML2ProfileAttributeTrustedIdP();
                updatedAttribute.setMandatory(assertionBasedAttribute.isMandatory());
                updatedAttribute.setSAML2AttributeName(assertionBasedAttribute.getSAML2AttributeName());
                if (assertionBasedAttribute.getUMEAttributeName() != null) {
                    needsMigration = true;
                    SAML2CfgUMEAttribute umeAttribute = ((SAML2TrustedIdPImpl)trustedIdP).getUMEAttribute(assertionBasedAttribute.getUMEAttributeName(), assertionBasedAttribute.getUMEAttributeNamespace());
                    if (umeAttribute != null) {
                        updatedAttribute.setUMEAttributeAlias(umeAttribute.getAlias());
                    } else if (LOCATION.beWarning()) {
                        LOCATION.warningT("Could not migrate the UME attribute name and namespace to alias of pre-defined UME attribute, as such is not found. Details of the migrated configuration: {0}", new Object[]{assertionBasedAttribute});
                    }
                } else {
                    updatedAttribute.setUMEAttributeAlias(assertionBasedAttribute.getUMEAttributeAlias());
                }
                updatedAssertionBasedAttributes.add(updatedAttribute);
            }
            identityFederationSetter.setAssertionBasedAttributes(updatedAssertionBasedAttributes);
            if (needsMigration) {
                return identityFederationSetter;
            }
            return null;
        }
        return null;
    }
}

