/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.SAML2AuthorizationAttributeOption;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2AuthorizationAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2RuleEntry;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2AuthorizationAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2RuleEntrySetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2RuleEntryImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SAML2AuthorizationAttributeTrustedIdPImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2AuthorizationAttributeTrustedIdP,
SAML2AuthorizationAttributeTrustedIdPSetter {
    private static final String TOSTRING_PATTERN = "rule: {0}, authorization type: {1}, authorization names: {2}, cfg path: {3}";
    private static final Location LOCATION = Location.getLocation(SAML2AuthorizationAttributeTrustedIdPImpl.class);
    private static final String CFG_SHEET_NAME = "cfg";
    private static final String CFG_SUB_PATH_RULE_ENTRIES = "rule_entries";
    private static final String KEY_AUTHORIZATION_NAMES = "authz_names";
    private static final String KEY_AUTHORIZATION_TYPE = "authz_type";
    private SAML2AuthorizationAttributeOption authzType;
    private List<String> authzNames;
    private List ruleEntries;

    public SAML2AuthorizationAttributeTrustedIdPImpl() {
        super(CFG_SHEET_NAME);
    }

    public SAML2AuthorizationAttributeTrustedIdPImpl(String cfgPath) {
        super(cfgPath, CFG_SHEET_NAME);
    }

    public SAML2AuthorizationAttributeTrustedIdPImpl(String cfgPath, boolean isWriteMode) {
        super(cfgPath, CFG_SHEET_NAME, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        if (this.authzType != null) {
            this.setProperty(KEY_AUTHORIZATION_TYPE, this.authzType.name());
        }
        String[] dbAuthzNames = null;
        if (this.authzNames != null) {
            dbAuthzNames = this.authzNames.toArray(new String[this.authzNames.size()]);
        }
        this.setProperty(KEY_AUTHORIZATION_NAMES, dbAuthzNames);
        super.writeConfiguration();
        this.deleteSubConfiguration(CFG_SUB_PATH_RULE_ENTRIES);
        if (this.ruleEntries != null) {
            for (Object obj : this.ruleEntries) {
                if (obj == null) continue;
                SAML2RuleEntryImpl ruleEntry = (SAML2RuleEntryImpl)obj;
                ruleEntry.createAndWriteConfiguration(this, CFG_SUB_PATH_RULE_ENTRIES);
            }
        }
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        String[] dbAuthzNames;
        String dbAuthzType = this.readProperty(KEY_AUTHORIZATION_TYPE);
        if (dbAuthzType != null) {
            this.authzType = SAML2AuthorizationAttributeOption.valueOf(dbAuthzType);
        }
        if ((dbAuthzNames = this.readArrayProperty(KEY_AUTHORIZATION_NAMES)) != null && dbAuthzNames.length > 0) {
            this.authzNames = Arrays.asList(dbAuthzNames);
        }
        String[] ruleEntrySheets = null;
        try {
            ruleEntrySheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_RULE_ENTRIES);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load rule entries for authorization attributes", (Throwable)e);
        }
        if (ruleEntrySheets != null) {
            this.ruleEntries = new ArrayList();
            String[] stringArray = ruleEntrySheets;
            int n = ruleEntrySheets.length;
            int n2 = 0;
            while (n2 < n) {
                String ruleEntrySheet = stringArray[n2];
                SAML2RuleEntryImpl ruleEntry = new SAML2RuleEntryImpl(this, CFG_SUB_PATH_RULE_ENTRIES, ruleEntrySheet, isWriteMode);
                this.ruleEntries.add(ruleEntry);
                ++n2;
            }
        }
    }

    @Override
    public SAML2AuthorizationAttributeOption getAuthorizationType() {
        return this.authzType;
    }

    @Override
    public List<SAML2RuleEntry> getRules() {
        if (this.ruleEntries == null) {
            this.ruleEntries = new ArrayList(0);
        }
        return Collections.unmodifiableList(this.ruleEntries);
    }

    @Override
    public void setAuthorizationType(SAML2AuthorizationAttributeOption type) {
        this.authzType = type;
    }

    @Override
    public void setRules(List<SAML2RuleEntrySetter> rules) {
        this.ruleEntries = rules;
    }

    @Override
    public List<String> getAuthorizationNames() {
        if (this.authzNames == null) {
            this.authzNames = new ArrayList<String>(0);
        }
        return Collections.unmodifiableList(this.authzNames);
    }

    @Override
    public void setAuthorizationNames(List<String> authzNames) {
        this.authzNames = authzNames;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.ruleEntries, this.authzType, this.authzNames, super.toString()});
    }
}

