/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.SAML2AuthorizationAttributeOption;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2AuthorizationAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2AuthorizationAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SAML2AuthorizationAttributeTrustedSPImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2AuthorizationAttributeTrustedSP,
SAML2AuthorizationAttributeTrustedSPSetter {
    private static final String TOSTRING_PATTERN = "SAML2 attribute name: {0}, authorization type: {1}, filter: {2}, cfg path: {3}";
    private static final String KEY_ATTRIBUTE_NAME = "attr_name";
    private static final String KEY_AUTHORIZATION_TYPE = "authz_type";
    private static final String KEY_FILTER = "filter";
    private String attrName;
    private SAML2AuthorizationAttributeOption authzType;
    private List<String> filter;

    public SAML2AuthorizationAttributeTrustedSPImpl() {
    }

    public SAML2AuthorizationAttributeTrustedSPImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    public SAML2AuthorizationAttributeTrustedSPImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_ATTRIBUTE_NAME, this.attrName);
        if (this.authzType != null) {
            this.setProperty(KEY_AUTHORIZATION_TYPE, this.authzType.name());
        }
        if (this.filter != null) {
            this.setProperty(KEY_FILTER, this.filter.toArray(new String[this.filter.size()]));
        }
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        String[] dbFilter;
        this.attrName = this.readProperty(KEY_ATTRIBUTE_NAME);
        String dbAuthzType = this.readProperty(KEY_AUTHORIZATION_TYPE);
        if (dbAuthzType != null) {
            this.authzType = SAML2AuthorizationAttributeOption.valueOf(dbAuthzType);
        }
        if ((dbFilter = this.readArrayProperty(KEY_FILTER)) != null) {
            this.filter = Arrays.asList(dbFilter);
        }
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    public SAML2AuthorizationAttributeOption getAuthorizationType() {
        return this.authzType;
    }

    @Override
    public List<String> getFilter() {
        if (this.filter == null) {
            this.filter = new ArrayList<String>(0);
        }
        return Collections.unmodifiableList(this.filter);
    }

    @Override
    public String getSAML2AttributeName() {
        return this.attrName;
    }

    @Override
    public void setAuthorizationType(SAML2AuthorizationAttributeOption type) {
        this.authzType = type;
    }

    @Override
    public void setFilter(List<String> filter) {
        this.filter = filter;
    }

    @Override
    public void setSAML2AttributeName(String name) {
        this.attrName = name;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.attrName, this.authzType, this.filter, super.toString()});
    }
}

