/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.SAML2AttributeFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ConstantAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ConstantAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.text.MessageFormat;

public class SAML2ConstantAttributeTrustedSPImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2ConstantAttributeTrustedSP,
SAML2ConstantAttributeTrustedSPSetter {
    private static final String TOSTRING_PATTERN = "SAML2 attribute name: {0}, SAML2 attribute format: {1}, SAML2 attribute value: {2}, cfg path: {3}";
    private static final String KEY_SAML2_ATTRIBUTE_NAME = "saml2_attr_name";
    private static final String KEY_SAML2_ATTRIBUTE_VALUE = "saml2_attr_value";
    private static final String KEY_SAML2_ATTRIBUTE_FORMAT = "saml2_attr_format";
    private String saml2AttrName;
    private String saml2AttrValue;
    private SAML2AttributeFormat saml2AttrFormat;

    public SAML2ConstantAttributeTrustedSPImpl() {
    }

    public SAML2ConstantAttributeTrustedSPImpl(String subPath, String propertySheet, boolean isWriteMode) {
        super(subPath, propertySheet, isWriteMode);
    }

    public SAML2ConstantAttributeTrustedSPImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    public String getSAML2AttributeName() {
        return this.saml2AttrName;
    }

    @Override
    public String getSAML2AttributeValue() {
        return this.saml2AttrValue;
    }

    @Override
    public void setSAML2AttributeName(String attributeName) {
        this.saml2AttrName = attributeName;
    }

    @Override
    public void setSAML2AttributeValue(String attributeValue) {
        this.saml2AttrValue = attributeValue;
    }

    @Override
    public void setSAML2AttributeFormat(SAML2AttributeFormat format) {
        this.saml2AttrFormat = format;
    }

    @Override
    public SAML2AttributeFormat getSAML2AttributeFormat() {
        return this.saml2AttrFormat;
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        this.saml2AttrName = this.readProperty(KEY_SAML2_ATTRIBUTE_NAME);
        this.saml2AttrValue = this.readProperty(KEY_SAML2_ATTRIBUTE_VALUE);
        String dbSAML2AttributeFormat = this.readProperty(KEY_SAML2_ATTRIBUTE_FORMAT);
        if (!CfgUtils.isEmpty(dbSAML2AttributeFormat)) {
            this.saml2AttrFormat = SAML2AttributeFormat.getAttributeFormat(dbSAML2AttributeFormat);
        }
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_SAML2_ATTRIBUTE_NAME, this.saml2AttrName);
        this.setProperty(KEY_SAML2_ATTRIBUTE_VALUE, this.saml2AttrValue);
        this.setProperty(KEY_SAML2_ATTRIBUTE_FORMAT, this.saml2AttrFormat != null ? this.saml2AttrFormat.getName() : null);
        super.writeConfiguration();
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.saml2AttrName, this.saml2AttrFormat, this.saml2AttrValue, super.toString());
    }
}

