/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2TrustedIdPImpl;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2DefaultAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2DefaultAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2DefaultAttributeTrustedIdPImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2DefaultAttributeTrustedIdP,
SAML2DefaultAttributeTrustedIdPSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2DefaultAttributeTrustedIdPImpl.class);
    private static final String TOSTRING_PATTERN = "UME attribute alias: {0}, UME attribute name: {1}, UME attribute namespace: {2}, default value: {3}, cfg path: {4}";
    private static final String KEY_UME_ATTRIBUTE_NAME = "ume_attr_name";
    private static final String KEY_UME_ATTRIBUTE_NAMESPACE = "ume_attr_namespace";
    private static final String KEY_UME_ATTRIBUTE_ALIAS = "ume_attr_alias";
    private static final String KEY_DEFAULT_ATTRIBUTE_VALUE = "default_attr_value";
    private String umeAttrName;
    private String umeAttrNamespace;
    private String umeAttrAlias;
    private String defaultValue;

    public SAML2DefaultAttributeTrustedIdPImpl() {
    }

    public SAML2DefaultAttributeTrustedIdPImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    public SAML2DefaultAttributeTrustedIdPImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_UME_ATTRIBUTE_ALIAS, this.umeAttrAlias);
        this.setProperty(KEY_UME_ATTRIBUTE_NAME, this.umeAttrName);
        this.setProperty(KEY_UME_ATTRIBUTE_NAMESPACE, this.umeAttrNamespace);
        this.setProperty(KEY_DEFAULT_ATTRIBUTE_VALUE, this.defaultValue);
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        SAML2CfgObject trustedIdPCfgObject;
        SAML2CfgObject identityFederationCfgObject;
        this.umeAttrName = this.readProperty(KEY_UME_ATTRIBUTE_NAME);
        this.umeAttrNamespace = this.readProperty(KEY_UME_ATTRIBUTE_NAMESPACE);
        this.defaultValue = this.readProperty(KEY_DEFAULT_ATTRIBUTE_VALUE);
        this.umeAttrAlias = this.readProperty(KEY_UME_ATTRIBUTE_ALIAS);
        if (this.umeAttrAlias == null && this.umeAttrName != null && (identityFederationCfgObject = this.getParentCfgObject()) != null && (trustedIdPCfgObject = identityFederationCfgObject.getParentCfgObject()) != null) {
            SAML2CfgUMEAttribute umeAttribute = ((SAML2TrustedIdPImpl)trustedIdPCfgObject).getUMEAttribute(this.umeAttrName, this.umeAttrNamespace);
            if (umeAttribute != null) {
                this.umeAttrAlias = umeAttribute.getAlias();
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("The configured UME attribute with name: {0} and namespace: {1}, cannot be found in the UME attributes defined in the local provider configuration", new Object[]{this.umeAttrName, this.umeAttrNamespace});
            }
        }
    }

    @Override
    public String getUMEAttributeAlias() {
        return this.umeAttrAlias;
    }

    @Override
    public String getUMEAttributeName() {
        return this.umeAttrName;
    }

    @Override
    public String getUMEAttributeNamespace() {
        return this.umeAttrNamespace;
    }

    @Override
    public void setUMEAttributeAlias(String alias) {
        this.umeAttrAlias = alias;
    }

    @Override
    public void setUMEAttributeName(String name) {
        this.umeAttrName = name;
    }

    @Override
    public void setUMEAttributeNamespace(String namespace) {
        this.umeAttrNamespace = namespace;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.umeAttrAlias, this.umeAttrName, this.umeAttrNamespace, this.defaultValue, super.toString());
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }
}

