/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederation;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2IdentityFederationSetter;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public abstract class SAML2IdentityFederationImpl
extends SAML2CfgObject
implements SAML2IdentityFederation,
SAML2IdentityFederationSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2IdentityFederationImpl.class);
    private static final String TOSTRING_PATTERN = "cfg path: {0}, is supported: {1}, nameId format: {2}";
    public static final String CFG_PATH_IDENTITY_FEDERATIONS = "identity_federations";
    private static final String CFG_PROPERTY_SHEET = "cfg";
    private static final String KEY_IS_SUPPORTED = "supported";
    private static final String KEY_NAMEID_FORMAT = "nameid_format";
    private static final byte STATE_READING = 2;
    private static final byte STATE_WRITING = 4;
    private static final byte STATE_WRITTEN = 8;
    private byte state;
    private CfgPropertySetter propertySetter;
    private boolean isSupported;
    private String nameIdFormat;

    public SAML2IdentityFederationImpl() {
        this.state = (byte)4;
    }

    public SAML2IdentityFederationImpl(SAML2CfgObject parent, String cfgPath) {
        this(parent, cfgPath, false);
    }

    public SAML2IdentityFederationImpl(SAML2CfgObject parent, String cfgPath, boolean isWtiteMode) {
        super(parent, cfgPath, CFG_PROPERTY_SHEET, true);
        this.state = isWtiteMode ? (byte)4 : (byte)2;
    }

    public SAML2IdentityFederationImpl(boolean isSupported, String nameIdFormat) {
        this();
        this.isSupported = isSupported;
        this.nameIdFormat = nameIdFormat;
    }

    protected String readProperty(String key) {
        return this.readProperty(key, null);
    }

    protected String readProperty(String key, String defaultValue) {
        return this.getPropertyValue(key, defaultValue).getValue();
    }

    protected String[] readArrayProperty(String key) {
        return this.getPropertyValue(key, null).getValues();
    }

    protected void setProperty(String key, String value) {
        this.propertySetter.setProperty(key, value);
    }

    protected void setProperty(String key, String[] values) {
        this.propertySetter.setProperty(key, values);
    }

    protected void setProperty(String key, Boolean value) {
        this.propertySetter.setProperty(key, value != null ? "" + value : null);
    }

    protected void setProperty(String key, boolean value) {
        this.propertySetter.setProperty(key, "" + value);
    }

    protected void setProperty(String key, int value) {
        this.propertySetter.setProperty(key, "" + value);
    }

    protected Enum readEnumValue(String cfgKey, Class enumClass) {
        Enum result;
        block3: {
            result = null;
            String value = this.readProperty(cfgKey);
            if (value != null) {
                try {
                    result = (Enum)Enum.valueOf(enumClass, value);
                }
                catch (Exception e) {
                    if (!LOCATION.beDebug()) break block3;
                    LOCATION.debugT("Failed to create instance for enum " + enumClass + " with value " + value + ". Error is: " + e.getMessage());
                }
            }
        }
        return result;
    }

    protected void readConfiguration(boolean isWriteMode) {
        this.isSupported = Boolean.parseBoolean(this.readProperty(KEY_IS_SUPPORTED));
        this.nameIdFormat = this.readProperty(KEY_NAMEID_FORMAT);
    }

    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    protected abstract void createAndWriteConfiguration(SAML2CfgObject var1) throws CfgStorageException;

    protected void createConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        if (this.state != 4) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        this.setCfgPath(String.valueOf(parent.getCfgPath()) + "/" + CFG_PATH_IDENTITY_FEDERATIONS);
        this.createAndSetAnonymousSubCfg();
        this.setCfgPropertySheet(CFG_PROPERTY_SHEET);
        this.propertySetter = this.getPropertySetter();
    }

    protected void useExistingConfiguration(String cfgPath) {
        if (this.state != 4) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        this.setCfgPath(cfgPath);
        this.setCfgPropertySheet(CFG_PROPERTY_SHEET);
        this.propertySetter = this.getPropertySetter();
    }

    protected void writeConfiguration() throws CfgStorageException {
        if (this.state == 2) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        if (this.state == 8) {
            throw new IllegalStateException("This anonymous sub configuration is already written");
        }
        this.setProperty(KEY_IS_SUPPORTED, this.isSupported);
        this.setProperty(KEY_NAMEID_FORMAT, this.nameIdFormat);
        super.write(this.propertySetter);
        this.state = (byte)8;
    }

    @Override
    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    @Override
    public boolean isSupported() {
        return this.isSupported;
    }

    @Override
    public void setNameIdFormat(String nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    @Override
    public void setSupported(Boolean isSupported) {
        this.isSupported = isSupported;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, super.toString(), this.isSupported, this.nameIdFormat);
    }
}

