/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2CfgSetterFactory;
import com.sap.security.saml2.cfg.SAML2ModifiableTrustedIdPImpl;
import com.sap.security.saml2.cfg.SAML2TrustedIdPImpl;
import com.sap.security.saml2.cfg.enums.SAML2FederationModeTrustedIdP;
import com.sap.security.saml2.cfg.enums.SAML2UserIDMappingMode;
import com.sap.security.saml2.cfg.enums.SAML2UserIDSource;
import com.sap.security.saml2.cfg.enums.SPProvidedIDTrustedIdPOption;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2AuthorizationAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2DefaultAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederationTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2RuleEntry;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2TemplateUser;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2AuthorizationAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2DefaultAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2IdentityFederationTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2RuleEntrySetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2TemplateUserSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2AuthorizationAttributeTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2DefaultAttributeTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2IdentityFederationImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2IdentityFederationTrustedIdPOldDataImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2ProfileAttributeTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2TemplateUserImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SAML2IdentityFederationTrustedIdPImpl
extends SAML2IdentityFederationImpl
implements SAML2IdentityFederationTrustedIdP,
SAML2IdentityFederationTrustedIdPSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2IdentityFederationTrustedIdPImpl.class);
    protected static final String CFG_SUB_PATH_PROFILE_ATTRIBUTES = "profile_attributes";
    protected static final String CFG_SUB_PATH_AUTHORIZATION_ATTRIBUTES = "authz_attributes";
    protected static final String CFG_SUB_PATH_CONSTANT_ATTRIBUTES = "constant_attributes";
    protected static final String CFG_SUB_PATH_DEFAULT_ATTRIBUTES = "default_attributes";
    protected static final String CFG_SUB_PATH_TEMPLATE_USERS = "template_users";
    private static final String KEY_FEDERATION_MODE = "federation_mode";
    private static final String KEY_IS_ALLOW_CREATE = "allow_create";
    private static final String KEY_IS_INTERACTIVE_ACCOUNT_LINKING = "interactive_account_linking";
    private static final String KEY_IS_AUTOMATIC_ACCOUNT_CREATION = "automatic_account_creation";
    private static final String KEY_IS_TO_UPDATE_USER_ATTRIBUTES_AT_LOGIN = "update_user_attrs_at_login";
    private static final String KEY_IS_TO_LOCK_UPDATED_USERS = "lock_updated_users";
    private static final String KEY_USER_ID_SOURCE = "user_id_source";
    private static final String KEY_USER_MAPPING_MODE = "user_mapping_mode";
    private static final String KEY_UME_ATTRIBUTE_NAME = "ume_attr_name";
    private static final String KEY_UME_ATTRIBUTE_NAMESPACE = "ume_attr_namespace";
    private static final String KEY_ASSERTION_ATTRIBUTE_NAME = "assertion_attribute_name";
    private static final String KEY_USER_ID_FILTER = "user_id_filter";
    private static final String KEY_USER_ID_PREFIX = "user_id_prefix";
    private static final String KEY_USER_ID_SUFFIX = "user_id_suffix";
    private static final String KEY_SP_PROVIDED_ID_SOURCE = "sp_provided_id_source";
    private static final String KEY_SP_PROVIDED_ID_UME_ATTR_NAME = "sp_provided_id_ume_attr_name";
    private static final String KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE = "sp_provided_id_ume_attr_namespace";
    private static final String KEY_DEFAULT_GROUPS = "default_groups";
    private static final String KEY_DEFAULT_ROLES = "default_roles";
    private static final String KEY_DEFAULT_TEMPLATE_USER = "default_template_user";
    private SAML2FederationModeTrustedIdP federationMode;
    private boolean isAllowCreate;
    private boolean isAutomaticAccountCreationAllowed;
    private boolean isInteractiveAccountLinkingAllowed;
    private boolean updateUserDataAtLogin;
    private boolean lockUpdatedUsers;
    private SAML2UserIDSource userIDSource;
    private SAML2UserIDMappingMode userIDMappingMode;
    private String umeAttributeNamespace;
    private String umeAttributeName;
    private String assertionAttributeName;
    private String userIDFilter;
    private String userIDPrefix;
    private String userIDSuffix;
    private SPProvidedIDTrustedIdPOption spProvidedIdSource;
    private String spProvidedIdUMEAttributeName;
    private String spProvidedIdUMEAttributeNamespace;
    private Collection defaultAttributes = new ArrayList();
    private Collection<String> defaultGroups = new ArrayList<String>();
    private Collection<String> defaultRoles = new ArrayList<String>();
    private Collection assertionBasedAttributes = new ArrayList();
    private Collection assertionBasedAuthorizations = new ArrayList();
    private String defaultTemplateUser;
    private List templateUsers = new ArrayList();

    public SAML2IdentityFederationTrustedIdPImpl() {
    }

    public SAML2IdentityFederationTrustedIdPImpl(SAML2IdentityFederationTrustedIdPOldDataImpl oldIdentityFederationData) {
        super(oldIdentityFederationData.isSupported(), oldIdentityFederationData.getNameIdFormat());
        this.federationMode = oldIdentityFederationData.getFederationMode();
        this.isAllowCreate = oldIdentityFederationData.isAllowCreate();
        this.isAutomaticAccountCreationAllowed = oldIdentityFederationData.isAutomaticAccountCreationAllowed();
        this.isInteractiveAccountLinkingAllowed = oldIdentityFederationData.isInteractiveAccountLinkingAllowed();
        this.updateUserDataAtLogin = oldIdentityFederationData.isToUpdateUserDataAtLogin();
        this.lockUpdatedUsers = oldIdentityFederationData.isToLockUpdatedUsers();
        this.userIDSource = oldIdentityFederationData.getUserIDSource();
        this.userIDMappingMode = oldIdentityFederationData.getUserIDMappingMode();
        this.umeAttributeNamespace = oldIdentityFederationData.getUMEAttributeNamespace();
        this.umeAttributeName = oldIdentityFederationData.getUMEAttributeName();
        this.assertionAttributeName = oldIdentityFederationData.getAssertionAttributeName();
        this.userIDFilter = oldIdentityFederationData.getUserIDFilter();
        this.userIDPrefix = oldIdentityFederationData.getUserIDPrefix();
        this.userIDSuffix = oldIdentityFederationData.getUserIDSuffix();
        this.spProvidedIdSource = oldIdentityFederationData.getSPProvidedIdSource();
        this.spProvidedIdUMEAttributeName = oldIdentityFederationData.getSPProvidedIdUMEAttributeName();
        this.spProvidedIdUMEAttributeNamespace = oldIdentityFederationData.getSPProvidedIdUMEAttributeNamespace();
        this.defaultGroups = oldIdentityFederationData.getDefaultGroupsForUserCreation();
        this.defaultRoles = oldIdentityFederationData.getDefaultRolesForUserCreation();
        this.defaultTemplateUser = oldIdentityFederationData.getDefaultTemplateUser();
        this.defaultAttributes = this.getDefaultAttributeSetters(oldIdentityFederationData);
        this.assertionBasedAttributes = this.getAssertionBasedAttributeSetters(oldIdentityFederationData);
        this.assertionBasedAuthorizations = this.getAssertionBaseAuthorizationSetters(oldIdentityFederationData);
        this.templateUsers = this.getTemplateUserSetters(oldIdentityFederationData);
    }

    public SAML2IdentityFederationTrustedIdPImpl(SAML2TrustedIdPImpl parent, String cfgPath) {
        this(parent, cfgPath, false);
    }

    public SAML2IdentityFederationTrustedIdPImpl(SAML2TrustedIdPImpl parent, String cfgPath, boolean isUpdateMode) {
        super(parent, cfgPath, isUpdateMode);
        this.readConfiguration(isUpdateMode);
    }

    @Override
    public String getAssertionAttributeName() {
        return this.assertionAttributeName;
    }

    @Override
    public Collection<SAML2ProfileAttributeTrustedIdP> getAssertionBasedAttributes() {
        return this.assertionBasedAttributes;
    }

    @Override
    public Collection<SAML2AuthorizationAttributeTrustedIdP> getAssertionBasedAuthorizations() {
        return this.assertionBasedAuthorizations;
    }

    @Override
    public Collection<SAML2DefaultAttributeTrustedIdP> getDefaultAttributes() {
        return this.defaultAttributes;
    }

    @Override
    public Collection<String> getDefaultGroupsForUserCreation() {
        return this.defaultGroups;
    }

    @Override
    public Collection<String> getDefaultRolesForUserCreation() {
        return this.defaultRoles;
    }

    @Override
    public String getDefaultTemplateUser() {
        return this.defaultTemplateUser;
    }

    @Override
    public SAML2FederationModeTrustedIdP getFederationMode() {
        return this.federationMode;
    }

    @Override
    public SPProvidedIDTrustedIdPOption getSPProvidedIdSource() {
        return this.spProvidedIdSource;
    }

    @Override
    public String getSPProvidedIdUMEAttributeName() {
        return this.spProvidedIdUMEAttributeName;
    }

    @Override
    public String getSPProvidedIdUMEAttributeNamespace() {
        return this.spProvidedIdUMEAttributeNamespace;
    }

    @Override
    public List<SAML2TemplateUser> getTemplateUsers() {
        return this.templateUsers;
    }

    @Override
    public String getUMEAttributeName() {
        return this.umeAttributeName;
    }

    @Override
    public String getUMEAttributeNamespace() {
        return this.umeAttributeNamespace;
    }

    @Override
    public String getUserIDFilter() {
        return this.userIDFilter;
    }

    @Override
    public SAML2UserIDMappingMode getUserIDMappingMode() {
        return this.userIDMappingMode;
    }

    @Override
    public String getUserIDPrefix() {
        return this.userIDPrefix;
    }

    @Override
    public SAML2UserIDSource getUserIDSource() {
        return this.userIDSource;
    }

    @Override
    public String getUserIDSuffix() {
        return this.userIDSuffix;
    }

    @Override
    public boolean isAllowCreate() {
        return this.isAllowCreate;
    }

    @Override
    public boolean isAutomaticAccountCreationAllowed() {
        return this.isAutomaticAccountCreationAllowed;
    }

    @Override
    public boolean isInteractiveAccountLinkingAllowed() {
        return this.isInteractiveAccountLinkingAllowed;
    }

    @Override
    public boolean isToLockUpdatedUsers() {
        return this.lockUpdatedUsers;
    }

    @Override
    public boolean isToUpdateUserDataAtLogin() {
        return this.updateUserDataAtLogin;
    }

    @Override
    public void setAllowCreate(Boolean allowCreate) {
        this.isAllowCreate = allowCreate;
    }

    @Override
    public void setAssertionAttributeName(String attributeName) {
        this.assertionAttributeName = attributeName;
    }

    @Override
    public void setAssertionBasedAttributes(Collection<SAML2ProfileAttributeTrustedIdPSetter> assertionBasedAttributes) {
        this.assertionBasedAttributes = assertionBasedAttributes;
    }

    @Override
    public void setAssertionBasedAuthorizations(Collection<SAML2AuthorizationAttributeTrustedIdPSetter> assertionBasedAuthorizations) {
        this.assertionBasedAuthorizations = assertionBasedAuthorizations;
    }

    @Override
    public void setAutomaticAccountCreationAllowed(Boolean isAllowed) {
        this.isAutomaticAccountCreationAllowed = isAllowed;
    }

    @Override
    public void setDefaultAttributes(Collection<SAML2DefaultAttributeTrustedIdPSetter> defaultAttributes) {
        this.defaultAttributes = defaultAttributes;
    }

    @Override
    public void setDefaultGroupsForUserCreation(Collection<String> groupsUniqueIds) {
        this.defaultGroups = groupsUniqueIds;
    }

    @Override
    public void setDefaultRolesForUserCreation(Collection<String> rolesUniqueIds) {
        this.defaultRoles = rolesUniqueIds;
    }

    @Override
    public void setDefaultTemplateUser(String user) {
        this.defaultTemplateUser = user;
    }

    @Override
    public void setFederationMode(SAML2FederationModeTrustedIdP federationMode) {
        this.federationMode = federationMode;
    }

    @Override
    public void setInteractiveAccountLinkingAllowed(Boolean isAllowed) {
        this.isInteractiveAccountLinkingAllowed = isAllowed;
    }

    @Override
    public void setLockUpdatedUsers(boolean isToLock) {
        this.lockUpdatedUsers = isToLock;
    }

    @Override
    public void setSPProvidedIdSource(SPProvidedIDTrustedIdPOption source) {
        this.spProvidedIdSource = source;
    }

    @Override
    public void setSPProvidedIdUMEAttributeName(String umeName) {
        this.spProvidedIdUMEAttributeName = umeName;
    }

    @Override
    public void setSPProvidedIdUMEAttributeNamespace(String umeNamespace) {
        this.spProvidedIdUMEAttributeNamespace = umeNamespace;
    }

    @Override
    public void setTemplateUsers(List<SAML2TemplateUserSetter> templateUsers) {
        this.templateUsers = templateUsers;
    }

    @Override
    public void setUMEAttributeName(String attributeName) {
        this.umeAttributeName = attributeName;
    }

    @Override
    public void setUMEAttributeNamespace(String attributeNamespace) {
        this.umeAttributeNamespace = attributeNamespace;
    }

    @Override
    public void setUpdateUserDataAtLogin(Boolean isToUpdate) {
        this.updateUserDataAtLogin = isToUpdate;
    }

    @Override
    public void setUserIDFilter(String userIDFilter) {
        this.userIDFilter = userIDFilter;
    }

    @Override
    public void setUserIDMappingMode(SAML2UserIDMappingMode userIDMappingMode) {
        this.userIDMappingMode = userIDMappingMode;
    }

    @Override
    public void setUserIDPrefix(String userIDPrefix) {
        this.userIDPrefix = userIDPrefix;
    }

    @Override
    public void setUserIDSource(SAML2UserIDSource userIDSource) {
        this.userIDSource = userIDSource;
    }

    @Override
    public void setUserIDSuffix(String userIDSuffix) {
        this.userIDSuffix = userIDSuffix;
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isUpdateMode) {
        super.readConfiguration(isUpdateMode);
        this.federationMode = (SAML2FederationModeTrustedIdP)this.readEnumValue(KEY_FEDERATION_MODE, SAML2FederationModeTrustedIdP.class);
        this.isAllowCreate = Boolean.parseBoolean(this.readProperty(KEY_IS_ALLOW_CREATE));
        this.isInteractiveAccountLinkingAllowed = Boolean.parseBoolean(this.readProperty(KEY_IS_INTERACTIVE_ACCOUNT_LINKING));
        this.isAutomaticAccountCreationAllowed = Boolean.parseBoolean(this.readProperty(KEY_IS_AUTOMATIC_ACCOUNT_CREATION));
        this.updateUserDataAtLogin = Boolean.parseBoolean(this.readProperty(KEY_IS_TO_UPDATE_USER_ATTRIBUTES_AT_LOGIN));
        this.lockUpdatedUsers = Boolean.parseBoolean(this.readProperty(KEY_IS_TO_LOCK_UPDATED_USERS));
        this.userIDSource = (SAML2UserIDSource)this.readEnumValue(KEY_USER_ID_SOURCE, SAML2UserIDSource.class);
        this.userIDMappingMode = (SAML2UserIDMappingMode)this.readEnumValue(KEY_USER_MAPPING_MODE, SAML2UserIDMappingMode.class);
        this.umeAttributeName = this.readProperty(KEY_UME_ATTRIBUTE_NAME);
        this.umeAttributeNamespace = this.readProperty(KEY_UME_ATTRIBUTE_NAMESPACE);
        this.assertionAttributeName = this.readProperty(KEY_ASSERTION_ATTRIBUTE_NAME);
        this.userIDFilter = this.readProperty(KEY_USER_ID_FILTER);
        this.userIDPrefix = this.readProperty(KEY_USER_ID_PREFIX);
        this.userIDSuffix = this.readProperty(KEY_USER_ID_SUFFIX);
        this.spProvidedIdSource = (SPProvidedIDTrustedIdPOption)this.readEnumValue(KEY_SP_PROVIDED_ID_SOURCE, SPProvidedIDTrustedIdPOption.class);
        this.spProvidedIdUMEAttributeName = this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAME);
        this.spProvidedIdUMEAttributeNamespace = this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE);
        this.readUsers(isUpdateMode);
        this.readAttributesAndAuthorizations(isUpdateMode);
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        String cfgPathOfExistingIdentityFederation = ((SAML2ModifiableTrustedIdPImpl)parent).getCfgPathOfExistingIdentityFederation(this.getNameIdFormat());
        if (cfgPathOfExistingIdentityFederation != null) {
            this.useExistingConfiguration(cfgPathOfExistingIdentityFederation);
        } else {
            this.createConfiguration(parent);
        }
        this.setProperty(KEY_IS_ALLOW_CREATE, this.isAllowCreate);
        this.setProperty(KEY_IS_INTERACTIVE_ACCOUNT_LINKING, this.isInteractiveAccountLinkingAllowed);
        this.setProperty(KEY_IS_AUTOMATIC_ACCOUNT_CREATION, this.isAutomaticAccountCreationAllowed);
        this.setProperty(KEY_IS_TO_UPDATE_USER_ATTRIBUTES_AT_LOGIN, this.updateUserDataAtLogin);
        this.setProperty(KEY_IS_TO_LOCK_UPDATED_USERS, this.lockUpdatedUsers);
        if (this.federationMode != null) {
            this.setProperty(KEY_FEDERATION_MODE, this.federationMode.toString());
        }
        if (this.userIDSource != null) {
            this.setProperty(KEY_USER_ID_SOURCE, this.userIDSource.toString());
        }
        if (this.userIDMappingMode != null) {
            this.setProperty(KEY_USER_MAPPING_MODE, this.userIDMappingMode.toString());
        }
        this.setProperty(KEY_UME_ATTRIBUTE_NAME, this.umeAttributeName);
        this.setProperty(KEY_UME_ATTRIBUTE_NAMESPACE, this.umeAttributeNamespace);
        this.setProperty(KEY_ASSERTION_ATTRIBUTE_NAME, this.assertionAttributeName);
        this.setProperty(KEY_USER_ID_FILTER, this.userIDFilter);
        this.setProperty(KEY_USER_ID_PREFIX, this.userIDPrefix);
        this.setProperty(KEY_USER_ID_SUFFIX, this.userIDSuffix);
        if (this.spProvidedIdSource != null) {
            this.setProperty(KEY_SP_PROVIDED_ID_SOURCE, this.spProvidedIdSource.toString());
        }
        this.setProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAME, this.spProvidedIdUMEAttributeName);
        this.setProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE, this.spProvidedIdUMEAttributeNamespace);
        this.writeUsers();
        this.writeAttributesAndAuthorizations();
        super.writeConfiguration();
    }

    private void readUsers(boolean isWriteMode) {
        this.defaultTemplateUser = this.readProperty(KEY_DEFAULT_TEMPLATE_USER);
        String[] templateUserSheets = null;
        try {
            templateUserSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_TEMPLATE_USERS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load template users for user mappings in trusted IdP persistent nameId-format", (Throwable)e);
        }
        if (templateUserSheets != null) {
            String[] stringArray = templateUserSheets;
            int n = templateUserSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String templateUserSheet = stringArray[n2];
                SAML2TemplateUserImpl templateUser = new SAML2TemplateUserImpl(this, CFG_SUB_PATH_TEMPLATE_USERS, templateUserSheet, isWriteMode);
                this.templateUsers.add(templateUser);
                ++n2;
            }
        }
    }

    private void writeUsers() throws CfgStorageException {
        this.setProperty(KEY_DEFAULT_TEMPLATE_USER, this.defaultTemplateUser);
        this.deleteSubConfiguration(CFG_SUB_PATH_TEMPLATE_USERS);
        if (this.templateUsers != null) {
            for (Object obj : this.templateUsers) {
                if (obj == null) continue;
                SAML2TemplateUserImpl templateUser = (SAML2TemplateUserImpl)obj;
                templateUser.createAndWriteConfiguration(this, CFG_SUB_PATH_TEMPLATE_USERS);
            }
        }
    }

    private void readAttributesAndAuthorizations(boolean isWriteMode) {
        int n;
        String[] dbDefaultRoles;
        String[] dbDefaultGroups = this.readArrayProperty(KEY_DEFAULT_GROUPS);
        if (dbDefaultGroups != null && dbDefaultGroups.length > 0) {
            this.defaultGroups = Arrays.asList(dbDefaultGroups);
        }
        if ((dbDefaultRoles = this.readArrayProperty(KEY_DEFAULT_ROLES)) != null && dbDefaultRoles.length > 0) {
            this.defaultRoles = Arrays.asList(dbDefaultRoles);
        }
        String[] profileAttributeSheets = null;
        try {
            profileAttributeSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_PROFILE_ATTRIBUTES);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load profile attributes for nameId format " + this.getNameIdFormat(), (Throwable)e);
        }
        if (profileAttributeSheets != null) {
            String[] stringArray = profileAttributeSheets;
            n = profileAttributeSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String profileAttributeSheet = stringArray[n2];
                SAML2ProfileAttributeTrustedIdPImpl profileAttribute = new SAML2ProfileAttributeTrustedIdPImpl(this, CFG_SUB_PATH_PROFILE_ATTRIBUTES, profileAttributeSheet, isWriteMode);
                this.assertionBasedAttributes.add(profileAttribute);
                ++n2;
            }
        }
        String[] authzAttributeSubNodes = null;
        try {
            authzAttributeSubNodes = this.getSubCfgPaths(CFG_SUB_PATH_AUTHORIZATION_ATTRIBUTES);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load authorization attributes for nameId format " + this.getNameIdFormat(), (Throwable)e);
        }
        if (authzAttributeSubNodes != null) {
            String[] stringArray = authzAttributeSubNodes;
            int n3 = authzAttributeSubNodes.length;
            n = 0;
            while (n < n3) {
                String authzAttributeSubNode = stringArray[n];
                SAML2AuthorizationAttributeTrustedIdPImpl authzAttribute = new SAML2AuthorizationAttributeTrustedIdPImpl(authzAttributeSubNode, isWriteMode);
                this.assertionBasedAuthorizations.add(authzAttribute);
                ++n;
            }
        }
        String[] defaultAttributeSheets = null;
        try {
            defaultAttributeSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_DEFAULT_ATTRIBUTES);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load default attributes for nameId format " + this.getNameIdFormat(), (Throwable)e);
        }
        if (defaultAttributeSheets != null) {
            String[] stringArray = defaultAttributeSheets;
            int n4 = defaultAttributeSheets.length;
            int n5 = 0;
            while (n5 < n4) {
                String defaultAttributeSheet = stringArray[n5];
                SAML2DefaultAttributeTrustedIdPImpl defaultAttribute = new SAML2DefaultAttributeTrustedIdPImpl(this, CFG_SUB_PATH_DEFAULT_ATTRIBUTES, defaultAttributeSheet, isWriteMode);
                this.defaultAttributes.add(defaultAttribute);
                ++n5;
            }
        }
    }

    private void writeAttributesAndAuthorizations() throws CfgStorageException {
        SAML2AnonymousSubCfgObjectBase profileAttribute;
        String[] dbDefaultGroups = null;
        if (this.defaultGroups != null) {
            dbDefaultGroups = this.defaultGroups.toArray(new String[this.defaultGroups.size()]);
        }
        this.setProperty(KEY_DEFAULT_GROUPS, dbDefaultGroups);
        String[] dbDefaultRoles = null;
        if (this.defaultRoles != null) {
            dbDefaultRoles = this.defaultRoles.toArray(new String[this.defaultRoles.size()]);
        }
        this.setProperty(KEY_DEFAULT_ROLES, dbDefaultRoles);
        this.deleteSubConfiguration(CFG_SUB_PATH_PROFILE_ATTRIBUTES);
        if (this.assertionBasedAttributes != null) {
            for (Object obj : this.assertionBasedAttributes) {
                if (obj == null) continue;
                profileAttribute = (SAML2ProfileAttributeTrustedIdPImpl)obj;
                ((SAML2ProfileAttributeTrustedIdPImpl)profileAttribute).createAndWriteConfiguration(this, CFG_SUB_PATH_PROFILE_ATTRIBUTES);
            }
        }
        this.deleteSubConfiguration(CFG_SUB_PATH_AUTHORIZATION_ATTRIBUTES);
        if (this.assertionBasedAuthorizations != null) {
            for (Object obj : this.assertionBasedAuthorizations) {
                if (obj == null) continue;
                profileAttribute = (SAML2AuthorizationAttributeTrustedIdPImpl)obj;
                ((SAML2AuthorizationAttributeTrustedIdPImpl)profileAttribute).createAndWriteConfiguration(this, CFG_SUB_PATH_AUTHORIZATION_ATTRIBUTES);
            }
        }
        this.deleteSubConfiguration(CFG_SUB_PATH_DEFAULT_ATTRIBUTES);
        if (this.defaultAttributes != null) {
            for (Object obj : this.defaultAttributes) {
                if (obj == null) continue;
                SAML2DefaultAttributeTrustedIdPImpl defaultAttribute = (SAML2DefaultAttributeTrustedIdPImpl)obj;
                defaultAttribute.createAndWriteConfiguration(this, CFG_SUB_PATH_DEFAULT_ATTRIBUTES);
            }
        }
    }

    private Collection<SAML2DefaultAttributeTrustedIdPSetter> getDefaultAttributeSetters(SAML2IdentityFederationTrustedIdPOldDataImpl oldIdentityFederationData) {
        Collection<SAML2DefaultAttributeTrustedIdP> oldDefaultAttributes = oldIdentityFederationData.getDefaultAttributes();
        if (oldDefaultAttributes == null) {
            return null;
        }
        ArrayList<SAML2DefaultAttributeTrustedIdPSetter> result = new ArrayList<SAML2DefaultAttributeTrustedIdPSetter>();
        for (SAML2DefaultAttributeTrustedIdP oldDefaultAttribute : oldDefaultAttributes) {
            SAML2DefaultAttributeTrustedIdPSetter setter = SAML2CfgSetterFactory.getInstance().createSAML2DefaultAttributeTrustedIdP();
            setter.setDefaultValue(oldDefaultAttribute.getDefaultValue());
            setter.setUMEAttributeAlias(oldDefaultAttribute.getUMEAttributeAlias());
            setter.setUMEAttributeName(oldDefaultAttribute.getUMEAttributeName());
            setter.setUMEAttributeNamespace(oldDefaultAttribute.getUMEAttributeNamespace());
            result.add(setter);
        }
        return result;
    }

    private Collection<SAML2ProfileAttributeTrustedIdPSetter> getAssertionBasedAttributeSetters(SAML2IdentityFederationTrustedIdPOldDataImpl oldIdentityFederationData) {
        Collection<SAML2ProfileAttributeTrustedIdP> oldAssertionBasedAttributes = oldIdentityFederationData.getAssertionBasedAttributes();
        if (oldAssertionBasedAttributes == null) {
            return null;
        }
        ArrayList<SAML2ProfileAttributeTrustedIdPSetter> result = new ArrayList<SAML2ProfileAttributeTrustedIdPSetter>();
        for (SAML2ProfileAttributeTrustedIdP oldAssertionAttribute : oldAssertionBasedAttributes) {
            SAML2ProfileAttributeTrustedIdPSetter setter = SAML2CfgSetterFactory.getInstance().createSAML2ProfileAttributeTrustedIdP();
            setter.setMandatory(oldAssertionAttribute.isMandatory());
            setter.setSAML2AttributeName(oldAssertionAttribute.getSAML2AttributeName());
            setter.setUMEAttributeAlias(oldAssertionAttribute.getUMEAttributeAlias());
            setter.setUMEAttributeName(oldAssertionAttribute.getUMEAttributeName());
            setter.setUMEAttributeNamespace(oldAssertionAttribute.getUMEAttributeNamespace());
            result.add(setter);
        }
        return result;
    }

    private Collection<SAML2AuthorizationAttributeTrustedIdPSetter> getAssertionBaseAuthorizationSetters(SAML2IdentityFederationTrustedIdPOldDataImpl oldIdentityFederationData) {
        Collection<SAML2AuthorizationAttributeTrustedIdP> oldAssertionBasedAuthorizations = oldIdentityFederationData.getAssertionBasedAuthorizations();
        if (oldAssertionBasedAuthorizations == null) {
            return null;
        }
        ArrayList<SAML2AuthorizationAttributeTrustedIdPSetter> result = new ArrayList<SAML2AuthorizationAttributeTrustedIdPSetter>();
        for (SAML2AuthorizationAttributeTrustedIdP oldAssertionBasedAuthorization : oldAssertionBasedAuthorizations) {
            SAML2AuthorizationAttributeTrustedIdPSetter authorizationAttributeSetter = SAML2CfgSetterFactory.getInstance().createSAML2AuthorizationAttributeTrustedIdP();
            authorizationAttributeSetter.setAuthorizationNames(oldAssertionBasedAuthorization.getAuthorizationNames());
            authorizationAttributeSetter.setAuthorizationType(oldAssertionBasedAuthorization.getAuthorizationType());
            ArrayList<SAML2RuleEntrySetter> ruleSetters = new ArrayList<SAML2RuleEntrySetter>();
            for (SAML2RuleEntry ruleEntry : oldAssertionBasedAuthorization.getRules()) {
                SAML2RuleEntrySetter ruleSetter = SAML2CfgSetterFactory.getInstance().createSAML2RuleEntry();
                ruleSetter.setAttributeName(ruleEntry.getAttributeName());
                ruleSetter.setAttributeValues(ruleEntry.getAttributeValues());
                ruleSetters.add(ruleSetter);
            }
            authorizationAttributeSetter.setRules(ruleSetters);
            result.add(authorizationAttributeSetter);
        }
        return result;
    }

    private List<SAML2TemplateUserSetter> getTemplateUserSetters(SAML2IdentityFederationTrustedIdPOldDataImpl oldIdentityFederationData) {
        List<SAML2TemplateUser> oldTemplateUsers = oldIdentityFederationData.getTemplateUsers();
        if (oldTemplateUsers == null) {
            return null;
        }
        ArrayList<SAML2TemplateUserSetter> result = new ArrayList<SAML2TemplateUserSetter>();
        for (SAML2TemplateUser oldTemplateUser : oldTemplateUsers) {
            SAML2TemplateUserSetter setter = SAML2CfgSetterFactory.getInstance().createSAML2TemplateUser();
            setter.setGroupRuleEntries(oldTemplateUser.getGroupRuleEntries());
            setter.setRoleRuleEntries(oldTemplateUser.getRoleRuleEntries());
            setter.setUser(oldTemplateUser.getUser());
            result.add(setter);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", federation mode: ");
        builder.append((Object)this.federationMode);
        builder.append(", user id source: ");
        builder.append((Object)this.userIDSource);
        builder.append(", assertion attribute name: ");
        builder.append(this.assertionAttributeName);
        builder.append(", user id filter: ");
        builder.append(this.userIDFilter);
        builder.append(", user id prefix: ");
        builder.append(this.userIDPrefix);
        builder.append(", user id suffix: ");
        builder.append(this.userIDSuffix);
        builder.append(", user id mapping mode: ");
        builder.append((Object)this.userIDMappingMode);
        builder.append(", UME attribute namespace: ");
        builder.append(this.umeAttributeNamespace);
        builder.append(", UME attribute name: ");
        builder.append(this.umeAttributeName);
        builder.append(", allow create: ");
        builder.append(this.isAllowCreate);
        builder.append(", automatic account creation allowed: ");
        builder.append(this.isAutomaticAccountCreationAllowed);
        builder.append(", interactive account linking allowed: ");
        builder.append(this.isInteractiveAccountLinkingAllowed);
        builder.append(", update user data at login: ");
        builder.append(this.updateUserDataAtLogin);
        builder.append(", lock updated users: ");
        builder.append(this.lockUpdatedUsers);
        builder.append(", SPProvidedId source: ");
        builder.append((Object)this.spProvidedIdSource);
        builder.append(", SPProvidedId UME attribute namespace: ");
        builder.append(this.spProvidedIdUMEAttributeNamespace);
        builder.append(", SPProvidedId UME attribute name: ");
        builder.append(this.spProvidedIdUMEAttributeName);
        builder.append(", default groups: ");
        builder.append(this.defaultGroups);
        builder.append(", default roles: ");
        builder.append(this.defaultRoles);
        builder.append("\n  default user attributes: ");
        builder.append(this.defaultAttributes);
        builder.append("\n  assertion-based user attributes: ");
        builder.append(this.assertionBasedAttributes);
        builder.append("\n  assertion-based authorizations: ");
        builder.append(this.assertionBasedAuthorizations);
        builder.append("\n  default template user: ");
        builder.append(this.defaultTemplateUser);
        builder.append("\n  template users: ");
        builder.append(this.templateUsers);
        return builder.toString();
    }
}

