/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.enums.NameIdFormatKerberosTrustedIdPOption;
import com.sap.security.saml2.cfg.enums.NameIdFormatUnspecifiedOption;
import com.sap.security.saml2.cfg.enums.NameIdFormatWindowsOption;
import com.sap.security.saml2.cfg.enums.SAML2FederationModeTrustedIdP;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SAML2UserIDMappingMode;
import com.sap.security.saml2.cfg.enums.SAML2UserIDSource;
import com.sap.security.saml2.cfg.enums.SPProvidedIDTrustedIdPOption;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2AuthorizationAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2DefaultAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2IdentityFederationTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmailTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecifiedTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindowsTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2TemplateUser;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedIdP;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class SAML2IdentityFederationTrustedIdPOldDataImpl
implements SAML2IdentityFederationTrustedIdP,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isSupported;
    private String nameIdFormat;
    private SAML2UserIDSource userIDSource = SAML2UserIDSource.ASSERTION_SUBJECT_NAME_ID;
    private SAML2FederationModeTrustedIdP federationMode;
    private SAML2UserIDMappingMode userIDMappingMode;
    private String userIDSuffix;
    private String userIDFilter;
    private String umeAttributeNamespace;
    private String umeAttributeName;
    private boolean isAllowCreate;
    private boolean isAutomaticAccountCreationAllowed;
    private boolean isInteractiveAccountLinkingAllowed;
    private boolean updateUserDataAtLogin;
    private boolean lockUpdatedUsers;
    private Collection<SAML2DefaultAttributeTrustedIdP> defaultAttributes = new ArrayList<SAML2DefaultAttributeTrustedIdP>(0);
    private Collection<String> defaultGroups = new ArrayList<String>(0);
    private Collection<String> defaultRoles = new ArrayList<String>(0);
    private Collection<SAML2ProfileAttributeTrustedIdP> assertionBasedAttributes = new ArrayList<SAML2ProfileAttributeTrustedIdP>(0);
    private Collection<SAML2AuthorizationAttributeTrustedIdP> assertionBasedAuthorizations = new ArrayList<SAML2AuthorizationAttributeTrustedIdP>(0);
    private List<SAML2TemplateUser> templateUsers = new ArrayList<SAML2TemplateUser>(0);
    private String defaultTemplateUser;
    private SPProvidedIDTrustedIdPOption spProvidedIdSource;
    private String spProvidedIdUMEAttributeName;
    private String spProvidedIdUMEAttributeNamespace;

    public SAML2IdentityFederationTrustedIdPOldDataImpl(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration, String trustedIdPName) {
        this.isSupported = oldNameIdFormatConfiguration.isSupported();
        SAML2NameIdFormat nameIdFormatType = oldNameIdFormatConfiguration.getNameIdFormat();
        this.nameIdFormat = nameIdFormatType.getName();
        if (nameIdFormatType == SAML2NameIdFormat.UNSPECIFIED) {
            this.populateUnspecifiedNameIdFormat(oldNameIdFormatConfiguration);
        } else if (nameIdFormatType == SAML2NameIdFormat.E_MAIL) {
            this.populateEmailNameIdFormat(oldNameIdFormatConfiguration);
        } else if (nameIdFormatType == SAML2NameIdFormat.KERBEROS) {
            this.populateKerberosNameIdFormat(oldNameIdFormatConfiguration);
        } else if (nameIdFormatType == SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME) {
            this.populateWindowsNameIdFormat(oldNameIdFormatConfiguration);
        } else if (nameIdFormatType == SAML2NameIdFormat.X509_SUBJECT_NAME) {
            this.populateX509NameIdFormat(oldNameIdFormatConfiguration);
        } else if (nameIdFormatType == SAML2NameIdFormat.PERSISTENT) {
            this.populatePersistentNameIdFormat(oldNameIdFormatConfiguration);
        } else if (nameIdFormatType == SAML2NameIdFormat.TRANSIENT) {
            this.populateTransientNameIdFormat(oldNameIdFormatConfiguration, trustedIdPName);
        } else {
            throw new IllegalStateException("Unknown nameId format: " + this.nameIdFormat);
        }
    }

    private void populateUnspecifiedNameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration) {
        SAML2NameIdFormatUnspecifiedTrustedIdP nameIdFormatUnspecified = (SAML2NameIdFormatUnspecifiedTrustedIdP)((Object)oldNameIdFormatConfiguration);
        this.isAllowCreate = nameIdFormatUnspecified.isAllowCreate();
        this.federationMode = this.isAllowCreate ? SAML2FederationModeTrustedIdP.PERSISTENT_USERS_ADVANCED : SAML2FederationModeTrustedIdP.PERSISTENT_USERS_SIMPLE;
        NameIdFormatUnspecifiedOption type = nameIdFormatUnspecified.getType();
        if (type == NameIdFormatUnspecifiedOption.LOGON_ID) {
            this.userIDMappingMode = SAML2UserIDMappingMode.LOGON_ID;
        } else if (type == NameIdFormatUnspecifiedOption.LOGON_ALIAS) {
            this.userIDMappingMode = SAML2UserIDMappingMode.LOGON_ALIAS;
        } else if (type == NameIdFormatUnspecifiedOption.USER_ATTRIBUTE) {
            this.userIDMappingMode = SAML2UserIDMappingMode.USER_ATTRIBUTE;
            this.umeAttributeNamespace = nameIdFormatUnspecified.getUMEAttributeNamespace();
            this.umeAttributeName = nameIdFormatUnspecified.getUMEAttributeName();
        }
    }

    private void populateEmailNameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration) {
        SAML2NameIdFormatEmailTrustedIdP nameIdFormatEmail = (SAML2NameIdFormatEmailTrustedIdP)((Object)oldNameIdFormatConfiguration);
        this.userIDMappingMode = SAML2UserIDMappingMode.EMAIL;
        this.umeAttributeNamespace = nameIdFormatEmail.getUMEAttributeNamespace();
        this.umeAttributeName = nameIdFormatEmail.getUMEAttributeName();
        if (nameIdFormatEmail.areAllDomainsAccepted()) {
            this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_SIMPLE;
        } else {
            this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_ADVANCED;
            Set<String> acceptedDomains = nameIdFormatEmail.getAcceptedDomains();
            this.userIDFilter = this.convertEmailDomainsToRegularExpression(acceptedDomains);
        }
    }

    private void populateKerberosNameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration) {
        SAML2NameIdFormatKerberosTrustedIdP nameIdFormatKerberos = (SAML2NameIdFormatKerberosTrustedIdP)((Object)oldNameIdFormatConfiguration);
        if (nameIdFormatKerberos.areAllRealmsAccepted()) {
            this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_SIMPLE;
        } else {
            this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_ADVANCED;
            Set<String> acceptedRealms = nameIdFormatKerberos.getAcceptedRealms();
            this.userIDFilter = this.convertKerberosRealmsToRegularExpression(acceptedRealms);
        }
        if (nameIdFormatKerberos.getType() == NameIdFormatKerberosTrustedIdPOption.ADS_DATA_SOURCE) {
            this.userIDMappingMode = SAML2UserIDMappingMode.KERBEROS_PRINCIPAL_NAME;
        } else if (nameIdFormatKerberos.getType() == NameIdFormatKerberosTrustedIdPOption.USER_ATTRIBUTE) {
            this.userIDMappingMode = SAML2UserIDMappingMode.USER_ATTRIBUTE;
            this.umeAttributeNamespace = nameIdFormatKerberos.getUMEAttributeNamespace();
            this.umeAttributeName = nameIdFormatKerberos.getUMEAttributeName();
        }
    }

    private void populateWindowsNameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration) {
        SAML2NameIdFormatWindowsTrustedIdP nameIdFormatWindows = (SAML2NameIdFormatWindowsTrustedIdP)((Object)oldNameIdFormatConfiguration);
        if (nameIdFormatWindows.areAllDomainsAccepted()) {
            this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_SIMPLE;
        } else {
            this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_ADVANCED;
            Set<String> acceptedDomains = nameIdFormatWindows.getAcceptedDomains();
            this.userIDFilter = this.convertWindowsDomainsToRegularExpression(acceptedDomains);
        }
        if (nameIdFormatWindows.getType() == NameIdFormatWindowsOption.ADS_DATA_SOURCE) {
            this.userIDMappingMode = SAML2UserIDMappingMode.WINDOWS_NAME;
        } else if (nameIdFormatWindows.getType() == NameIdFormatWindowsOption.USER_ATTRIBUTE) {
            this.userIDMappingMode = SAML2UserIDMappingMode.USER_ATTRIBUTE;
            this.umeAttributeNamespace = nameIdFormatWindows.getUMEAttributeNamespace();
            this.umeAttributeName = nameIdFormatWindows.getUMEAttributeName();
        }
    }

    private void populateX509NameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration) {
        SAML2NameIdFormatX509TrustedIdP nameIdFormatX509 = (SAML2NameIdFormatX509TrustedIdP)((Object)oldNameIdFormatConfiguration);
        this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_SIMPLE;
        this.userIDMappingMode = SAML2UserIDMappingMode.USER_ATTRIBUTE;
        this.umeAttributeNamespace = nameIdFormatX509.getUMEAttributeNamespace();
        this.umeAttributeName = nameIdFormatX509.getUMEAttributeName();
    }

    private void populatePersistentNameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration) {
        SAML2NameIdFormatPersistentTrustedIdP nameIdFormatPersistent = (SAML2NameIdFormatPersistentTrustedIdP)((Object)oldNameIdFormatConfiguration);
        this.federationMode = SAML2FederationModeTrustedIdP.PERSISTENT_USERS_ADVANCED;
        this.userIDMappingMode = SAML2UserIDMappingMode.USER_ATTRIBUTE;
        this.umeAttributeNamespace = nameIdFormatPersistent.getUMEAttributeNamespace();
        this.umeAttributeName = nameIdFormatPersistent.getUMEAttributeName();
        this.isAllowCreate = nameIdFormatPersistent.isAllowCreate();
        this.isInteractiveAccountLinkingAllowed = nameIdFormatPersistent.isInteractiveAccountLinking();
        this.isAutomaticAccountCreationAllowed = nameIdFormatPersistent.isAutomaticAccountCreation();
        this.updateUserDataAtLogin = nameIdFormatPersistent.isToUpdateUserAttributesAtLogin();
        this.lockUpdatedUsers = nameIdFormatPersistent.isToLockUpdatedUsers();
        this.defaultAttributes = nameIdFormatPersistent.getDefaultAttributes();
        this.assertionBasedAttributes = nameIdFormatPersistent.getProfileAttributes();
        this.defaultGroups = nameIdFormatPersistent.getDefaultGroupsForAutomaticUserCreation();
        this.defaultRoles = nameIdFormatPersistent.getDefaultRolesForAutomaticUserCreation();
        this.assertionBasedAuthorizations = nameIdFormatPersistent.getAuthorizationAttributes();
        this.templateUsers = nameIdFormatPersistent.getTemplateUsers();
        this.defaultTemplateUser = nameIdFormatPersistent.getDefaultTemplateUser();
        this.spProvidedIdSource = nameIdFormatPersistent.getSPProvidedIdSource();
        this.spProvidedIdUMEAttributeName = nameIdFormatPersistent.getSPProvidedIdUMEAttributeName();
        this.spProvidedIdUMEAttributeNamespace = nameIdFormatPersistent.getSPProvidedIdUMEAttributeNamespace();
    }

    private void populateTransientNameIdFormat(SAML2NameIdFormatCfgObjectBaseTrustedIdP oldNameIdFormatConfiguration, String trustedIdPName) {
        SAML2NameIdFormatTransientTrustedIdP nameIdFormatTransient = (SAML2NameIdFormatTransientTrustedIdP)((Object)oldNameIdFormatConfiguration);
        this.federationMode = SAML2FederationModeTrustedIdP.VIRTUAL_USERS;
        this.userIDMappingMode = SAML2UserIDMappingMode.LOGON_ID;
        this.userIDSuffix = "@" + trustedIdPName;
        this.defaultAttributes = nameIdFormatTransient.getDefaultAttributes();
        this.assertionBasedAttributes = nameIdFormatTransient.getProfileAttributes();
        this.defaultGroups = nameIdFormatTransient.getDefaultGroupsForVirtualUserCreation();
        this.defaultRoles = nameIdFormatTransient.getDefaultRolesForVirtualUserCreation();
        this.assertionBasedAuthorizations = nameIdFormatTransient.getAuthorizationAttributes();
        this.templateUsers = nameIdFormatTransient.getTemplateUsers();
        this.defaultTemplateUser = nameIdFormatTransient.getDefaultTemplateUser();
    }

    @Override
    public String getAssertionAttributeName() {
        return null;
    }

    @Override
    public Collection<SAML2ProfileAttributeTrustedIdP> getAssertionBasedAttributes() {
        return this.assertionBasedAttributes;
    }

    @Override
    public Collection<SAML2AuthorizationAttributeTrustedIdP> getAssertionBasedAuthorizations() {
        return this.assertionBasedAuthorizations;
    }

    @Override
    public Collection<SAML2DefaultAttributeTrustedIdP> getDefaultAttributes() {
        return this.defaultAttributes;
    }

    @Override
    public Collection<String> getDefaultGroupsForUserCreation() {
        return this.defaultGroups;
    }

    @Override
    public Collection<String> getDefaultRolesForUserCreation() {
        return this.defaultRoles;
    }

    @Override
    public String getDefaultTemplateUser() {
        return this.defaultTemplateUser;
    }

    @Override
    public SAML2FederationModeTrustedIdP getFederationMode() {
        return this.federationMode;
    }

    @Override
    public SPProvidedIDTrustedIdPOption getSPProvidedIdSource() {
        return this.spProvidedIdSource;
    }

    @Override
    public String getSPProvidedIdUMEAttributeName() {
        return this.spProvidedIdUMEAttributeName;
    }

    @Override
    public String getSPProvidedIdUMEAttributeNamespace() {
        return this.spProvidedIdUMEAttributeNamespace;
    }

    @Override
    public List<SAML2TemplateUser> getTemplateUsers() {
        return this.templateUsers;
    }

    @Override
    public String getUMEAttributeName() {
        return this.umeAttributeName;
    }

    @Override
    public String getUMEAttributeNamespace() {
        return this.umeAttributeNamespace;
    }

    @Override
    public String getUserIDFilter() {
        return this.userIDFilter;
    }

    @Override
    public SAML2UserIDMappingMode getUserIDMappingMode() {
        return this.userIDMappingMode;
    }

    @Override
    public String getUserIDPrefix() {
        return null;
    }

    @Override
    public SAML2UserIDSource getUserIDSource() {
        return this.userIDSource;
    }

    @Override
    public String getUserIDSuffix() {
        return this.userIDSuffix;
    }

    @Override
    public boolean isAllowCreate() {
        return this.isAllowCreate;
    }

    @Override
    public boolean isAutomaticAccountCreationAllowed() {
        return this.isAutomaticAccountCreationAllowed;
    }

    @Override
    public boolean isInteractiveAccountLinkingAllowed() {
        return this.isInteractiveAccountLinkingAllowed;
    }

    @Override
    public boolean isToLockUpdatedUsers() {
        return this.lockUpdatedUsers;
    }

    @Override
    public boolean isToUpdateUserDataAtLogin() {
        return this.updateUserDataAtLogin;
    }

    @Override
    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    @Override
    public boolean isSupported() {
        return this.isSupported;
    }

    private String convertEmailDomainsToRegularExpression(Set<String> acceptedValues) {
        if (acceptedValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String acceptedValue : acceptedValues) {
            if (index > 0) {
                result.append("|");
            }
            ++index;
            result.append(".+\\Q@");
            result.append(acceptedValue.toLowerCase(Locale.ENGLISH));
            result.append("\\E");
        }
        return result.toString();
    }

    private String convertKerberosRealmsToRegularExpression(Set<String> acceptedValues) {
        if (acceptedValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String acceptedValue : acceptedValues) {
            if (index > 0) {
                result.append("|");
            }
            ++index;
            result.append(".+\\Q@");
            result.append(acceptedValue);
            result.append("\\E");
        }
        return result.toString();
    }

    private String convertWindowsDomainsToRegularExpression(Set<String> acceptedValues) {
        if (acceptedValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        for (String acceptedValue : acceptedValues) {
            if (index > 0) {
                result.append("|");
            }
            ++index;
            result.append("\\Q");
            result.append(acceptedValue);
            result.append("\\E\\\\.+");
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("is supported: ");
        builder.append(this.isSupported);
        builder.append(", nameId format: ");
        builder.append(this.nameIdFormat);
        builder.append(", federation mode: ");
        builder.append((Object)this.federationMode);
        builder.append(", user id source: ");
        builder.append((Object)this.userIDSource);
        builder.append(", assertion attribute name: ");
        builder.append("null");
        builder.append(", user id filter: ");
        builder.append(this.userIDFilter);
        builder.append(", user id prefix: ");
        builder.append("null");
        builder.append(", user id suffix: ");
        builder.append(this.userIDSuffix);
        builder.append(", user id mapping mode: ");
        builder.append((Object)this.userIDMappingMode);
        builder.append(", UME attribute namespace: ");
        builder.append(this.umeAttributeNamespace);
        builder.append(", UME attribute name: ");
        builder.append(this.umeAttributeName);
        builder.append(", allow create: ");
        builder.append(this.isAllowCreate);
        builder.append(", automatic account creation allowed: ");
        builder.append(this.isAutomaticAccountCreationAllowed);
        builder.append(", interactive account linking allowed: ");
        builder.append(this.isInteractiveAccountLinkingAllowed);
        builder.append(", update user data at login: ");
        builder.append(this.updateUserDataAtLogin);
        builder.append(", lock updated users: ");
        builder.append(this.lockUpdatedUsers);
        builder.append(", SPProvidedId source: ");
        builder.append((Object)this.spProvidedIdSource);
        builder.append(", SPProvidedId UME attribute namespace: ");
        builder.append(this.spProvidedIdUMEAttributeNamespace);
        builder.append(", SPProvidedId UME attribute name: ");
        builder.append(this.spProvidedIdUMEAttributeName);
        builder.append(", default groups: ");
        builder.append(this.defaultGroups);
        builder.append(", default roles: ");
        builder.append(this.defaultRoles);
        builder.append("\n  default user attributes: ");
        builder.append(this.defaultAttributes);
        builder.append("\n  assertion-based user attributes: ");
        builder.append(this.assertionBasedAttributes);
        builder.append("\n  assertion-based authorizations: ");
        builder.append(this.assertionBasedAuthorizations);
        builder.append("\n  default template user: ");
        builder.append(this.defaultTemplateUser);
        builder.append("\n  template users: ");
        builder.append(this.templateUsers);
        return builder.toString();
    }
}

