/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatSetter;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;

public abstract class SAML2NameIdFormatCfgObjectBase
extends SAML2CfgObject
implements SAML2NameIdFormat,
SAML2NameIdFormatSetter {
    private static final String TOSTRING_PATTERN = "cfg path: {0}, is supported: {1}, UME attribute name: {2}, UME attribute namespace: {3}";
    protected static final String CFG_SUB_PATH_PROFILE_ATTRIBUTES = "profile_attributes";
    protected static final String CFG_SUB_PATH_AUTHORIZATION_ATTRIBUTES = "authz_attributes";
    protected static final String CFG_SUB_PATH_CONSTANT_ATTRIBUTES = "constant_attributes";
    protected static final String CFG_SUB_PATH_DEFAULT_ATTRIBUTES = "default_attributes";
    public static final String NAME_ID_FORMAT_RELATIVE_PATH = "name_id_formats";
    private static final String CFG_PROPERTY_SHEET = "cfg";
    private static final String KEY_IS_SUPPORTED = "supported";
    private static final String KEY_UME_ATTRIBUTE_NAME = "ume_attr_name";
    private static final String KEY_UME_ATTRIBUTE_NAMESPACE = "ume_attr_namespace";
    private static final byte STATE_READING = 2;
    private static final byte STATE_WRITING = 4;
    private static final byte STATE_WRITTEN = 8;
    private byte state;
    private CfgPropertySetter propertySetter;
    private boolean isSupported;
    private String umeAttributeName;
    private String umeAttributeNamespace;

    public SAML2NameIdFormatCfgObjectBase() {
        this.state = (byte)4;
    }

    public SAML2NameIdFormatCfgObjectBase(SAML2CfgObject parent, String subPath) {
        this(parent, subPath, false);
    }

    public SAML2NameIdFormatCfgObjectBase(SAML2CfgObject parent, String subPath, boolean isWtiteMode) {
        super(parent, String.valueOf(parent.getCfgPath()) + "/" + NAME_ID_FORMAT_RELATIVE_PATH + "/" + subPath, CFG_PROPERTY_SHEET, true);
        this.state = isWtiteMode ? (byte)4 : (byte)2;
    }

    protected String readProperty(String key) {
        return this.readProperty(key, null);
    }

    protected String readProperty(String key, String defaultValue) {
        return this.getPropertyValue(key, defaultValue).getValue();
    }

    protected String[] readArrayProperty(String key) {
        return this.getPropertyValue(key, null).getValues();
    }

    protected void setProperty(String key, String value) {
        this.propertySetter.setProperty(key, value);
    }

    protected void setProperty(String key, String[] values) {
        this.propertySetter.setProperty(key, values);
    }

    protected void setProperty(String key, Boolean value) {
        this.propertySetter.setProperty(key, value != null ? "" + value : null);
    }

    protected void setProperty(String key, boolean value) {
        this.propertySetter.setProperty(key, "" + value);
    }

    protected void setProperty(String key, int value) {
        this.propertySetter.setProperty(key, "" + value);
    }

    protected void readConfiguration(boolean isWriteMode) {
        this.isSupported = Boolean.parseBoolean(this.readProperty(KEY_IS_SUPPORTED, "false"));
        this.umeAttributeName = this.readProperty(KEY_UME_ATTRIBUTE_NAME);
        this.umeAttributeNamespace = this.readProperty(KEY_UME_ATTRIBUTE_NAMESPACE);
    }

    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    protected abstract void createAndWriteConfiguration(SAML2CfgObject var1) throws CfgStorageException;

    protected void createConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        if (this.state != 4) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        this.setCfgPath(String.valueOf(parent.getCfgPath()) + "/" + NAME_ID_FORMAT_RELATIVE_PATH + "/" + subPath);
        this.setCfgPropertySheet(CFG_PROPERTY_SHEET);
        this.propertySetter = this.getPropertySetter();
    }

    protected void writeConfiguration() throws CfgStorageException {
        if (this.state == 2) {
            throw new IllegalStateException("This anonymous sub configuration is intended only for reading");
        }
        if (this.state == 8) {
            throw new IllegalStateException("This anonymous sub configuration is already written");
        }
        this.setProperty(KEY_IS_SUPPORTED, this.isSupported);
        this.setProperty(KEY_UME_ATTRIBUTE_NAME, this.umeAttributeName);
        this.setProperty(KEY_UME_ATTRIBUTE_NAMESPACE, this.umeAttributeNamespace);
        super.write(this.propertySetter);
        this.state = (byte)8;
    }

    @Override
    public boolean isSupported() {
        return this.isSupported;
    }

    @Override
    public void setSupported(boolean isSupported) {
        this.isSupported = isSupported;
    }

    public String getUMEAttributeName() {
        return this.umeAttributeName;
    }

    public String getUMEAttributeNamespace() {
        return this.umeAttributeNamespace;
    }

    public void setUMEAttributeName(String name) {
        this.umeAttributeName = name;
    }

    public void setUMEAttributeNamespace(String namespace) {
        this.umeAttributeNamespace = namespace;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, super.toString(), this.isSupported, this.umeAttributeName, this.umeAttributeNamespace);
    }
}

