/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2AuthorizationAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2DefaultAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2AuthorizationAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2DefaultAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2AuthorizationAttributeTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2DefaultAttributeTrustedIdPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBase;
import com.sap.security.saml2.cfg.nameidformat.SAML2ProfileAttributeTrustedIdPImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.List;

public abstract class SAML2NameIdFormatCfgObjectBaseTrustedIdP
extends SAML2NameIdFormatCfgObjectBase {
    private List profileAttributes = new ArrayList();
    private List authorizationAttributes = new ArrayList();
    private List defaultAttributes = new ArrayList();
    private static final Location LOCATION = Location.getLocation(SAML2NameIdFormatCfgObjectBaseTrustedIdP.class);

    public SAML2NameIdFormatCfgObjectBaseTrustedIdP() {
    }

    public SAML2NameIdFormatCfgObjectBaseTrustedIdP(SAML2CfgObject parent, String subPath) {
        super(parent, subPath, false);
    }

    public SAML2NameIdFormatCfgObjectBaseTrustedIdP(SAML2CfgObject parent, String subPath, boolean isWtiteMode) {
        super(parent, subPath, isWtiteMode);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        int n;
        super.readConfiguration(isWriteMode);
        String[] profileAttributeSheets = null;
        try {
            profileAttributeSheets = this.getSubCfgPropertySheetNames("profile_attributes");
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load profile attributes for trusted IdP" + this.getNameIdFormat().getName(), (Throwable)e);
        }
        if (profileAttributeSheets != null) {
            String[] stringArray = profileAttributeSheets;
            n = profileAttributeSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String profileAttributeSheet = stringArray[n2];
                SAML2ProfileAttributeTrustedIdPImpl profileAttribute = new SAML2ProfileAttributeTrustedIdPImpl(this, "profile_attributes", profileAttributeSheet, isWriteMode);
                this.profileAttributes.add(profileAttribute);
                ++n2;
            }
        }
        String[] authzAttributeSubNodes = null;
        try {
            authzAttributeSubNodes = this.getSubCfgPaths("authz_attributes");
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load authorization attributes for trusted idp persistent nameId-format", (Throwable)e);
        }
        if (authzAttributeSubNodes != null) {
            String[] stringArray = authzAttributeSubNodes;
            int n3 = authzAttributeSubNodes.length;
            n = 0;
            while (n < n3) {
                String authzAttributeSubNode = stringArray[n];
                SAML2AuthorizationAttributeTrustedIdPImpl authzAttribute = new SAML2AuthorizationAttributeTrustedIdPImpl(authzAttributeSubNode, isWriteMode);
                this.authorizationAttributes.add(authzAttribute);
                ++n;
            }
        }
        String[] defaultAttributeSheets = null;
        try {
            defaultAttributeSheets = this.getSubCfgPropertySheetNames("default_attributes");
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load default attributes for trusted IdP" + this.getNameIdFormat().getName(), (Throwable)e);
        }
        if (defaultAttributeSheets != null) {
            String[] stringArray = defaultAttributeSheets;
            int n4 = defaultAttributeSheets.length;
            int n5 = 0;
            while (n5 < n4) {
                String defaultAttributeSheet = stringArray[n5];
                SAML2DefaultAttributeTrustedIdPImpl defaultAttribute = new SAML2DefaultAttributeTrustedIdPImpl(this, "default_attributes", defaultAttributeSheet, isWriteMode);
                this.defaultAttributes.add(defaultAttribute);
                ++n5;
            }
        }
    }

    @Override
    protected void writeConfiguration() throws CfgStorageException {
        SAML2AnonymousSubCfgObjectBase profileAttribute;
        super.writeConfiguration();
        this.deleteSubConfiguration("profile_attributes");
        if (this.profileAttributes != null) {
            for (Object obj : this.profileAttributes) {
                if (obj == null) continue;
                profileAttribute = (SAML2ProfileAttributeTrustedIdPImpl)obj;
                ((SAML2ProfileAttributeTrustedIdPImpl)profileAttribute).createAndWriteConfiguration(this, "profile_attributes");
            }
        }
        this.deleteSubConfiguration("authz_attributes");
        if (this.authorizationAttributes != null) {
            for (Object obj : this.authorizationAttributes) {
                if (obj == null) continue;
                profileAttribute = (SAML2AuthorizationAttributeTrustedIdPImpl)obj;
                ((SAML2AuthorizationAttributeTrustedIdPImpl)profileAttribute).createAndWriteConfiguration(this, "authz_attributes");
            }
        }
        this.deleteSubConfiguration("default_attributes");
        if (this.defaultAttributes != null) {
            for (Object obj : this.defaultAttributes) {
                if (obj == null) continue;
                SAML2DefaultAttributeTrustedIdPImpl defaultAttribute = (SAML2DefaultAttributeTrustedIdPImpl)obj;
                defaultAttribute.createAndWriteConfiguration(this, "default_attributes");
            }
        }
    }

    public List<SAML2ProfileAttributeTrustedIdP> getProfileAttributes() {
        return this.profileAttributes;
    }

    public List<SAML2AuthorizationAttributeTrustedIdP> getAuthorizationAttributes() {
        return this.authorizationAttributes;
    }

    public void setProfileAttributes(List<SAML2ProfileAttributeTrustedIdPSetter> profileAttributes) {
        this.profileAttributes = profileAttributes;
    }

    public void setAuthorizationAttributes(List<SAML2AuthorizationAttributeTrustedIdPSetter> authzAttributes) {
        this.authorizationAttributes = authzAttributes;
    }

    public void setDefaultAttributes(List<SAML2DefaultAttributeTrustedIdPSetter> defaultAttributes) {
        this.defaultAttributes = defaultAttributes;
    }

    public List<SAML2DefaultAttributeTrustedIdP> getDefaultAttributes() {
        return this.defaultAttributes;
    }
}

