/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2AuthorizationAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ConstantAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2AuthorizationAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ConstantAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2AuthorizationAttributeTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2ConstantAttributeTrustedSPImpl;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBase;
import com.sap.security.saml2.cfg.nameidformat.SAML2ProfileAttributeTrustedSPImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class SAML2NameIdFormatCfgObjectBaseTrustedSP
extends SAML2NameIdFormatCfgObjectBase {
    private static final String TOSTRING_PATTERN = "{0}\n  Profile attributes: {1}\n  Authorization attributes: {2}\n  Constant attributes: {3}";
    private List profileAttributes = new ArrayList();
    private List authorizationAttributes = new ArrayList();
    private List constantAttributes = new ArrayList();
    private static final Location LOCATION = Location.getLocation(SAML2NameIdFormatCfgObjectBaseTrustedSP.class);

    public SAML2NameIdFormatCfgObjectBaseTrustedSP() {
    }

    public SAML2NameIdFormatCfgObjectBaseTrustedSP(SAML2CfgObject parent, String subPath) {
        super(parent, subPath, false);
    }

    public SAML2NameIdFormatCfgObjectBaseTrustedSP(SAML2CfgObject parent, String subPath, boolean isWtiteMode) {
        super(parent, subPath, isWtiteMode);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        int n;
        super.readConfiguration(isWriteMode);
        String[] profileAttributeSheets = null;
        try {
            profileAttributeSheets = this.getSubCfgPropertySheetNames("profile_attributes");
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load profile attributes for trusted SP" + this.getNameIdFormat().getName(), (Throwable)e);
        }
        if (profileAttributeSheets != null) {
            String[] stringArray = profileAttributeSheets;
            n = profileAttributeSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String profileAttributeSheet = stringArray[n2];
                SAML2ProfileAttributeTrustedSPImpl profileAttribute = new SAML2ProfileAttributeTrustedSPImpl(this, "profile_attributes", profileAttributeSheet, isWriteMode);
                this.profileAttributes.add(profileAttribute);
                ++n2;
            }
        }
        String[] authzAttributeSheets = null;
        try {
            authzAttributeSheets = this.getSubCfgPropertySheetNames("authz_attributes");
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load authorization attributes for trusted SP persistent nameId-format", (Throwable)e);
        }
        if (authzAttributeSheets != null) {
            String[] stringArray = authzAttributeSheets;
            int n3 = authzAttributeSheets.length;
            n = 0;
            while (n < n3) {
                String authzAttributeSheet = stringArray[n];
                SAML2AuthorizationAttributeTrustedSPImpl authzAttribute = new SAML2AuthorizationAttributeTrustedSPImpl(this, "authz_attributes", authzAttributeSheet, isWriteMode);
                this.authorizationAttributes.add(authzAttribute);
                ++n;
            }
        }
        String[] constantAttributeSheets = null;
        try {
            constantAttributeSheets = this.getSubCfgPropertySheetNames("constant_attributes");
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load constant attributes for trusted SP" + this.getNameIdFormat().getName(), (Throwable)e);
        }
        if (constantAttributeSheets != null) {
            String[] stringArray = constantAttributeSheets;
            int n4 = constantAttributeSheets.length;
            int n5 = 0;
            while (n5 < n4) {
                String constantAttributeSheet = stringArray[n5];
                SAML2ConstantAttributeTrustedSPImpl constantAttribute = new SAML2ConstantAttributeTrustedSPImpl(this, "constant_attributes", constantAttributeSheet, isWriteMode);
                this.constantAttributes.add(constantAttribute);
                ++n5;
            }
        }
    }

    @Override
    protected void writeConfiguration() throws CfgStorageException {
        SAML2AnonymousSubCfgObjectBase profileAttribute;
        super.writeConfiguration();
        this.deleteSubConfiguration("profile_attributes");
        if (this.profileAttributes != null) {
            for (Object obj : this.profileAttributes) {
                if (obj == null) continue;
                profileAttribute = (SAML2ProfileAttributeTrustedSPImpl)obj;
                ((SAML2ProfileAttributeTrustedSPImpl)profileAttribute).createAndWriteConfiguration(this, "profile_attributes");
            }
        }
        this.deleteSubConfiguration("authz_attributes");
        if (this.authorizationAttributes != null) {
            for (Object obj : this.authorizationAttributes) {
                if (obj == null) continue;
                profileAttribute = (SAML2AuthorizationAttributeTrustedSPImpl)obj;
                ((SAML2AuthorizationAttributeTrustedSPImpl)profileAttribute).createAndWriteConfiguration(this, "authz_attributes");
            }
        }
        this.deleteSubConfiguration("constant_attributes");
        if (this.constantAttributes != null) {
            for (Object obj : this.constantAttributes) {
                if (obj == null) continue;
                SAML2ConstantAttributeTrustedSPImpl constantAttribute = (SAML2ConstantAttributeTrustedSPImpl)obj;
                constantAttribute.createAndWriteConfiguration(this, "constant_attributes");
            }
        }
    }

    public List<SAML2ProfileAttributeTrustedSP> getProfileAttributes() {
        return this.profileAttributes;
    }

    public List<SAML2AuthorizationAttributeTrustedSP> getAuthorizationAttributes() {
        return this.authorizationAttributes;
    }

    public void setProfileAttributes(List<SAML2ProfileAttributeTrustedSPSetter> profileAttributes) {
        this.profileAttributes = profileAttributes;
    }

    public void setAuthorizationAttributes(List<SAML2AuthorizationAttributeTrustedSPSetter> authzAttributes) {
        this.authorizationAttributes = authzAttributes;
    }

    public List<SAML2ConstantAttributeTrustedSP> getConstantAttributes() {
        return this.constantAttributes;
    }

    public void setConstantAttributes(List<SAML2ConstantAttributeTrustedSPSetter> constantAttributes) {
        this.constantAttributes = constantAttributes;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, super.toString(), this.getProfileAttributes(), this.getAuthorizationAttributes(), this.getConstantAttributes());
    }
}

