/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatEmailOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatEmailTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatEmailTrustedSPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedSP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class SAML2NameIdFormatEmailTrustedSPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedSP
implements SAML2NameIdFormatEmailTrustedSP,
SAML2NameIdFormatEmailTrustedSPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, accept all domains: {1}, accepted domains: {2}, {3}";
    private static final String CFG_SUB_PATH = "email";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ARE_ALL_DOMAINS_ACCEPTED = "are_all_domains_accepted";
    private static final String KEY_ACCEPTED_DOMAINS = "accepted_domains";
    private NameIdFormatEmailOption type = NameIdFormatEmailOption.USER_ATTRIBUTE;
    private boolean acceptAllDomains = true;
    private Set<String> acceptedDomains;

    public SAML2NameIdFormatEmailTrustedSPImpl() {
    }

    public SAML2NameIdFormatEmailTrustedSPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        this.setProperty(KEY_ARE_ALL_DOMAINS_ACCEPTED, this.acceptAllDomains);
        if (this.acceptedDomains != null && this.acceptedDomains.size() > 0) {
            String[] acceptedDomainsArray = this.acceptedDomains.toArray(new String[this.acceptedDomains.size()]);
            this.setProperty(KEY_ACCEPTED_DOMAINS, acceptedDomainsArray);
        } else {
            this.setProperty(KEY_ACCEPTED_DOMAINS, (String[])null);
        }
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatEmailOption.valueOf(typeName);
        }
        this.acceptAllDomains = Boolean.parseBoolean(this.readProperty(KEY_ARE_ALL_DOMAINS_ACCEPTED, "true"));
        String[] acceptedDomainsArray = this.readArrayProperty(KEY_ACCEPTED_DOMAINS);
        this.acceptedDomains = CfgUtils.convertToTreeSet(acceptedDomainsArray);
    }

    @Override
    public NameIdFormatEmailOption getType() {
        return this.type;
    }

    @Override
    public void setType(NameIdFormatEmailOption type) {
        this.type = type;
    }

    @Override
    public String getUMEAttributeName() {
        String dbAttributeName = super.getUMEAttributeName();
        if (dbAttributeName == null || dbAttributeName.length() < 1) {
            return CFG_SUB_PATH;
        }
        return dbAttributeName;
    }

    @Override
    public String getUMEAttributeNamespace() {
        String dbAttributeNamespace = super.getUMEAttributeNamespace();
        if (dbAttributeNamespace == null || dbAttributeNamespace.length() < 1) {
            return "com.sap.security.core.usermanagement";
        }
        return dbAttributeNamespace;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.E_MAIL;
    }

    @Override
    public boolean areAllDomainsAccepted() {
        return this.acceptAllDomains;
    }

    @Override
    public void setAllDomainsAccepted(Boolean acceptAllDomains) {
        this.acceptAllDomains = acceptAllDomains;
    }

    @Override
    public Set<String> getAcceptedDomains() {
        if (this.acceptedDomains == null) {
            this.acceptedDomains = new TreeSet<String>();
        }
        return Collections.unmodifiableSet(this.acceptedDomains);
    }

    @Override
    public void setAcceptedDomains(Set<String> acceptedDomains) {
        this.acceptedDomains = acceptedDomains;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, this.acceptAllDomains, this.acceptedDomains, super.toString()});
    }
}

