/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatKerberosTrustedIdPOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatKerberosTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatKerberosTrustedIdPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedIdP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class SAML2NameIdFormatKerberosTrustedIdPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedIdP
implements SAML2NameIdFormatKerberosTrustedIdP,
SAML2NameIdFormatKerberosTrustedIdPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, {1}, accept all realms: {2}, accepted realms: {3}";
    public static final String CFG_SUB_PATH = "kerberos";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ARE_ALL_REALMS_ACCEPTED = "are_all_realms_accepted";
    private static final String KEY_ACCEPTED_REALMS = "accepted_realms";
    private NameIdFormatKerberosTrustedIdPOption type = NameIdFormatKerberosTrustedIdPOption.ADS_DATA_SOURCE;
    private boolean acceptAllRealms = true;
    private Set<String> acceptedRealms;

    public SAML2NameIdFormatKerberosTrustedIdPImpl() {
    }

    public SAML2NameIdFormatKerberosTrustedIdPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatKerberosTrustedIdPOption.valueOf(typeName);
        }
        this.acceptAllRealms = Boolean.parseBoolean(this.readProperty(KEY_ARE_ALL_REALMS_ACCEPTED, "true"));
        String[] acceptedRealmsArray = this.readArrayProperty(KEY_ACCEPTED_REALMS);
        this.acceptedRealms = CfgUtils.convertToTreeSet(acceptedRealmsArray);
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        this.setProperty(KEY_ARE_ALL_REALMS_ACCEPTED, this.acceptAllRealms);
        if (this.acceptedRealms != null && this.acceptedRealms.size() > 0) {
            String[] acceptedRealmsArray = this.acceptedRealms.toArray(new String[this.acceptedRealms.size()]);
            this.setProperty(KEY_ACCEPTED_REALMS, acceptedRealmsArray);
        } else {
            this.setProperty(KEY_ACCEPTED_REALMS, (String[])null);
        }
        super.writeConfiguration();
    }

    @Override
    public NameIdFormatKerberosTrustedIdPOption getType() {
        return this.type;
    }

    @Override
    public void setType(NameIdFormatKerberosTrustedIdPOption type) {
        this.type = type;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.KERBEROS;
    }

    @Override
    public boolean areAllRealmsAccepted() {
        return this.acceptAllRealms;
    }

    @Override
    public void setAllRealmsAccepted(Boolean acceptAllRealms) {
        this.acceptAllRealms = acceptAllRealms;
    }

    @Override
    public Set<String> getAcceptedRealms() {
        if (this.acceptedRealms == null) {
            this.acceptedRealms = new TreeSet<String>();
        }
        return Collections.unmodifiableSet(this.acceptedRealms);
    }

    @Override
    public void setAcceptedRealms(Set<String> acceptedRealms) {
        this.acceptedRealms = acceptedRealms;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, super.toString(), this.acceptAllRealms, this.acceptedRealms});
    }
}

