/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatPersistentTrustedIdPOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.enums.SPProvidedIDTrustedIdPOption;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2TemplateUser;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2TemplateUserSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedIdP;
import com.sap.security.saml2.cfg.nameidformat.SAML2TemplateUserImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SAML2NameIdFormatPersistentTrustedIdPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedIdP
implements SAML2NameIdFormatPersistentTrustedIdP,
SAML2NameIdFormatPersistentTrustedIdPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, {1}, allow create: {2}, data source: {3}, default groups: {4}, default roles: {5}, update user attributes at login: {6}, automatic account creation: {7}, interactive account linking: {8}, lock updated users: {9}, SPProvidedID source: {10}, SPProvidedID UME attribute name: {11}, SPProvidedID UME attribute namespace: {12}\n  Profile attributes: {13}\n  Default User attributes: {14}\n  Authorization attributes: {15}\n  Default template user: {16}\n  Template users: {17}";
    private static final Location LOCATION = Location.getLocation(SAML2NameIdFormatPersistentTrustedIdPImpl.class);
    public static final String CFG_SUB_PATH = "persistent";
    private static final String CFG_SUB_PATH_TEMPLATE_USERS = "template_users";
    private static final String KEY_TYPE = "type";
    private static final String KEY_IS_ALLOW_CREATE = "allow_create";
    private static final String KEY_DATA_SOURCE_ID = "data_source_id";
    private static final String KEY_DEFAULT_GROUPS = "default_groups";
    private static final String KEY_DEFAULT_ROLES = "default_roles";
    private static final String KEY_IS_TO_UPDATE_USER_ATTRIBUTES_AT_LOGIN = "update_user_attrs_at_login";
    private static final String KEY_IS_AUTOMATIC_ACCOUNT_CREATION = "automatic_account_creation";
    private static final String KEY_IS_INTERACTIVE_ACCOUNT_LINKING = "interactive_account_linking";
    private static final String KEY_IS_TO_LOCK_UPDATED_USERS = "lock_updated_users";
    private static final String KEY_DEFAULT_TEMPLATE_USER = "default_template_user";
    private static final String KEY_SP_PROVIDED_ID_SOURCE = "sp_provided_id_source";
    private static final String KEY_SP_PROVIDED_ID_UME_ATTR_NAME = "sp_provided_id_ume_attr_name";
    private static final String KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE = "sp_provided_id_ume_attr_namespace";
    private NameIdFormatPersistentTrustedIdPOption type;
    private boolean allowCreate;
    private String dataSourceId;
    private List<String> defaultGroups = new ArrayList<String>();
    private List<String> defaultRoles = new ArrayList<String>();
    private boolean updateUserAttributes;
    private Boolean automaticAccountCreation;
    private Boolean interactiveAccountLinking;
    private boolean lockUpdatedUsers;
    private String defaultTemplateUser;
    private List templateUsers = new ArrayList();
    private SPProvidedIDTrustedIdPOption spProvidedIdSource;
    private String spProvidedIdUMEAttributeName;
    private String spProvidedIdUMEAttributeNamespace;

    public SAML2NameIdFormatPersistentTrustedIdPImpl() {
    }

    public SAML2NameIdFormatPersistentTrustedIdPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    public SAML2NameIdFormatPersistentTrustedIdPImpl(SAML2CfgObject parent, boolean isWriteMode) {
        super(parent, CFG_SUB_PATH, isWriteMode);
        this.readConfiguration(isWriteMode);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2NameIdFormatPersistentTrustedIdPImpl, isWriteMode = " + isWriteMode);
        }
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        String[] dbDefaultRoles;
        String[] dbDefaultGroups;
        super.readConfiguration(isWriteMode);
        String typeName = this.readProperty(KEY_TYPE);
        this.type = typeName != null && typeName.length() > 0 ? NameIdFormatPersistentTrustedIdPOption.valueOf(typeName) : NameIdFormatPersistentTrustedIdPOption.INTERACTIVE_ACCOUNT_LINKING;
        this.allowCreate = Boolean.parseBoolean(this.readProperty(KEY_IS_ALLOW_CREATE, "false"));
        this.updateUserAttributes = Boolean.parseBoolean(this.readProperty(KEY_IS_TO_UPDATE_USER_ATTRIBUTES_AT_LOGIN, "false"));
        String aacPropery = this.readProperty(KEY_IS_AUTOMATIC_ACCOUNT_CREATION);
        this.automaticAccountCreation = aacPropery != null ? Boolean.valueOf(Boolean.parseBoolean(aacPropery)) : Boolean.valueOf(this.type == NameIdFormatPersistentTrustedIdPOption.AUTHOMATIC_ACCOUNT_CREATION);
        String ialPropery = this.readProperty(KEY_IS_INTERACTIVE_ACCOUNT_LINKING);
        this.interactiveAccountLinking = ialPropery != null ? Boolean.valueOf(Boolean.parseBoolean(ialPropery)) : Boolean.valueOf(this.type == NameIdFormatPersistentTrustedIdPOption.INTERACTIVE_ACCOUNT_LINKING);
        this.dataSourceId = this.readProperty(KEY_DATA_SOURCE_ID);
        this.lockUpdatedUsers = Boolean.parseBoolean(this.readProperty(KEY_IS_TO_LOCK_UPDATED_USERS));
        String spProvidedIdSourceName = this.readProperty(KEY_SP_PROVIDED_ID_SOURCE);
        if (!CfgUtils.isEmpty(spProvidedIdSourceName)) {
            this.spProvidedIdSource = SPProvidedIDTrustedIdPOption.valueOf(spProvidedIdSourceName);
        }
        this.spProvidedIdUMEAttributeName = this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAME);
        this.spProvidedIdUMEAttributeNamespace = this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE);
        this.defaultTemplateUser = this.readProperty(KEY_DEFAULT_TEMPLATE_USER);
        String[] templateUserSheets = null;
        try {
            templateUserSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_TEMPLATE_USERS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load template users for user mappings in trusted IdP persistent nameId-format", (Throwable)e);
        }
        if (templateUserSheets != null) {
            String[] stringArray = templateUserSheets;
            int n = templateUserSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String templateUserSheet = stringArray[n2];
                SAML2TemplateUserImpl templateUser = new SAML2TemplateUserImpl(this, CFG_SUB_PATH_TEMPLATE_USERS, templateUserSheet, isWriteMode);
                this.templateUsers.add(templateUser);
                ++n2;
            }
        }
        if ((dbDefaultGroups = this.readArrayProperty(KEY_DEFAULT_GROUPS)) != null && dbDefaultGroups.length > 0) {
            this.defaultGroups = Arrays.asList(dbDefaultGroups);
        }
        if ((dbDefaultRoles = this.readArrayProperty(KEY_DEFAULT_ROLES)) != null && dbDefaultRoles.length > 0) {
            this.defaultRoles = Arrays.asList(dbDefaultRoles);
        }
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        } else {
            this.setProperty(KEY_TYPE, (String)null);
        }
        this.setProperty(KEY_IS_ALLOW_CREATE, this.allowCreate);
        this.setProperty(KEY_IS_TO_UPDATE_USER_ATTRIBUTES_AT_LOGIN, this.updateUserAttributes);
        this.setProperty(KEY_IS_AUTOMATIC_ACCOUNT_CREATION, this.automaticAccountCreation);
        this.setProperty(KEY_IS_INTERACTIVE_ACCOUNT_LINKING, this.interactiveAccountLinking);
        this.setProperty(KEY_DATA_SOURCE_ID, this.dataSourceId);
        this.setProperty(KEY_IS_TO_LOCK_UPDATED_USERS, this.lockUpdatedUsers);
        this.setProperty(KEY_SP_PROVIDED_ID_SOURCE, this.spProvidedIdSource != null ? this.spProvidedIdSource.name() : null);
        this.setProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAME, this.spProvidedIdUMEAttributeName);
        this.setProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE, this.spProvidedIdUMEAttributeNamespace);
        this.setProperty(KEY_DEFAULT_TEMPLATE_USER, this.defaultTemplateUser);
        this.deleteSubConfiguration(CFG_SUB_PATH_TEMPLATE_USERS);
        if (this.templateUsers != null) {
            for (Object obj : this.templateUsers) {
                if (obj == null) continue;
                SAML2TemplateUserImpl templateUser = (SAML2TemplateUserImpl)obj;
                templateUser.createAndWriteConfiguration(this, CFG_SUB_PATH_TEMPLATE_USERS);
            }
        }
        String[] dbDefaultGroups = null;
        if (this.defaultGroups != null) {
            dbDefaultGroups = this.defaultGroups.toArray(new String[this.defaultGroups.size()]);
        }
        this.setProperty(KEY_DEFAULT_GROUPS, dbDefaultGroups);
        String[] dbDefaultRoles = null;
        if (this.defaultRoles != null) {
            dbDefaultRoles = this.defaultRoles.toArray(new String[this.defaultRoles.size()]);
        }
        this.setProperty(KEY_DEFAULT_ROLES, dbDefaultRoles);
        super.writeConfiguration();
    }

    @Override
    public SPProvidedIDTrustedIdPOption getSPProvidedIdSource() {
        return this.spProvidedIdSource;
    }

    @Override
    public String getSPProvidedIdUMEAttributeName() {
        return this.spProvidedIdUMEAttributeName;
    }

    @Override
    public String getSPProvidedIdUMEAttributeNamespace() {
        return this.spProvidedIdUMEAttributeNamespace;
    }

    @Override
    public void setSPProvidedIdSource(SPProvidedIDTrustedIdPOption source) {
        this.spProvidedIdSource = source;
    }

    @Override
    public void setSPProvidedIdUMEAttributeName(String umeName) {
        this.spProvidedIdUMEAttributeName = umeName;
    }

    @Override
    public void setSPProvidedIdUMEAttributeNamespace(String umeNamespace) {
        this.spProvidedIdUMEAttributeNamespace = umeNamespace;
    }

    @Override
    public boolean isToLockUpdatedUsers() {
        return this.lockUpdatedUsers;
    }

    @Override
    public void setLockUpdatedUsers(boolean isToLock) {
        this.lockUpdatedUsers = isToLock;
    }

    @Override
    public NameIdFormatPersistentTrustedIdPOption getType() {
        return this.type;
    }

    @Override
    public String getDefaultTemplateUser() {
        return this.defaultTemplateUser;
    }

    @Override
    public List<SAML2TemplateUser> getTemplateUsers() {
        return this.templateUsers;
    }

    @Override
    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    @Override
    public boolean isToUpdateUserAttributesAtLogin() {
        return this.updateUserAttributes;
    }

    @Override
    public boolean isAutomaticAccountCreation() {
        return this.automaticAccountCreation;
    }

    @Override
    public boolean isInteractiveAccountLinking() {
        return this.interactiveAccountLinking;
    }

    @Override
    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    @Override
    public void setType(NameIdFormatPersistentTrustedIdPOption type) {
        this.type = type;
    }

    @Override
    public void setUpdateUserAttributesAtLogin(boolean isToUpdate) {
        this.updateUserAttributes = isToUpdate;
    }

    @Override
    public void setAutomaticAccountCreation(boolean isToCreate) {
        this.automaticAccountCreation = isToCreate;
    }

    @Override
    public void setInteractiveAccountLinking(boolean isToLink) {
        this.interactiveAccountLinking = isToLink;
    }

    @Override
    public String getDataSourceIdForAutomaticUserCreation() {
        return this.dataSourceId;
    }

    @Override
    public void setDataSourceIdForAutomaticUserCreation(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    @Override
    public List<String> getDefaultGroupsForAutomaticUserCreation() {
        return this.defaultGroups;
    }

    @Override
    public List<String> getDefaultRolesForAutomaticUserCreation() {
        return this.defaultRoles;
    }

    @Override
    public void setDefaultGroupsForAutomaticUserCreation(List<String> groups) {
        this.defaultGroups = groups;
    }

    @Override
    public void setDefaultRolesForAutomaticUserCreation(List<String> roles) {
        this.defaultRoles = roles;
    }

    @Override
    public void setDefaultTemplateUser(String user) {
        this.defaultTemplateUser = user;
    }

    @Override
    public void setTemplateUsers(List<SAML2TemplateUserSetter> templateUsers) {
        this.templateUsers = templateUsers;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.PERSISTENT;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, super.toString(), this.allowCreate, this.dataSourceId, this.defaultGroups, this.defaultRoles, this.updateUserAttributes, this.automaticAccountCreation, this.interactiveAccountLinking, this.lockUpdatedUsers, this.spProvidedIdSource, this.spProvidedIdUMEAttributeName, this.spProvidedIdUMEAttributeNamespace, this.getProfileAttributes(), this.getDefaultAttributes(), this.getAuthorizationAttributes(), this.defaultTemplateUser, this.templateUsers});
    }
}

