/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatPersistentTrustedSPOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatPersistentTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatPersistentTrustedSPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedSP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2NameIdFormatPersistentTrustedSPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedSP
implements SAML2NameIdFormatPersistentTrustedSP,
SAML2NameIdFormatPersistentTrustedSPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, SPProvidedID UME attribute name: {1}, SPProvidedID UME attribute namespace: {2}, {3}";
    private static final Location LOCATION = Location.getLocation(SAML2NameIdFormatPersistentTrustedSPImpl.class);
    private static final String CFG_SUB_PATH = "persistent";
    private static final String KEY_TYPE = "type";
    private static final String KEY_SP_PROVIDED_ID_UME_ATTR_NAME = "sp_provided_id_ume_attr_name";
    private static final String KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE = "sp_provided_id_ume_attr_namespace";
    private NameIdFormatPersistentTrustedSPOption type = NameIdFormatPersistentTrustedSPOption.USER_ATTRIBUTE;
    private String spProvidedIdUMEAttributeName;
    private String spProvidedIdUMEAttributeNamespace;

    public SAML2NameIdFormatPersistentTrustedSPImpl() {
    }

    public SAML2NameIdFormatPersistentTrustedSPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    public SAML2NameIdFormatPersistentTrustedSPImpl(SAML2CfgObject parent, boolean isWriteMode) {
        super(parent, CFG_SUB_PATH, isWriteMode);
        this.readConfiguration(isWriteMode);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2NameIdFormatPersistentTrustedSPImpl, isWriteMode = " + isWriteMode);
        }
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        super.readConfiguration(isWriteMode);
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatPersistentTrustedSPOption.valueOf(typeName);
        }
        this.spProvidedIdUMEAttributeName = this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAME);
        this.spProvidedIdUMEAttributeNamespace = this.readProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE);
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        this.setProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAME, this.spProvidedIdUMEAttributeName);
        this.setProperty(KEY_SP_PROVIDED_ID_UME_ATTR_NAMESPACE, this.spProvidedIdUMEAttributeNamespace);
        super.writeConfiguration();
    }

    @Override
    public NameIdFormatPersistentTrustedSPOption getType() {
        return this.type;
    }

    @Override
    public String getSPProvidedIdUMEAttributeName() {
        return this.spProvidedIdUMEAttributeName;
    }

    @Override
    public String getSPProvidedIdUMEAttributeNamespace() {
        return this.spProvidedIdUMEAttributeNamespace;
    }

    @Override
    public void setSPProvidedIdUMEAttributeName(String umeName) {
        this.spProvidedIdUMEAttributeName = umeName;
    }

    @Override
    public void setSPProvidedIdUMEAttributeNamespace(String umeNamespace) {
        this.spProvidedIdUMEAttributeNamespace = umeNamespace;
    }

    @Override
    public void setType(NameIdFormatPersistentTrustedSPOption type) {
        this.type = type;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.PERSISTENT;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, this.spProvidedIdUMEAttributeName, this.spProvidedIdUMEAttributeNamespace, super.toString()});
    }
}

