/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatTransientTrustedIdPOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatTransientTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2TemplateUser;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatTransientTrustedIdPSetter;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2TemplateUserSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedIdP;
import com.sap.security.saml2.cfg.nameidformat.SAML2TemplateUserImpl;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SAML2NameIdFormatTransientTrustedIdPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedIdP
implements SAML2NameIdFormatTransientTrustedIdP,
SAML2NameIdFormatTransientTrustedIdPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, {1}, default groups: {2}, default roles: {3}\n  Profile attributes: {4}\n  Default User attributes: {5}\n  Authorization attributes: {6}\n  Default template user: {7}\n  Template users: {8}";
    private static final Location LOCATION = Location.getLocation(SAML2NameIdFormatTransientTrustedIdPImpl.class);
    public static final String CFG_SUB_PATH = "transient";
    private static final String CFG_SUB_PATH_TEMPLATE_USERS = "template_users";
    private static final String KEY_TYPE = "type";
    private static final String KEY_DEFAULT_GROUPS = "default_groups";
    private static final String KEY_DEFAULT_ROLES = "default_roles";
    private static final String KEY_DEFAULT_TEMPLATE_USER = "default_template_user";
    private NameIdFormatTransientTrustedIdPOption type = NameIdFormatTransientTrustedIdPOption.GENERATED;
    private String defaultTemplateUser;
    private List templateUsers = new ArrayList();
    private List<String> defaultGroups = new ArrayList<String>();
    private List<String> defaultRoles = new ArrayList<String>();

    public SAML2NameIdFormatTransientTrustedIdPImpl() {
    }

    public SAML2NameIdFormatTransientTrustedIdPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    public SAML2NameIdFormatTransientTrustedIdPImpl(SAML2CfgObject parent, boolean isWriteMode) {
        super(parent, CFG_SUB_PATH, isWriteMode);
        this.readConfiguration(isWriteMode);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("SAML2NameIdFormatTransientTrustedIdPImpl, isWriteMode = " + isWriteMode);
        }
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        String[] dbDefaultRoles;
        String[] dbDefaultGroups;
        super.readConfiguration(isWriteMode);
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatTransientTrustedIdPOption.valueOf(typeName);
        }
        this.defaultTemplateUser = this.readProperty(KEY_DEFAULT_TEMPLATE_USER);
        String[] templateUserSheets = null;
        try {
            templateUserSheets = this.getSubCfgPropertySheetNames(CFG_SUB_PATH_TEMPLATE_USERS);
        }
        catch (CfgStorageException e) {
            LOCATION.traceThrowableT(500, "Could not load template users for user mappings in trusted IdP transient nameId-format", (Throwable)e);
        }
        if (templateUserSheets != null) {
            String[] stringArray = templateUserSheets;
            int n = templateUserSheets.length;
            int n2 = 0;
            while (n2 < n) {
                String templateUserSheet = stringArray[n2];
                SAML2TemplateUserImpl templateUser = new SAML2TemplateUserImpl(this, CFG_SUB_PATH_TEMPLATE_USERS, templateUserSheet, isWriteMode);
                this.templateUsers.add(templateUser);
                ++n2;
            }
        }
        if ((dbDefaultGroups = this.readArrayProperty(KEY_DEFAULT_GROUPS)) != null && dbDefaultGroups.length > 0) {
            this.defaultGroups = Arrays.asList(dbDefaultGroups);
        }
        if ((dbDefaultRoles = this.readArrayProperty(KEY_DEFAULT_ROLES)) != null && dbDefaultRoles.length > 0) {
            this.defaultRoles = Arrays.asList(dbDefaultRoles);
        }
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        this.setProperty(KEY_DEFAULT_TEMPLATE_USER, this.defaultTemplateUser);
        this.deleteSubConfiguration(CFG_SUB_PATH_TEMPLATE_USERS);
        if (this.templateUsers != null) {
            for (Object obj : this.templateUsers) {
                if (obj == null) continue;
                SAML2TemplateUserImpl templateUser = (SAML2TemplateUserImpl)obj;
                templateUser.createAndWriteConfiguration(this, CFG_SUB_PATH_TEMPLATE_USERS);
            }
        }
        String[] dbDefaultGroups = null;
        if (this.defaultGroups != null) {
            dbDefaultGroups = this.defaultGroups.toArray(new String[this.defaultGroups.size()]);
        }
        this.setProperty(KEY_DEFAULT_GROUPS, dbDefaultGroups);
        String[] dbDefaultRoles = null;
        if (this.defaultRoles != null) {
            dbDefaultRoles = this.defaultRoles.toArray(new String[this.defaultRoles.size()]);
        }
        this.setProperty(KEY_DEFAULT_ROLES, dbDefaultRoles);
        super.writeConfiguration();
    }

    @Override
    public String getDefaultTemplateUser() {
        return this.defaultTemplateUser;
    }

    @Override
    public List<SAML2TemplateUser> getTemplateUsers() {
        return this.templateUsers;
    }

    @Override
    public NameIdFormatTransientTrustedIdPOption getType() {
        return this.type;
    }

    @Override
    public void setType(NameIdFormatTransientTrustedIdPOption type) {
        this.type = type;
    }

    @Override
    public List<String> getDefaultGroupsForVirtualUserCreation() {
        return this.defaultGroups;
    }

    @Override
    public List<String> getDefaultRolesForVirtualUserCreation() {
        return this.defaultRoles;
    }

    @Override
    public void setDefaultGroupsForVirtualUserCreation(List<String> groups) {
        this.defaultGroups = groups;
    }

    @Override
    public void setDefaultRolesForVirtualUserCreation(List<String> roles) {
        this.defaultRoles = roles;
    }

    @Override
    public void setDefaultTemplateUser(String user) {
        this.defaultTemplateUser = user;
    }

    @Override
    public void setTemplateUsers(List<SAML2TemplateUserSetter> templateUsers) {
        this.templateUsers = templateUsers;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.TRANSIENT;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, super.toString(), this.defaultGroups, this.defaultRoles, this.getProfileAttributes(), this.getDefaultAttributes(), this.getAuthorizationAttributes(), this.defaultTemplateUser, this.templateUsers});
    }
}

