/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatUnspecifiedOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatUnspecified;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatUnspecifiedSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBase;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;

public class SAML2NameIdFormatUnspecifiedImpl
extends SAML2NameIdFormatCfgObjectBase
implements SAML2NameIdFormatUnspecified,
SAML2NameIdFormatUnspecifiedSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, allow create: {1}, {2}";
    private static final String CFG_SUB_PATH = "unspecified";
    private static final String KEY_TYPE = "type";
    private static final String KEY_IS_ALLOW_CREATE = "allow_create";
    private NameIdFormatUnspecifiedOption type = NameIdFormatUnspecifiedOption.LOGON_ID;
    private Boolean allowCreate;

    public SAML2NameIdFormatUnspecifiedImpl() {
    }

    public SAML2NameIdFormatUnspecifiedImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatUnspecifiedOption.valueOf(typeName);
        }
        this.allowCreate = Boolean.parseBoolean(this.readProperty(KEY_IS_ALLOW_CREATE));
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        this.setProperty(KEY_IS_ALLOW_CREATE, this.allowCreate);
        super.writeConfiguration();
    }

    @Override
    public NameIdFormatUnspecifiedOption getType() {
        return this.type;
    }

    @Override
    public boolean isAllowCreate() {
        if (this.allowCreate == null) {
            return false;
        }
        return this.allowCreate;
    }

    @Override
    public void setAllowCreate(Boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    @Override
    public void setType(NameIdFormatUnspecifiedOption type) {
        this.type = type;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.UNSPECIFIED;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, this.allowCreate, super.toString()});
    }
}

