/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatWindowsOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatWindows;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatWindowsSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBase;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class SAML2NameIdFormatWindowsImpl
extends SAML2NameIdFormatCfgObjectBase
implements SAML2NameIdFormatWindows,
SAML2NameIdFormatWindowsSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, {1}, accept all domains: {2}, accepted domains: {3}";
    private static final String CFG_SUB_PATH = "windows";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ARE_ALL_DOMAINS_ACCEPTED = "are_all_domains_accepted";
    private static final String KEY_ACCEPTED_DOMAINS = "accepted_domains";
    private NameIdFormatWindowsOption type = NameIdFormatWindowsOption.ADS_DATA_SOURCE;
    private boolean acceptAllDomains = true;
    private Set<String> acceptedDomains;

    public SAML2NameIdFormatWindowsImpl() {
    }

    public SAML2NameIdFormatWindowsImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatWindowsOption.valueOf(typeName);
        }
        this.acceptAllDomains = Boolean.parseBoolean(this.readProperty(KEY_ARE_ALL_DOMAINS_ACCEPTED, "true"));
        String[] acceptedDomainsArray = this.readArrayProperty(KEY_ACCEPTED_DOMAINS);
        this.acceptedDomains = CfgUtils.convertToTreeSet(acceptedDomainsArray);
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        this.setProperty(KEY_ARE_ALL_DOMAINS_ACCEPTED, this.acceptAllDomains);
        if (this.acceptedDomains != null && this.acceptedDomains.size() > 0) {
            String[] acceptedDomainsArray = this.acceptedDomains.toArray(new String[this.acceptedDomains.size()]);
            this.setProperty(KEY_ACCEPTED_DOMAINS, acceptedDomainsArray);
        } else {
            this.setProperty(KEY_ACCEPTED_DOMAINS, (String[])null);
        }
        super.writeConfiguration();
    }

    @Override
    public NameIdFormatWindowsOption getType() {
        return this.type;
    }

    @Override
    public void setType(NameIdFormatWindowsOption type) {
        this.type = type;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.WINDOWS_DOMAIN_QUALIFIED_NAME;
    }

    @Override
    public boolean areAllDomainsAccepted() {
        return this.acceptAllDomains;
    }

    @Override
    public void setAllDomainsAccepted(Boolean acceptAllDomains) {
        this.acceptAllDomains = acceptAllDomains;
    }

    @Override
    public Set<String> getAcceptedDomains() {
        if (this.acceptedDomains == null) {
            this.acceptedDomains = new TreeSet<String>();
        }
        return Collections.unmodifiableSet(this.acceptedDomains);
    }

    @Override
    public void setAcceptedDomains(Set<String> acceptedDomains) {
        this.acceptedDomains = acceptedDomains;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, super.toString(), this.acceptAllDomains, this.acceptedDomains});
    }
}

