/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatX509TrustedIdPOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatX509TrustedIdPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedIdP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;

public class SAML2NameIdFormatX509TrustedIdPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedIdP
implements SAML2NameIdFormatX509TrustedIdP,
SAML2NameIdFormatX509TrustedIdPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, {1}";
    public static final String CFG_SUB_PATH = "x509";
    private static final String KEY_TYPE = "type";
    private NameIdFormatX509TrustedIdPOption type = NameIdFormatX509TrustedIdPOption.USER_ATTRIBUTE;

    public SAML2NameIdFormatX509TrustedIdPImpl() {
    }

    public SAML2NameIdFormatX509TrustedIdPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatX509TrustedIdPOption.valueOf(typeName);
        }
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        super.writeConfiguration();
    }

    @Override
    public NameIdFormatX509TrustedIdPOption getType() {
        return this.type;
    }

    @Override
    public void setType(NameIdFormatX509TrustedIdPOption type) {
        this.type = type;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.X509_SUBJECT_NAME;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, super.toString()});
    }
}

