/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.enums.NameIdFormatX509TrustedSPOption;
import com.sap.security.saml2.cfg.enums.SAML2NameIdFormat;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2NameIdFormatX509TrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2NameIdFormatX509TrustedSPSetter;
import com.sap.security.saml2.cfg.nameidformat.SAML2NameIdFormatCfgObjectBaseTrustedSP;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;

public class SAML2NameIdFormatX509TrustedSPImpl
extends SAML2NameIdFormatCfgObjectBaseTrustedSP
implements SAML2NameIdFormatX509TrustedSP,
SAML2NameIdFormatX509TrustedSPSetter {
    private static final String TOSTRING_PATTERN = "type: {0}, {1}";
    private static final String CFG_SUB_PATH = "x509";
    private static final String KEY_TYPE = "type";
    private NameIdFormatX509TrustedSPOption type = NameIdFormatX509TrustedSPOption.JAAS_SUBJECT;

    public SAML2NameIdFormatX509TrustedSPImpl() {
    }

    public SAML2NameIdFormatX509TrustedSPImpl(SAML2CfgObject parent) {
        super(parent, CFG_SUB_PATH);
        this.readConfiguration();
    }

    @Override
    protected void readConfiguration() {
        super.readConfiguration();
        String typeName = this.readProperty(KEY_TYPE);
        if (typeName != null && typeName.length() > 0) {
            this.type = NameIdFormatX509TrustedSPOption.valueOf(typeName);
        }
    }

    @Override
    public void createAndWriteConfiguration(SAML2CfgObject parent) throws CfgStorageException {
        super.createConfiguration(parent, CFG_SUB_PATH);
        if (this.type != null) {
            this.setProperty(KEY_TYPE, this.type.name());
        }
        super.writeConfiguration();
    }

    @Override
    public NameIdFormatX509TrustedSPOption getType() {
        return this.type;
    }

    @Override
    public void setType(NameIdFormatX509TrustedSPOption type) {
        this.type = type;
    }

    @Override
    public SAML2NameIdFormat getNameIdFormat() {
        return SAML2NameIdFormat.X509_SUBJECT_NAME;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, new Object[]{this.type, super.toString()});
    }
}

