/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2TrustedIdPImpl;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedIdP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedIdPSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2ProfileAttributeTrustedIdPImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2ProfileAttributeTrustedIdP,
SAML2ProfileAttributeTrustedIdPSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2ProfileAttributeTrustedIdPImpl.class);
    private static final String TOSTRING_PATTERN = "SAML2 attribute name: {0}, is mandatory: {1}, UME attribute alias: {2}, UME attribute name: {3}, UME attribute namespace: {4} cfg path: {5}";
    private static final String KEY_SAML2_ATTRIBUTE_NAME = "saml2_attr_name";
    private static final String KEY_IS_MANDATORY = "mandatory";
    private static final String KEY_UME_ATTRIBUTE_NAME = "ume_attr_name";
    private static final String KEY_UME_ATTRIBUTE_NAMESPACE = "ume_attr_namespace";
    private static final String KEY_UME_ATTRIBUTE_ALIAS = "ume_attr_alias";
    private String saml2AttrName;
    private boolean mandatory;
    private String umeAttrName;
    private String umeAttrNamespace;
    private String umeAttrAlias;

    public SAML2ProfileAttributeTrustedIdPImpl() {
    }

    public SAML2ProfileAttributeTrustedIdPImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        this(parent, subPath, propertySheet, false);
    }

    public SAML2ProfileAttributeTrustedIdPImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_SAML2_ATTRIBUTE_NAME, this.saml2AttrName);
        this.setProperty(KEY_IS_MANDATORY, this.mandatory);
        this.setProperty(KEY_UME_ATTRIBUTE_ALIAS, this.umeAttrAlias);
        this.setProperty(KEY_UME_ATTRIBUTE_NAME, this.umeAttrName);
        this.setProperty(KEY_UME_ATTRIBUTE_NAMESPACE, this.umeAttrNamespace);
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        SAML2CfgObject trustedIdPCfgObject;
        SAML2CfgObject identityFederationCfgObject;
        this.saml2AttrName = this.readProperty(KEY_SAML2_ATTRIBUTE_NAME);
        this.mandatory = Boolean.parseBoolean(this.readProperty(KEY_IS_MANDATORY, "false"));
        this.umeAttrName = this.readProperty(KEY_UME_ATTRIBUTE_NAME);
        this.umeAttrNamespace = this.readProperty(KEY_UME_ATTRIBUTE_NAMESPACE);
        this.umeAttrAlias = this.readProperty(KEY_UME_ATTRIBUTE_ALIAS);
        if (this.umeAttrAlias == null && this.umeAttrName != null && (identityFederationCfgObject = this.getParentCfgObject()) != null && (trustedIdPCfgObject = identityFederationCfgObject.getParentCfgObject()) != null) {
            SAML2CfgUMEAttribute umeAttribute = ((SAML2TrustedIdPImpl)trustedIdPCfgObject).getUMEAttribute(this.umeAttrName, this.umeAttrNamespace);
            if (umeAttribute != null) {
                this.umeAttrAlias = umeAttribute.getAlias();
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("The configured UME attribute with name: {0} and namespace: {1}, cannot be found in the UME attributes defined in the local provider configuration", new Object[]{this.umeAttrName, this.umeAttrNamespace});
            }
        }
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public String getSAML2AttributeName() {
        return this.saml2AttrName;
    }

    @Override
    public String getUMEAttributeAlias() {
        return this.umeAttrAlias;
    }

    @Override
    public String getUMEAttributeName() {
        return this.umeAttrName;
    }

    @Override
    public String getUMEAttributeNamespace() {
        return this.umeAttrNamespace;
    }

    @Override
    public void setMandatory(boolean isMandatory) {
        this.mandatory = isMandatory;
    }

    @Override
    public void setSAML2AttributeName(String name) {
        this.saml2AttrName = name;
    }

    @Override
    public void setUMEAttributeAlias(String alias) {
        this.umeAttrAlias = alias;
    }

    @Override
    public void setUMEAttributeName(String name) {
        this.umeAttrName = name;
    }

    @Override
    public void setUMEAttributeNamespace(String namespace) {
        this.umeAttrNamespace = namespace;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.saml2AttrName, this.mandatory, this.umeAttrAlias, this.umeAttrName, this.umeAttrNamespace, super.toString());
    }
}

