/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.SAML2TrustedSPImpl;
import com.sap.security.saml2.cfg.enums.SAML2AttributeFormat;
import com.sap.security.saml2.cfg.interfaces.read.SAML2CfgUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2ProfileAttributeTrustedSP;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2ProfileAttributeTrustedSPSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.util.CfgUtils;
import com.sap.tc.logging.Location;
import java.text.MessageFormat;

public class SAML2ProfileAttributeTrustedSPImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2ProfileAttributeTrustedSP,
SAML2ProfileAttributeTrustedSPSetter {
    private static final long serialVersionUID = 1L;
    private static final Location LOCATION = Location.getLocation(SAML2ProfileAttributeTrustedSPImpl.class);
    private static final String TOSTRING_PATTERN = "SAML2 attribute name: {0}, SAML2 attribute format: {1}, UME attribute alias: {2}, UME attribute name: {3}, UME attribute namespace: {4}, cfg path: {5}";
    private static final String KEY_SAML2_ATTRIBUTE_NAME = "saml2_attr_name";
    private static final String KEY_SAML2_ATTRIBUTE_FORMAT = "saml2_attr_format";
    private static final String KEY_UME_ATTRIBUTE_NAME = "ume_attr_name";
    private static final String KEY_UME_ATTRIBUTE_NAMESPACE = "ume_attr_namespace";
    private static final String KEY_UME_ATTRIBUTE_ALIAS = "ume_attr_alias";
    private String saml2AttrName;
    private SAML2AttributeFormat saml2AttrFormat;
    private String umeAttrName;
    private String umeAttrNamespace;
    private String umeAttrAlias;

    public SAML2ProfileAttributeTrustedSPImpl() {
    }

    public SAML2ProfileAttributeTrustedSPImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        super(parent, subPath, propertySheet);
    }

    public SAML2ProfileAttributeTrustedSPImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_SAML2_ATTRIBUTE_NAME, this.saml2AttrName);
        this.setProperty(KEY_SAML2_ATTRIBUTE_FORMAT, this.saml2AttrFormat != null ? this.saml2AttrFormat.getName() : null);
        this.setProperty(KEY_UME_ATTRIBUTE_ALIAS, this.umeAttrAlias);
        this.setProperty(KEY_UME_ATTRIBUTE_NAME, this.umeAttrName);
        this.setProperty(KEY_UME_ATTRIBUTE_NAMESPACE, this.umeAttrNamespace);
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        SAML2CfgObject trustedSPCfgObject;
        SAML2CfgObject identityFederationCfgObject;
        this.saml2AttrName = this.readProperty(KEY_SAML2_ATTRIBUTE_NAME);
        String dbSAML2AttributeFormat = this.readProperty(KEY_SAML2_ATTRIBUTE_FORMAT);
        if (!CfgUtils.isEmpty(dbSAML2AttributeFormat)) {
            this.saml2AttrFormat = SAML2AttributeFormat.getAttributeFormat(dbSAML2AttributeFormat);
        }
        this.umeAttrName = this.readProperty(KEY_UME_ATTRIBUTE_NAME);
        this.umeAttrNamespace = this.readProperty(KEY_UME_ATTRIBUTE_NAMESPACE);
        this.umeAttrAlias = this.readProperty(KEY_UME_ATTRIBUTE_ALIAS);
        if (this.umeAttrAlias == null && this.umeAttrName != null && (identityFederationCfgObject = this.getParentCfgObject()) != null && (trustedSPCfgObject = identityFederationCfgObject.getParentCfgObject()) != null) {
            SAML2CfgUMEAttribute umeAttribute = ((SAML2TrustedSPImpl)trustedSPCfgObject).getUMEAttribute(this.umeAttrName, this.umeAttrNamespace);
            if (umeAttribute != null) {
                this.umeAttrAlias = umeAttribute.getAlias();
            } else if (LOCATION.beWarning()) {
                LOCATION.warningT("The configured UME attribute with name: {0} and namespace: {1}, cannot be found in the UME attributes defined in the local provider configuration", new Object[]{this.umeAttrName, this.umeAttrNamespace});
            }
        }
    }

    @Override
    public String getSAML2AttributeName() {
        return this.saml2AttrName;
    }

    @Override
    public SAML2AttributeFormat getSAML2AttributeFormat() {
        return this.saml2AttrFormat;
    }

    @Override
    public String getUMEAttributeAlias() {
        return this.umeAttrAlias;
    }

    @Override
    public String getUMEAttributeName() {
        return this.umeAttrName;
    }

    @Override
    public String getUMEAttributeNamespace() {
        return this.umeAttrNamespace;
    }

    @Override
    public void setSAML2AttributeName(String name) {
        this.saml2AttrName = name;
    }

    @Override
    public void setSAML2AttributeFormat(SAML2AttributeFormat format) {
        this.saml2AttrFormat = format;
    }

    @Override
    public void setUMEAttributeAlias(String alias) {
        this.umeAttrAlias = alias;
    }

    @Override
    public void setUMEAttributeName(String name) {
        this.umeAttrName = name;
    }

    @Override
    public void setUMEAttributeNamespace(String namespace) {
        this.umeAttrNamespace = namespace;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.saml2AttrName, this.saml2AttrFormat, this.umeAttrAlias, this.umeAttrName, this.umeAttrNamespace, super.toString());
    }
}

