/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2RuleEntry;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2RuleEntrySetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SAML2RuleEntryImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2RuleEntry,
SAML2RuleEntrySetter {
    private static final String TOSTRING_PATTERN = "attribute name: {0}, values: {1}, cfg path: {2}";
    private static final String KEY_ATTR_NAME = "attr_name";
    private static final String KEY_ATTR_VALUES = "attr_values";
    private String attrName;
    private List<String> attrValues;

    public SAML2RuleEntryImpl() {
    }

    public SAML2RuleEntryImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        this(parent, subPath, propertySheet, false);
    }

    public SAML2RuleEntryImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        this.createConfiguration(parent, subPath);
        this.setProperty(KEY_ATTR_NAME, this.attrName);
        if (this.attrValues != null && this.attrValues.size() > 0) {
            this.setProperty(KEY_ATTR_VALUES, this.attrValues.toArray(new String[this.attrValues.size()]));
        }
        this.writeConfiguration();
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        this.attrName = this.readProperty(KEY_ATTR_NAME);
        String[] dbAttrValues = this.readArrayProperty(KEY_ATTR_VALUES);
        if (dbAttrValues != null && dbAttrValues.length > 0) {
            this.attrValues = Arrays.asList(dbAttrValues);
        }
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    public String getAttributeName() {
        return this.attrName;
    }

    @Override
    public List<String> getAttributeValues() {
        if (this.attrValues == null) {
            this.attrValues = new ArrayList<String>(0);
        }
        return Collections.unmodifiableList(this.attrValues);
    }

    @Override
    public void setAttributeName(String name) {
        this.attrName = name;
    }

    @Override
    public void setAttributeValues(List<String> values) {
        this.attrValues = values;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.attrName, this.attrValues, super.toString());
    }
}

