/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.nameidformat;

import com.sap.security.saml2.cfg.SAML2AnonymousSubCfgObjectBase;
import com.sap.security.saml2.cfg.SAML2CfgObject;
import com.sap.security.saml2.cfg.interfaces.read.nameidformat.SAML2TemplateUser;
import com.sap.security.saml2.cfg.interfaces.write.nameidformat.SAML2TemplateUserSetter;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class SAML2TemplateUserImpl
extends SAML2AnonymousSubCfgObjectBase
implements SAML2TemplateUser,
SAML2TemplateUserSetter {
    private static final String TOSTRING_PATTERN = "Template user id: {0}, groups: {1}, roles: {2}, cfg path: {3}";
    private static final String KEY_USER_ID = "user_id";
    private static final String KEY_GROUPS = "groups";
    private static final String KEY_ROLES = "roles";
    private String userId;
    private Set<String> groups;
    private Set<String> roles;

    public SAML2TemplateUserImpl() {
    }

    public SAML2TemplateUserImpl(SAML2CfgObject parent, String subPath, String propertySheet) {
        this(parent, subPath, propertySheet, false);
    }

    public SAML2TemplateUserImpl(SAML2CfgObject parent, String subPath, String propertySheet, boolean isWriteMode) {
        super(parent, subPath, propertySheet, isWriteMode);
    }

    @Override
    protected void createAndWriteConfiguration(SAML2CfgObject parent, String subPath) throws CfgStorageException {
        super.createConfiguration(parent, subPath);
        this.setProperty(KEY_USER_ID, this.userId);
        if (this.groups != null && !this.groups.isEmpty()) {
            this.setProperty(KEY_GROUPS, this.groups.toArray(new String[this.groups.size()]));
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            this.setProperty(KEY_ROLES, this.roles.toArray(new String[this.roles.size()]));
        }
        super.writeConfiguration();
    }

    @Override
    protected void readConfiguration() {
        this.readConfiguration(false);
    }

    @Override
    protected void readConfiguration(boolean isWriteMode) {
        String[] dbRoles;
        this.userId = this.readProperty(KEY_USER_ID);
        String[] dbGroups = this.readArrayProperty(KEY_GROUPS);
        if (dbGroups != null) {
            this.groups = new TreeSet<String>();
            this.groups.addAll(Arrays.asList(dbGroups));
        }
        if ((dbRoles = this.readArrayProperty(KEY_ROLES)) != null) {
            this.roles = new TreeSet<String>();
            this.roles.addAll(Arrays.asList(dbRoles));
        }
    }

    @Override
    public Set<String> getGroupRuleEntries() {
        if (this.groups == null) {
            this.groups = new TreeSet<String>();
        }
        return Collections.unmodifiableSet(this.groups);
    }

    @Override
    public Set<String> getRoleRuleEntries() {
        if (this.roles == null) {
            this.roles = new TreeSet<String>();
        }
        return Collections.unmodifiableSet(this.roles);
    }

    @Override
    public String getUser() {
        return this.userId;
    }

    @Override
    public void setGroupRuleEntries(Set<String> groups) {
        this.groups = groups;
    }

    @Override
    public void setRoleRuleEntries(Set<String> roles) {
        this.roles = roles;
    }

    @Override
    public void setUser(String userId) {
        this.userId = userId;
    }

    @Override
    public String toString() {
        return MessageFormat.format(TOSTRING_PATTERN, this.userId, this.groups, this.roles, super.toString());
    }
}

