/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.storage;

import com.sap.security.saml2.cfg.interfaces.services.CfgStorage;
import com.sap.security.saml2.cfg.storage.CfgProperty;
import com.sap.security.saml2.cfg.storage.CfgPropertySetter;
import com.sap.security.saml2.cfg.storage.CfgPropertyValue;
import com.sap.security.saml2.cfg.storage.CfgStorageException;
import com.sap.security.saml2.cfg.storage.StorageChangedListener;
import com.sap.security.saml2.cfg.util.SAML2CfgServicesManager;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class CfgObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String cfg_path;
    private String cfgPropertySheet;
    private String propertySheetComments = "";
    private boolean isComplex = false;
    private boolean stdHash = false;
    private transient CfgStorage cfgStorage = null;

    protected CfgObject(CfgStorage cfgAdapter) {
        this.stdHash = true;
        this.setCfgPath("");
        this.cfgPropertySheet = "";
        this.cfgStorage = cfgAdapter;
    }

    protected CfgObject(CfgStorage cfgAdapter, String cfgPath, String propertySheet, boolean isComplexCfg) {
        this.stdHash = false;
        this.setCfgPath(cfgPath);
        this.isComplex = isComplexCfg;
        this.cfgPropertySheet = propertySheet;
        this.cfgStorage = cfgAdapter;
    }

    public String getCfgPath() {
        return this.cfg_path;
    }

    public boolean isComplexCfg() {
        return this.isComplex;
    }

    public String getCfgPropertySheet() {
        return this.cfgPropertySheet;
    }

    protected void setCfgPath(String path) {
        this.cfg_path = path;
    }

    protected void setCfgPropertySheet(String name) {
        this.cfgPropertySheet = name;
    }

    protected String getPropertySheetComments() {
        return this.propertySheetComments;
    }

    protected void setPropertySheetComments(String propertySheetComments) {
        this.propertySheetComments = propertySheetComments;
    }

    public final CfgPropertyValue getPropertyValue(String propertyName, String defaultValue) {
        return this.getPropertyValue(this.getProperty(propertyName), defaultValue);
    }

    public final CfgPropertyValue getPropertyValue(CfgProperty property, String defaultValue) {
        return this.cfgStorage.getPropertyValue(property, defaultValue);
    }

    public final CfgProperty getProperty(String name) {
        return new CfgProperty(name, this);
    }

    public CfgPropertySetter getPropertySetter() {
        return new CfgPropertySetter(this);
    }

    public void write(CfgPropertySetter setterCfg) throws CfgStorageException {
        this.cfgStorage.write(setterCfg);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CfgObject) {
            CfgObject cfg = (CfgObject)obj;
            return cfg.getFullName().equals(this.getFullName());
        }
        return false;
    }

    private String getFullName() {
        String sheet;
        String path = this.getCfgPath();
        if (path == null || path.trim().length() == 0) {
            path = "";
        }
        if ((sheet = this.getCfgPropertySheet()) == null || sheet.trim().length() == 0) {
            sheet = "";
        }
        return String.valueOf(path) + "/" + sheet;
    }

    public int hashCode() {
        if (this.stdHash) {
            return super.hashCode();
        }
        return this.getFullName().hashCode();
    }

    public String[] getSubCfgPaths() throws CfgStorageException {
        return this.cfgStorage.getSubCfgNames(this.getCfgPath());
    }

    public String[] getSubCfgPaths(String sub_path) throws CfgStorageException {
        if (sub_path == null) {
            return this.getSubCfgPaths();
        }
        String path = this.getCfgPath() != null && this.getCfgPath().length() > 0 ? String.valueOf(this.getCfgPath()) + "/" + sub_path : sub_path;
        return this.cfgStorage.getSubCfgNames(path);
    }

    protected void deleteCfgObject(CfgObject obj) throws CfgStorageException {
        this.cfgStorage.deleteCfgObject(obj);
    }

    protected void deleteSubConfiguration(String relativeSubConfigurationPath) throws CfgStorageException {
        CfgObject cfgObject = new CfgObject(this.cfgStorage, String.valueOf(this.getCfgPath()) + "/" + relativeSubConfigurationPath, null, true){};
        this.deleteCfgObject(cfgObject);
    }

    protected void createAndSetAnonymousPropertySheet() throws CfgStorageException {
        this.createAndSetAnonymousPropertySheet(null);
    }

    protected void createAndSetAnonymousPropertySheet(String prefix) throws CfgStorageException {
        String newPropertySheetName = this.cfgStorage.createAnonymousPropertySheet(this.getCfgPath(), prefix);
        this.setCfgPropertySheet(newPropertySheetName);
    }

    protected void createAndSetAnonymousSubCfg() throws CfgStorageException {
        this.createAndSetAnonimousSubCfg(null);
    }

    protected void createAndSetAnonimousSubCfg(String prefix) throws CfgStorageException {
        String newCfgPath = this.cfgStorage.createAnonymousSubCfg(this.getCfgPath(), prefix);
        this.setCfgPath(newCfgPath);
    }

    protected String[] getCfgPropertySheetNames(String prefix) throws CfgStorageException {
        return this.cfgStorage.getCfgPropertySheetNames(this.getCfgPath(), prefix);
    }

    protected String[] getSubCfgPropertySheetNames(String relativeSubConfigurationPath) throws CfgStorageException {
        return this.getSubCfgPropertySheetNames(relativeSubConfigurationPath, null);
    }

    protected String[] getSubCfgPropertySheetNames(String relativeSubConfigurationPath, String prefix) throws CfgStorageException {
        return this.cfgStorage.getCfgPropertySheetNames(String.valueOf(this.getCfgPath()) + "/" + relativeSubConfigurationPath, prefix);
    }

    protected void registerAsStorageListener(StorageChangedListener listener) throws CfgStorageException {
        this.cfgStorage.registerStorageChangedListener(listener, this.getCfgPath());
    }

    protected void registerAsStorageListenerForSubPath(StorageChangedListener listener, String subpath) throws CfgStorageException {
        if (subpath == null || subpath.length() < 1) {
            this.registerAsStorageListener(listener);
        } else {
            String path = subpath;
            if (this.getCfgPath() != null && this.getCfgPath().length() > 0) {
                path = String.valueOf(this.getCfgPath()) + "/" + subpath;
            }
            this.cfgStorage.registerStorageChangedListener(listener, path);
        }
    }

    protected void unregisterAsStorageListener(StorageChangedListener listener) throws CfgStorageException {
        this.cfgStorage.unregisterStorageChangedListener(listener, this.getCfgPath());
    }

    protected void unregisterAsStorageListener(StorageChangedListener listener, String subpath) throws CfgStorageException {
        if (subpath == null || subpath.length() < 1) {
            this.cfgStorage.unregisterStorageChangedListener(listener, this.getCfgPath());
        } else {
            String path = subpath;
            if (this.getCfgPath() != null && this.getCfgPath().length() > 0) {
                path = String.valueOf(this.getCfgPath()) + "/" + subpath;
            }
            this.cfgStorage.unregisterStorageChangedListener(listener, path);
        }
    }

    protected void unregisterAllConfigurationChangedListener() throws CfgStorageException {
        this.cfgStorage.unregisterAllConfigurationChangedListener();
    }

    protected void exportConfiguration(String destinationFilePath) throws CfgStorageException {
        this.cfgStorage.exportConfiguration(destinationFilePath);
    }

    protected void importConfiguration(String sourceFilePath) throws CfgStorageException {
        this.cfgStorage.importConfiguration(sourceFilePath);
    }

    public String[] getCfgPropertySheetKeys() {
        return this.cfgStorage.getPropertySheetKeys(this);
    }

    public String toString() {
        return this.getFullName();
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        try {
            this.cfgStorage = SAML2CfgServicesManager.getInstance().getCfgStorageInstance();
        }
        catch (SAML2ServiceInstantiationException sAML2ServiceInstantiationException) {}
    }
}

