/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.storage;

import com.sap.security.saml2.cfg.storage.CfgObject;
import java.io.Serializable;

public class CfgProperty
implements Serializable {
    private CfgObject cfgObject;
    private boolean isFileEntry = false;
    private String name = "";

    public CfgProperty(String name, CfgObject cfgObject) {
        this.name = name;
        this.cfgObject = cfgObject;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getCfgPath() {
        return this.cfgObject.getCfgPath();
    }

    public String getCfgPropertySheet() {
        return this.cfgObject.getCfgPropertySheet();
    }

    public boolean isFile() {
        return this.isFileEntry;
    }

    private String getFullName() {
        String cfgPropertySheet = this.getCfgPropertySheet();
        String prop_sheet = "/";
        if (cfgPropertySheet != null) {
            prop_sheet = String.valueOf(prop_sheet) + cfgPropertySheet + "/";
        }
        return String.valueOf(this.getCfgPath()) + prop_sheet + this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CfgProperty) {
            CfgProperty prop = (CfgProperty)obj;
            return this.getFullName().equalsIgnoreCase(prop.getFullName());
        }
        return false;
    }

    public int hashCode() {
        if (this.cfgObject != null) {
            String hash = String.valueOf(this.cfgObject.hashCode());
            return (String.valueOf(hash) + this.getName()).hashCode();
        }
        return this.getFullName().hashCode();
    }

    public String toString() {
        return this.getFullName();
    }
}

