/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.storage;

import com.sap.security.saml2.cfg.storage.CfgObject;
import com.sap.security.saml2.cfg.storage.CfgProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CfgPropertySetter
implements Serializable {
    private Map<CfgProperty, Object> cfgProperties;
    protected CfgObject cfgObject;

    CfgPropertySetter(CfgObject object) {
        this.cfgObject = object;
        this.cfgProperties = new HashMap<CfgProperty, Object>();
    }

    public void setProperty(String propName, String value) {
        CfgProperty property = new CfgProperty(propName, this.cfgObject);
        this.setProperty(property, value);
    }

    public void setProperty(String propName, String[] value) {
        CfgProperty property = new CfgProperty(propName, this.cfgObject);
        this.setProperty(property, value);
    }

    public void setProperty(CfgProperty property, String[] value) {
        this.cfgProperties.put(property, value);
    }

    public void setProperty(CfgProperty property, String value) {
        this.cfgProperties.put(property, value);
    }

    public void addAllProperties(Map<String, String> props) {
        Set<String> keys = props.keySet();
        for (String s : keys) {
            this.setProperty(s, props.get(s));
        }
    }

    public String getCfgPath() {
        return this.cfgObject.getCfgPath();
    }

    public String getCfgPropertySheetName() {
        return this.cfgObject.getCfgPropertySheet();
    }

    public String getCfgPropertySheetComments() {
        return this.cfgObject.getPropertySheetComments();
    }

    public void clear() {
        this.cfgProperties.clear();
    }

    public Map<CfgProperty, Object> getProperties() {
        return this.cfgProperties;
    }
}

