/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.storage;

import java.io.UnsupportedEncodingException;

public class CfgPropertyValue {
    public static final String VALUE_SEPARATOR = new String(new char[1]);
    private static final String VALUE_SEPARATOR_REGEX = new String(new char[1]);
    private static final String NEW_VALUE_SEPARATOR = "|#|";
    private static final String NEW_VALUE_SEPARATOR_REGEX = "\\|\\#\\|";
    String[] valueArr = null;

    public static CfgPropertyValue getInstance(Object obj) {
        if (obj == null) {
            return new CfgPropertyValue(null);
        }
        if (obj instanceof String[]) {
            return new CfgPropertyValue((String[])obj);
        }
        if (obj instanceof String) {
            return new CfgPropertyValue((String)obj);
        }
        if (obj instanceof byte[]) {
            return new CfgPropertyValue((byte[])obj);
        }
        throw new RuntimeException("Invalid value: [" + obj.getClass().getName() + ": " + obj + "]");
    }

    private CfgPropertyValue(byte[] value) {
        if (value != null) {
            try {
                this.valueArr = new String[]{new String(value, "UTF-8")};
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    private CfgPropertyValue(String value) {
        if (value != null) {
            this.valueArr = CfgPropertyValue.convert(value);
        }
    }

    private CfgPropertyValue(String[] values) {
        if (values != null) {
            int len = values.length;
            this.valueArr = new String[len];
            System.arraycopy(values, 0, this.valueArr, 0, len);
        }
    }

    public String getValue() {
        if (this.valueArr == null || this.valueArr.length == 0) {
            return null;
        }
        return this.valueArr[0];
    }

    public String[] getValues() {
        return this.valueArr;
    }

    public static String convert(String[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        StringBuilder temp = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String oneString = stringArray[n2];
            temp.append(oneString);
            temp.append(NEW_VALUE_SEPARATOR);
            ++n2;
        }
        return temp.toString();
    }

    public static String[] convert(String oneString) {
        if (oneString == null) {
            return null;
        }
        if (oneString.endsWith(VALUE_SEPARATOR)) {
            return oneString.split(VALUE_SEPARATOR_REGEX);
        }
        if (oneString.endsWith(NEW_VALUE_SEPARATOR)) {
            return oneString.split(NEW_VALUE_SEPARATOR_REGEX);
        }
        return new String[]{oneString};
    }

    public String toString() {
        return CfgPropertyValue.convert(this.getValues());
    }
}

