/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.storage;

import com.sap.security.saml2.cfg.storage.CfgProperty;
import com.sap.security.saml2.cfg.util.CfgUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CfgStorageUtils {
    private static final String CFG_PATH_SEPARATOR = "/";
    public static final Comparator<String> CFG_NAME_COMPARATOR = new CfgNameComparator();

    public static final int getCfgIndex(String cfgPath) {
        String normalPath = CfgStorageUtils.getCfgPathNormalized(cfgPath);
        int len = normalPath.length();
        StringBuilder sb = new StringBuilder(len);
        int i = len - 1;
        while (i >= 0) {
            char ch = normalPath.charAt(i);
            if (ch < '0' || ch > '9') break;
            sb.insert(0, ch);
            --i;
        }
        try {
            return Integer.parseInt(sb.toString());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static final String[] parseRelativePath(CfgProperty key) {
        String path = key.getCfgPath();
        return CfgStorageUtils.parseRelativePath(path);
    }

    public static final String[] parseRelativePath(String path) {
        if (CfgUtils.isEmpty(path)) {
            return new String[0];
        }
        return path.split(CFG_PATH_SEPARATOR);
    }

    public static String formNewAnonymousName(String prefix, List<String> existingNames) {
        ArrayList<Integer> sorted = new ArrayList<Integer>(existingNames.size());
        for (String name : existingNames) {
            int idx = CfgStorageUtils.getCfgIndex(name);
            if (idx <= -1) continue;
            sorted.add(idx);
        }
        Collections.sort(sorted);
        int i = 0;
        int size = sorted.size();
        while (i < size) {
            if (i != (Integer)sorted.get(i)) break;
            ++i;
        }
        String newAnonymousName = String.valueOf(i);
        if (!CfgUtils.isEmpty(prefix)) {
            newAnonymousName = String.valueOf(prefix) + newAnonymousName;
        }
        return newAnonymousName;
    }

    public static final byte[] readInputStream(InputStream file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bufferSize = 256;
        byte[] io_buffer = new byte[bufferSize];
        int readBytesCount = -1;
        while ((readBytesCount = file.read(io_buffer)) != -1) {
            out.write(io_buffer, 0, readBytesCount);
        }
        return out.toByteArray();
    }

    private static final String getCfgPathNormalized(String cfg_path) {
        if (cfg_path == null) {
            return null;
        }
        if ((cfg_path = cfg_path.trim().replace('\\', '/')).length() > 1 && cfg_path.endsWith(CFG_PATH_SEPARATOR)) {
            cfg_path = cfg_path.substring(0, cfg_path.length() - 2);
        }
        return cfg_path;
    }

    private static class CfgNameComparator
    implements Comparator<String> {
        private CfgNameComparator() {
        }

        @Override
        public int compare(String a, String b) {
            int aIndex = CfgStorageUtils.getCfgIndex(a);
            int bIndex = CfgStorageUtils.getCfgIndex(b);
            if (aIndex == -1 && bIndex == -1) {
                return a.compareTo(b);
            }
            if (aIndex == -1) {
                return 1;
            }
            if (bIndex == -1) {
                return -1;
            }
            return new Integer(aIndex).compareTo(bIndex);
        }
    }
}

