/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.util;

import com.sap.security.saml2.cfg.SAML2CfgSetterFactory;
import com.sap.security.saml2.cfg.enums.SAML2AuthenticationContext;
import com.sap.security.saml2.cfg.enums.SAML2Binding;
import com.sap.security.saml2.cfg.enums.SAML2PredefinedUMEAttribute;
import com.sap.security.saml2.cfg.interfaces.write.SAML2CfgAuthenticationContextSetter;
import com.sap.security.saml2.cfg.interfaces.write.SAML2CfgUMEAttributeSetter;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CfgUtils {
    private static final Location LOCATION = Location.getLocation(CfgUtils.class);

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static String[] serializeSAML2Bindings(Set<SAML2Binding> bindings) {
        if (bindings == null) {
            return null;
        }
        ArrayList<String> bindingNames = new ArrayList<String>(bindings.size());
        for (SAML2Binding binding : bindings) {
            if (binding == null) continue;
            String bindingName = binding.getName();
            bindingNames.add(bindingName);
        }
        String[] result = bindingNames.toArray(new String[bindingNames.size()]);
        return result;
    }

    public static Set<SAML2Binding> deserializeSAML2Bindings(String[] bindingNames) {
        HashSet<SAML2Binding> result = new HashSet<SAML2Binding>();
        if (bindingNames != null) {
            String[] stringArray = bindingNames;
            int n = bindingNames.length;
            int n2 = 0;
            while (n2 < n) {
                SAML2Binding binding;
                String bindingName = stringArray[n2];
                if (bindingName != null && (binding = SAML2Binding.getBinding(bindingName)) != null) {
                    result.add(binding);
                }
                ++n2;
            }
        }
        return result;
    }

    public static String[] serializeSAML2AuthnContexts(List<SAML2AuthenticationContext> authnContexts) {
        if (authnContexts == null) {
            return null;
        }
        ArrayList<String> authnContextNames = new ArrayList<String>(authnContexts.size());
        for (SAML2AuthenticationContext authnContext : authnContexts) {
            if (authnContext == null) continue;
            String authnContextName = authnContext.getName();
            authnContextNames.add(authnContextName);
        }
        String[] result = authnContextNames.toArray(new String[authnContextNames.size()]);
        return result;
    }

    public static List<SAML2AuthenticationContext> deserializeSAML2AuthnContexts(String[] authnContextNames) {
        ArrayList<SAML2AuthenticationContext> result = new ArrayList<SAML2AuthenticationContext>();
        if (authnContextNames != null) {
            String[] stringArray = authnContextNames;
            int n = authnContextNames.length;
            int n2 = 0;
            while (n2 < n) {
                String authnContextName = stringArray[n2];
                if (authnContextName != null) {
                    SAML2AuthenticationContext authnContext = SAML2AuthenticationContext.getAuthenticationContextByName(authnContextName);
                    if (authnContext != null) {
                        result.add(authnContext);
                    } else if (LOCATION.beDebug()) {
                        LOCATION.debugT("Unknown authn context: " + authnContext);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public static String extractRelativePathToFirstSubNode(String originalFullPath, String relativeRootPath) {
        int separatorIndex;
        int beginIndexOfSubNode;
        int index = originalFullPath.indexOf(relativeRootPath);
        String result = index != -1 ? ((beginIndexOfSubNode = index + relativeRootPath.length() + 1) < originalFullPath.length() ? ((separatorIndex = originalFullPath.indexOf("/", beginIndexOfSubNode)) == -1 ? originalFullPath.substring(index) : originalFullPath.substring(index, separatorIndex)) : relativeRootPath) : null;
        return result;
    }

    public static boolean isOneSubNode(String originalFullPath, String relativeRootPath) {
        int separatorIndex;
        int beginIndexOfSubNode;
        boolean result = false;
        int index = originalFullPath.indexOf(relativeRootPath);
        if (index != -1 && (beginIndexOfSubNode = index + relativeRootPath.length() + 1) < originalFullPath.length() && (separatorIndex = originalFullPath.indexOf("/", beginIndexOfSubNode)) == -1) {
            result = true;
        }
        return result;
    }

    public static Map<String, SAML2CfgAuthenticationContextSetter> obtainStandardSAML2AuthenticationContexts() {
        HashMap<String, SAML2CfgAuthenticationContextSetter> result = new HashMap<String, SAML2CfgAuthenticationContextSetter>();
        Set<SAML2AuthenticationContext> authnContexts = SAML2AuthenticationContext.getAllAuthenticationContexts();
        for (SAML2AuthenticationContext authnContext : authnContexts) {
            SAML2CfgAuthenticationContextSetter authnContextSetter = SAML2CfgSetterFactory.getInstance().createSAML2CfgAuthenticationContext();
            authnContextSetter.setName(authnContext.getName());
            authnContextSetter.setAlias(authnContext.getAlias());
            authnContextSetter.setHTTP(authnContext.isHTTP());
            authnContextSetter.setHTTPS(authnContext.isHTTPS());
            authnContextSetter.setInteractive(authnContext.isInteractive());
            result.put(authnContext.getName(), authnContextSetter);
        }
        return result;
    }

    public static Map<String, SAML2CfgUMEAttributeSetter> obtainPredefinedSAML2UMEAttributes() {
        HashMap<String, SAML2CfgUMEAttributeSetter> result = new HashMap<String, SAML2CfgUMEAttributeSetter>();
        Set<SAML2PredefinedUMEAttribute> umeAttributes = SAML2PredefinedUMEAttribute.getAll();
        for (SAML2PredefinedUMEAttribute umeAttribute : umeAttributes) {
            SAML2CfgUMEAttributeSetter umeAttributeSetter = SAML2CfgSetterFactory.getInstance().createSAML2CfgUMEAttribute();
            umeAttributeSetter.setAlias(umeAttribute.getAlias());
            umeAttributeSetter.setName(umeAttribute.getName());
            umeAttributeSetter.setNamespace(umeAttribute.getNamespace());
            result.put(umeAttribute.getAlias(), umeAttributeSetter);
        }
        return result;
    }

    public static TreeSet<String> convertToTreeSet(String[] values) {
        if (values == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            result.add(value);
            ++n2;
        }
        return result;
    }
}

