/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.util;

import com.sap.security.core.server.destinations.api.Destination;
import com.sap.security.core.server.destinations.api.DestinationException;
import com.sap.security.core.server.destinations.api.DestinationService;
import com.sap.security.core.server.destinations.api.DestinationServiceLocator;
import com.sap.security.core.server.destinations.api.HTTPDestination;
import com.sap.security.saml2.cfg.exceptions.SAML2ConfigurationException;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.List;

public class DestinationUtil {
    private static final String DESTINATION_TYPE_HTTP = "HTTP";
    private static final String PREFIX_FOR_NEW_DESTINATIONS = "saml2_";
    private static final Location LOCATION = Location.getLocation(DestinationUtil.class);

    public static HTTPDestination getDestination(String destinationName) throws DestinationException, RemoteException {
        DestinationService destinationService = DestinationServiceLocator.getInstance();
        HTTPDestination destination = (HTTPDestination)destinationService.getDestination(DESTINATION_TYPE_HTTP, destinationName);
        if (LOCATION.beDebug()) {
            if (destination != null) {
                LOCATION.debugT("Destination with name {0} found.", new Object[]{destinationName});
            } else {
                LOCATION.debugT("Destination with name {0} not found.", new Object[]{destinationName});
            }
        }
        return destination;
    }

    public static String getDestinationURL(String destinationName) throws DestinationException, RemoteException {
        HTTPDestination destination = DestinationUtil.getDestination(destinationName);
        if (destination != null) {
            return destination.getUrl();
        }
        return null;
    }

    public static String createDestination(String providerName, String suffix, String url) throws SAML2ConfigurationException {
        String destinationName = PREFIX_FOR_NEW_DESTINATIONS + providerName + "_" + suffix;
        try {
            DestinationService destinationService = DestinationServiceLocator.getInstance();
            HTTPDestination destination = (HTTPDestination)destinationService.createDestination(DESTINATION_TYPE_HTTP);
            destination.setUrl(url);
            String tempName = destinationName;
            int index = 1;
            while (destinationService.existsDestination(DESTINATION_TYPE_HTTP, tempName)) {
                tempName = String.valueOf(destinationName) + "_" + index;
                ++index;
            }
            destinationName = tempName;
            destination.setName(destinationName);
            destinationService.storeDestination(DESTINATION_TYPE_HTTP, (Destination)destination);
            if (LOCATION.beDebug()) {
                LOCATION.debugT("Created destination with name: {0} and location url: {1}", new Object[]{destinationName, url});
            }
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(500, "Could not create destination with name: {0} and location: {1}", new Object[]{destinationName, url}, (Throwable)e);
            throw new SAML2ConfigurationException("Could not create destination with name: " + destinationName + " and location: " + url, e);
        }
        return destinationName;
    }

    public static HTTPDestination createDestination(String destinationName, String url) throws DestinationException, RemoteException {
        DestinationService destinationService = DestinationServiceLocator.getInstance();
        HTTPDestination destination = (HTTPDestination)destinationService.createDestination(DESTINATION_TYPE_HTTP);
        destination.setUrl(url);
        destination.setName(destinationName);
        destinationService.storeDestination(DESTINATION_TYPE_HTTP, (Destination)destination);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Created destination " + destinationName + ":" + url);
        }
        return (HTTPDestination)destinationService.getDestination(DESTINATION_TYPE_HTTP, destinationName);
    }

    public static void updateDestination(String destinationName, String url) throws DestinationException, RemoteException {
        DestinationService destinationService = DestinationServiceLocator.getInstance();
        HTTPDestination destination = (HTTPDestination)destinationService.getDestination(DESTINATION_TYPE_HTTP, destinationName);
        destination.setUrl(url);
        destination.setName(destinationName);
        destinationService.updateDestination(DESTINATION_TYPE_HTTP, (Destination)destination);
        if (LOCATION.beDebug()) {
            LOCATION.debugT("Updated destination " + destinationName + ":" + url);
        }
    }

    public static void deleteDestination(String name) throws DestinationException, RemoteException {
        DestinationServiceLocator.getInstance().removeDestination(DESTINATION_TYPE_HTTP, name);
    }

    public static boolean existDestination(String destinationName) {
        try {
            return DestinationServiceLocator.getInstance().existsDestination(DESTINATION_TYPE_HTTP, destinationName);
        }
        catch (DestinationException e) {
            LOCATION.traceThrowableT(100, "Exception checking if destination exists", (Throwable)e);
            return false;
        }
    }

    public static void updateDestination(HTTPDestination destination) throws DestinationException, RemoteException {
        DestinationServiceLocator.getInstance().updateDestination(DESTINATION_TYPE_HTTP, (Destination)destination);
    }

    public static List<String> getDestinationNames() throws DestinationException, RemoteException {
        List list = DestinationServiceLocator.getInstance().getDestinationNames(DESTINATION_TYPE_HTTP);
        return list;
    }
}

