/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.saml2.cfg.util;

import com.sap.security.saml2.cfg.interfaces.services.HTTPDestinationService;
import com.sap.security.saml2.cfg.interfaces.services.SAML2CfgKeystoreService;
import com.sap.security.saml2.cfg.interfaces.services.SAML2CfgSecurityChecker;
import com.sap.security.saml2.cfg.interfaces.services.SAML2CfgStorage;
import com.sap.security.saml2.cfg.ljsadapters.SAML2CfgKeystoreServiceLJSAdapter;
import com.sap.security.saml2.cfg.ljsadapters.SAML2CfgSecurityCheckerLJSAdapter;
import com.sap.security.saml2.cfg.ljsadapters.filestorage.SAML2CfgFileStorageAdapter;
import com.sap.security.saml2.lib.common.SAML2Exception;
import com.sap.security.saml2.lib.common.SAML2ServicesManagerBase;
import com.sap.security.saml2.lib.common.exceptions.SAML2ServiceInstantiationException;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Map;

public final class SAML2CfgServicesManager
extends SAML2ServicesManagerBase {
    private static final String CFG_SECURITY_CHECKER_NW_ADAPTER = "com.sap.security.saml2.cfg.nwadapters.SAML2CfgSecurityCheckerNWAdapter";
    private static final String CFG_SECURITY_CHECKER_LJS_ADAPTER = "com.sap.security.saml2.cfg.ljsadapters.SAML2CfgSecurityCheckerLJSAdapter";
    private static final String CFG_KEYSTORE_SERVICE_NW_ADAPTER = "com.sap.security.saml2.cfg.nwadapters.SAML2CfgKeystoreServiceNWAdapter";
    private static final String CFG_KEYSTORE_SERVICE_LJS_ADAPTER = "com.sap.security.saml2.cfg.ljsadapters.SAML2CfgKeystoreServiceLJSAdapter";
    private static final String CFG_STORAGE_NW_ADAPTER = "com.sap.security.saml2.cfg.nwadapters.SAML2CfgStorageNWAdapter";
    private static final String CFG_STORAGE_LJS_ADAPTER = "com.sap.security.saml2.cfg.ljsadapters.filestorage.SAML2CfgFileStorageAdapter";
    private static final String HTTP_DESTINATIONS_NW_ADAPTER = "com.sap.security.saml2.cfg.nwadapters.HTTPDestinationServiceNWAdapter";
    private static final String HTTP_DESTINATIONS_LJS_ADAPTER = "com.sap.security.saml2.cfg.ljsadapters.HTTPDestinationServiceLJSAdapter";
    private static final Location LOCATION = Location.getLocation(SAML2CfgServicesManager.class);
    private static SAML2CfgFileStorageAdapter adapter;
    private static SAML2CfgKeystoreServiceLJSAdapter keyService;
    private static SAML2CfgSecurityCheckerLJSAdapter secChecker;
    private final Map<Class, Object> adapterInstances = new HashMap<Class, Object>();
    private static SAML2CfgServicesManager INSTANCE;

    static {
        INSTANCE = null;
    }

    public static SAML2CfgServicesManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SAML2CfgServicesManager();
            INSTANCE.registerCfg();
        }
        return INSTANCE;
    }

    private SAML2CfgServicesManager() {
    }

    private void registerCfg() {
        try {
            adapter = new SAML2CfgFileStorageAdapter();
            SAML2CfgServicesManager.getInstance().registerCfgStorage(adapter);
            keyService = new SAML2CfgKeystoreServiceLJSAdapter();
            SAML2CfgServicesManager.getInstance().registerCfgKeystoreService(keyService);
            secChecker = new SAML2CfgSecurityCheckerLJSAdapter();
            SAML2CfgServicesManager.getInstance().registerCfgSecurityChecker(secChecker);
        }
        catch (Exception e) {
            LOCATION.traceThrowableT(100, "Exception occurred while registering configuration objects in " + ((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    public void unregisterCfg() throws Exception {
        if (adapter != null) {
            SAML2CfgServicesManager.getInstance().unregisterCfgStorage(adapter);
            adapter = null;
        }
        if (keyService != null) {
            SAML2CfgServicesManager.getInstance().unregisterCfgKeystoreService(keyService);
            keyService = null;
        }
        if (secChecker != null) {
            SAML2CfgServicesManager.getInstance().unregisterCfgSecurityChecker(secChecker);
            secChecker = null;
        }
    }

    protected Object instantiateClass(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Class.forName(className).newInstance();
    }

    protected Map<Class, Object> getAdapterInstances() {
        return this.adapterInstances;
    }

    public SAML2CfgSecurityChecker getCfgSecurityCheckerInstance() throws SAML2ServiceInstantiationException {
        return (SAML2CfgSecurityChecker)this.instantiateService(SAML2CfgSecurityChecker.class, new String[]{CFG_SECURITY_CHECKER_NW_ADAPTER, CFG_SECURITY_CHECKER_LJS_ADAPTER});
    }

    public SAML2CfgKeystoreService getCfgKeystoreServiceInstance() throws SAML2ServiceInstantiationException {
        return (SAML2CfgKeystoreService)this.instantiateService(SAML2CfgKeystoreService.class, new String[]{CFG_KEYSTORE_SERVICE_NW_ADAPTER, CFG_KEYSTORE_SERVICE_LJS_ADAPTER});
    }

    public SAML2CfgStorage getCfgStorageInstance() throws SAML2ServiceInstantiationException {
        return (SAML2CfgStorage)this.instantiateService(SAML2CfgStorage.class, new String[]{CFG_STORAGE_NW_ADAPTER, CFG_STORAGE_LJS_ADAPTER});
    }

    public HTTPDestinationService getHTTPDestinationServiceInstance() throws SAML2ServiceInstantiationException {
        return (HTTPDestinationService)this.instantiateService(HTTPDestinationService.class, new String[]{HTTP_DESTINATIONS_NW_ADAPTER, HTTP_DESTINATIONS_LJS_ADAPTER});
    }

    public void registerCfgSecurityChecker(SAML2CfgSecurityChecker adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(SAML2CfgSecurityChecker.class, adapterInstance);
    }

    public void registerCfgKeystoreService(SAML2CfgKeystoreService adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(SAML2CfgKeystoreService.class, adapterInstance);
    }

    public void registerCfgStorage(SAML2CfgStorage adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(SAML2CfgStorage.class, adapterInstance);
    }

    public void registerHTTPDestinationService(HTTPDestinationService adapterInstance) throws SAML2Exception {
        this.registerServiceAdapter(HTTPDestinationService.class, adapterInstance);
    }

    public void unregisterCfgSecurityChecker(SAML2CfgSecurityChecker adapterInstance) {
        this.unregisterServiceAdapter(SAML2CfgSecurityChecker.class, adapterInstance);
    }

    public void unregisterCfgKeystoreService(SAML2CfgKeystoreService adapterInstance) {
        this.unregisterServiceAdapter(SAML2CfgKeystoreService.class, adapterInstance);
    }

    public void unregisterCfgStorage(SAML2CfgStorage adapterInstance) {
        this.unregisterServiceAdapter(SAML2CfgStorage.class, adapterInstance);
    }

    public void unregisterHTTPDestinationService(HTTPDestinationService adapterInstance) {
        this.unregisterServiceAdapter(HTTPDestinationService.class, adapterInstance);
    }
}

