/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.lm.sl.hcp.client.cmd.SlServiceBaseCommand;
import com.sap.cloud.lm.sl.hcp.client.cmd.converter.ExtensionsConverter;
import com.sap.cloud.lm.sl.hcp.client.cmd.converter.SourceConverter;
import com.sap.cloud.lm.sl.hcp.client.cmd.validator.DeployCommandValidator;
import com.sap.cloud.lm.sl.hcp.client.core.MtarRestClientImpl;
import com.sap.cloud.lm.sl.hcp.client.utils.CheckHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Deploys Multi-Target Application (MTA) archives")
public class DeployMTACommand
extends SlServiceBaseCommand {
    private static final Logger LOGGER = Logger.getLogger(DeployMTACommand.class);
    @Parameter(names={"-s", "--source"}, description="A comma-separated list of file locations, pointing to MTA archive files or folders containing them", converter=SourceConverter.class, validateWith=DeployCommandValidator.class)
    String source;
    @Parameter(names={"-e", "--extensions"}, description="A comma-separated list of file locations, pointing to extension descriptor files or folders containing them. (optional)", converter=ExtensionsConverter.class, validateWith=DeployCommandValidator.class)
    String extensions;
    @Parameter(names={"-y", "--synchronous"}, description="Triggers the deployment and waits until the deployment operation is finished. The command without the --synchronous parameter triggers deployment and exits immediately without waiting for operation to finish. Takes no value. (optional)")
    boolean synchronous;
    @Parameter(names={"--mode"}, description="Specify import mode. Acceptable values: 'import', 'providerImport', 'providerDeclare'. (optional)", validateWith=DeployCommandValidator.class)
    String mode;

    public String getName() {
        return "deploy-mta";
    }

    public void run() throws CommandException {
        this.dumpParameters(MessageFormat.format("Executing ''{0}'' with the following parameters", this.getName()));
        this.logParameters(LOGGER, this.getName());
        if (!CheckHelper.checkArgSpecified("-s", "--source", this.source, true)) {
            throw new HelpException("Source not specified", 10);
        }
        MtarRestClientImpl deployer = new MtarRestClientImpl(this.getUser(), this.getHost(), this.getAccount(), this.getOptionMap(), this.getHttpClient());
        deployer.deploy();
    }

    @Override
    public List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "source", this.source, "synchronous", this.synchronous, "subaccount", this.account, "host", this.host);
        if (this.extensions != null) {
            argsList.add("extensions");
            argsList.add(this.extensions);
        }
        if (this.mode != null) {
            argsList.add("mode");
            argsList.add(this.mode);
        }
        return argsList;
    }

    @Override
    public Map<String, String> getOptionMap() {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put("synchronous", this.synchronous ? "true" : "false");
        optionMap.put("source", this.source);
        optionMap.put("extensions", this.extensions);
        optionMap.put("mode", this.mode);
        return optionMap;
    }
}

