/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.lm.sl.hcp.client.cmd.SlServiceBaseCommand;
import com.sap.cloud.lm.sl.hcp.client.cmd.validator.IDParameterValidator;
import com.sap.cloud.lm.sl.hcp.client.core.InventoryException;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryClient;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryClientImpl;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMta;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Display deployed Multi-Target Application artefacts")
public class DisplayMTACommand
extends SlServiceBaseCommand {
    private static final Logger LOGGER = Logger.getLogger(DisplayMTACommand.class);
    @Parameter(names={"-i", "--id"}, description="ID of the Multi-Target Application")
    String id;

    @Override
    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
        new IDParameterValidator().validate("-i", this.id);
    }

    @Override
    public String getGroup() {
        return "mta";
    }

    public String getName() {
        return "display-mta";
    }

    public String getExample() {
        return super.getExample();
    }

    protected InventoryClient getInventoryClient() {
        return new InventoryClientImpl(this.getHttpClient(), this.getHost(), this.getAccount());
    }

    public void run() throws CommandException {
        this.dumpParameters(MessageFormat.format("Executing ''{0}'' with the following parameters", this.getName()));
        this.logParameters(LOGGER, this.getName());
        InventoryClient inventoryClient = this.getInventoryClient();
        try {
            DeployedMta mta = inventoryClient.getMta(this.id);
            InventoryOutputHelper.dumpAndLog(mta, this.getAccount());
        }
        catch (InventoryException exception) {
            LOGGER.error((Object)exception);
            throw new FrontendException("Error occurred on attempt to display the Multi-Target Application");
        }
    }

    @Override
    public List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "mta-id", this.id, "subaccount", this.account, "host", this.host);
        return argsList;
    }

    @Override
    public Map<String, String> getOptionMap() {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put("mta-id", this.id);
        return optionMap;
    }
}

