/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.lm.sl.hcp.client.cmd.SlServiceBaseCommand;
import com.sap.cloud.lm.sl.hcp.client.core.InventoryException;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryClient;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryClientImpl;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMta;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Parameters(commandDescription="List all deployed Multi-Target Applications in a subaccount")
public class ListMTAsCommand
extends SlServiceBaseCommand {
    private static final Logger LOGGER = Logger.getLogger(ListMTAsCommand.class);
    @Parameter(names={"--available-for-subscription"}, description="Shows deployed Multi-Target Applications (MTAs) in the specified account available for subscription.")
    boolean listAvailableForSubscription;

    @Override
    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
    }

    @Override
    public String getGroup() {
        return "mta";
    }

    public String getName() {
        return "list-mtas";
    }

    public boolean isListAvailableForSubscription() {
        return this.listAvailableForSubscription;
    }

    public String getExample() {
        return super.getExample();
    }

    protected InventoryClient getInventoryClient() {
        return new InventoryClientImpl(this.getHttpClient(), this.getHost(), this.getAccount());
    }

    public void run() throws CommandException {
        this.dumpParameters(MessageFormat.format("Executing ''{0}'' with the following parameters", this.getName()));
        this.logParameters(LOGGER, this.getName());
        InventoryClient inventoryClient = this.getInventoryClient();
        try {
            List<DeployedMta> mtas = null;
            mtas = !this.isListAvailableForSubscription() ? inventoryClient.getMtas() : inventoryClient.getEligibleForSubscriptionMtas();
            if (mtas == null || mtas.isEmpty()) {
                LOGGER.log((Priority)Level.INFO, (Object)"No Multi-Target Applications found");
                OutputHelper.printMessageWithDate("No Multi-Target Applications found");
            } else {
                InventoryOutputHelper.dumpAndLog(mtas, this.getAccount(), this.isListAvailableForSubscription());
            }
        }
        catch (InventoryException exception) {
            LOGGER.error((Object)exception);
            throw new FrontendException("Error occurred on attempt to list the Multi-Target Applications");
        }
    }

    @Override
    public List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "subaccount", this.account, "host", this.host);
        Collections.addAll(argsList, "available-for-subscription", Boolean.toString(this.isListAvailableForSubscription()));
        return argsList;
    }

    @Override
    public Map<String, String> getOptionMap() {
        return new HashMap<String, String>();
    }
}

