/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.lm.sl.hcp.client.cmd.SlServiceBaseCommand;
import com.sap.cloud.lm.sl.hcp.client.cmd.validator.ListMtaOperationCommandValidator;
import com.sap.cloud.lm.sl.hcp.client.core.MtarRestClientImpl;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployStateObject;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Parameters(commandDescription="Shows all MTA operations started in an subaccount within the last 24 hours.")
public class ListMtaOperationsCommand
extends SlServiceBaseCommand {
    @Parameter(names={"--operation-id"}, description="The ID of an MTA operation. (optional)", validateWith=ListMtaOperationCommandValidator.class)
    String operationId = null;
    private static final Logger LOGGER = Logger.getLogger(ListMtaOperationsCommand.class);

    public String getName() {
        return "list-mta-operations";
    }

    @Override
    public List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "operation-id", this.operationId, "subaccount", this.account, "host", this.host);
        return argsList;
    }

    public void run() throws CommandException {
        this.dumpParameters(MessageFormat.format("Executing ''{0}'' with the following parameters", this.getName()));
        this.logParameters(LOGGER, this.getName());
        this.listMtaStatus();
    }

    private void listMtaStatus() throws CommandException {
        MtarRestClientImpl deployer = new MtarRestClientImpl(this.getUser(), this.getHost(), this.getAccount(), this.getOptionMap(), this.getHttpClient());
        if (this.operationId == null) {
            List<DeployStateObject> currentState = deployer.getStatus();
            OutputHelper.printDeployStatus(currentState);
        } else {
            DeployStateObject currentState = deployer.getStatus(this.operationId);
            OutputHelper.printDeployStatus(currentState);
        }
    }

    @Override
    public Map<String, String> getOptionMap() {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put("operation-id", this.operationId);
        return optionMap;
    }
}

