/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.sap.cloud.lm.sl.hcp.client.utils.PreemptiveAuthInterceptor;
import com.sap.cloud.lm.sl.hcp.client.utils.UrlBuilder;
import com.sap.jpaas.infrastructure.console.command.AccountCommand;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public abstract class SlServiceBaseCommand
extends AccountCommand<Object> {
    private static final Logger LOGGER = Logger.getLogger(SlServiceBaseCommand.class);
    private CloseableHttpClient httpClient;

    protected HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = (CloseableHttpClient)this.getHttpClientInner();
            ((DefaultHttpClient)this.httpClient).addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
            ((DefaultHttpClient)this.httpClient).setCookieStore((CookieStore)new EmptyCookieStore());
            this.authorizeUser((HttpClient)this.httpClient);
        }
        return this.httpClient;
    }

    protected HttpClient getHttpClientInner() {
        return super.getHttpClient();
    }

    protected void authorizeUser(HttpClient httpClient) throws CommandException {
        String url = UrlBuilder.getSlServiceDestinationUrl(this.getHost(), String.format("/slservice/v1/basic/accounts/%s/", this.getAccount()), LOGGER);
        try {
            HttpGet httpGetFetch = new HttpGet(url);
            httpGetFetch.addHeader("X-CSRF-Token", "Fetch");
            httpClient.execute((HttpUriRequest)httpGetFetch);
        }
        catch (IOException e) {
            throw new BackendException((Exception)e);
        }
    }

    public void cleanup() throws CommandException {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                throw new FrontendException((Exception)e);
            }
        }
    }

    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
    }

    public String getGroup() {
        return "mta";
    }

    public void dumpParameters(String message) {
        List<Object> argsList = this.getArgsList();
        DumpHelper.dumpOperationList((String)this.user, (String)message, (Object[])argsList.toArray());
    }

    protected void logParameters(Logger LOGGER, String command) {
        Map<String, String> parameters = this.getOptionMap();
        LOGGER.info((Object)MessageFormat.format("Executing ''{0}'' with the following parameters", command));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            LOGGER.info((Object)(entry.getKey() + ": " + entry.getValue()));
        }
    }

    public abstract List<Object> getArgsList();

    public abstract Map<String, String> getOptionMap();

    public final class EmptyCookieStore
    implements CookieStore {
        public void addCookie(Cookie cookie) {
        }

        public List<Cookie> getCookies() {
            return Collections.emptyList();
        }

        public boolean clearExpired(Date date) {
            return false;
        }

        public void clear() {
        }
    }
}

