/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.lm.sl.hcp.client.cmd.SlServiceBaseCommand;
import com.sap.cloud.lm.sl.hcp.client.cmd.converter.ExtensionsConverter;
import com.sap.cloud.lm.sl.hcp.client.cmd.validator.ExtensionDescriptorsFilesValidator;
import com.sap.cloud.lm.sl.hcp.client.cmd.validator.SolutionValidator;
import com.sap.cloud.lm.sl.hcp.client.core.OperationClient;
import com.sap.cloud.lm.sl.hcp.client.core.OperationException;
import com.sap.cloud.lm.sl.hcp.client.core.subscribe.SubscribeMTAsOperationClientImpl;
import com.sap.cloud.lm.sl.hcp.client.core.subscribe.SubscribeOperationOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import com.sap.lmsl.slp.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Parameters(commandDescription="Subscribes to deployed Multi-Target Applications (MTAs) available for subscription")
public class SubscribeMTAsCommand
extends SlServiceBaseCommand {
    private static final Logger LOGGER = Logger.getLogger(SubscribeMTAsCommand.class);
    @Parameter(names={"--id"}, description="The provider subaccount and MTA ID to subscribe to in format <provider subaccount>:<MTA ID>.")
    String id;
    @Parameter(names={"-e", "--extensions"}, description="A comma-separated list of file locations, pointing to extension descriptor files or folders containing them. (optional)", converter=ExtensionsConverter.class, validateWith=ExtensionDescriptorsFilesValidator.class)
    String extensions;
    @Parameter(names={"-y", "--synchronous"}, description="Triggers the deletion and waits until the operation finishes. The command without the --synchronous parameter triggers deletion and exits immediately without waiting for operation to finish. Takes no value. (optional)")
    boolean synchronous;
    String mtaId;
    String providerAccount;

    @Override
    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
        new SolutionValidator().validate("--id", this.id);
        this.convertSolutionToSubParameters();
    }

    @Override
    public String getGroup() {
        return "mta";
    }

    public String getName() {
        return "subscribe-mta";
    }

    public String getExample() {
        return super.getExample();
    }

    protected String getMtaId() {
        return this.mtaId;
    }

    protected String getExtensions() {
        return this.extensions;
    }

    protected String getProviderAccount() {
        return this.providerAccount;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    protected OperationClient getOperationClient() {
        return new SubscribeMTAsOperationClientImpl(this.getHttpClient(), this.getUser(), new SubscribeOperationOutputHelper());
    }

    public void run() throws CommandException {
        this.dumpParameters(MessageFormat.format("Executing ''{0}'' with the following parameters", this.getName()));
        this.logParameters(LOGGER, this.getName());
        try {
            OperationClient operationClient = this.getOperationClient();
            Map<String, Object> operationStartParameters = this.getOperationStartParameters();
            if (this.getExtensions() != null) {
                List<File> extensionsData = operationClient.upload(this.convertExtensions(this.getExtensions()), operationStartParameters);
                operationStartParameters.put("extensions", extensionsData);
            }
            operationClient.startOperation(operationStartParameters);
            if (this.isSynchronous()) {
                operationClient.monitorOperation();
            } else {
                String message = MessageFormat.format("Use ''{0}'' to retrieve the status of the subscribe operation", "list-mta-operations");
                LOGGER.log((Priority)Level.INFO, (Object)message);
                OutputHelper.printMessageWithDate(message);
            }
        }
        catch (OperationException exception) {
            LOGGER.error((Object)exception);
            throw new FrontendException("Error occurred on attempt to subscribe to the Multi-Target Application");
        }
    }

    private void convertSolutionToSubParameters() {
        String[] split = this.id.split(":", 2);
        this.providerAccount = split[0];
        this.mtaId = split[1];
    }

    private List<String> convertExtensions(String extensions) {
        return Arrays.asList(extensions.split(","));
    }

    private Map<String, Object> getOperationStartParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("host", this.getHost());
        parameters.put("account", this.getAccount());
        parameters.put("providerAccount", this.getProviderAccount());
        parameters.put("mtaIds", this.getMtaId());
        return parameters;
    }

    @Override
    public List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "id", this.id, "synchronous", this.synchronous, "subaccount", this.account, "host", this.host);
        if (this.extensions != null) {
            Collections.addAll(argsList, "extensions", this.extensions);
        }
        return argsList;
    }

    @Override
    public Map<String, String> getOptionMap() {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put("id", this.id);
        optionMap.put("extensions", this.extensions);
        optionMap.put("synchronous", this.synchronous ? "true" : "false");
        return optionMap;
    }
}

