/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.lm.sl.hcp.client.cmd.SlServiceBaseCommand;
import com.sap.cloud.lm.sl.hcp.client.cmd.validator.IDsParameterValidator;
import com.sap.cloud.lm.sl.hcp.client.core.OperationClient;
import com.sap.cloud.lm.sl.hcp.client.core.OperationException;
import com.sap.cloud.lm.sl.hcp.client.core.undeploy.UndeployMTAsOperationClientImpl;
import com.sap.cloud.lm.sl.hcp.client.core.undeploy.UndeployOperationOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.FrontendException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Parameters(commandDescription="Deletes deployed Multi-Target Applications")
public class UndeployMTAsCommand
extends SlServiceBaseCommand {
    private static final Logger LOGGER = Logger.getLogger(UndeployMTAsCommand.class);
    @Parameter(names={"-i", "--id"}, description="A comma-separated list of MTA IDs")
    String id;
    @Parameter(names={"-y", "--synchronous"}, description="Triggers the deletion and waits until the operation finishes. The command without the --synchronous parameter triggers deletion and exits immediately without waiting for operation to finish. Takes no value. (optional)")
    boolean synchronous;

    @Override
    public void init() throws CommandException {
        super.initWithNoPasswordCheck();
        new IDsParameterValidator().validate("-i", this.id);
    }

    @Override
    public String getGroup() {
        return "mta";
    }

    public String getName() {
        return "delete-mta";
    }

    public String getExample() {
        return super.getExample();
    }

    protected String getId() {
        return this.id;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    protected OperationClient getOperationClient() {
        return new UndeployMTAsOperationClientImpl(this.getHttpClient(), this.getUser(), new UndeployOperationOutputHelper());
    }

    public void run() throws CommandException {
        this.dumpParameters(MessageFormat.format("Executing ''{0}'' with the following parameters", this.getName()));
        this.logParameters(LOGGER, this.getName());
        try {
            OperationClient operationClient = this.getOperationClient();
            operationClient.startOperation(this.getOperationStartParameters());
            if (this.isSynchronous()) {
                operationClient.monitorOperation();
            } else {
                String message = MessageFormat.format("Use ''{0}'' to retrieve the status of the deletetion operation", "list-mta-operations");
                LOGGER.log((Priority)Level.INFO, (Object)message);
                OutputHelper.printMessageWithDate(message);
            }
        }
        catch (OperationException exception) {
            LOGGER.error((Object)exception);
            throw new FrontendException("Error occurred on attempt to delete the Multi-Target Application");
        }
    }

    private Map<String, Object> getOperationStartParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("host", this.getHost());
        parameters.put("account", this.getAccount());
        parameters.put("mtaIds", this.getId());
        return parameters;
    }

    @Override
    public List<Object> getArgsList() {
        ArrayList<Object> argsList = new ArrayList<Object>();
        Collections.addAll(argsList, "mta-id", this.id, "synchronous", this.synchronous, "delete DB bindings", "true", "cleanup on error", "true", "subaccount", this.account, "host", this.host);
        return argsList;
    }

    @Override
    public Map<String, String> getOptionMap() {
        HashMap<String, String> optionMap = new HashMap<String, String>();
        optionMap.put("mta-id", this.id);
        optionMap.put("synchronous", this.synchronous ? "true" : "false");
        optionMap.put("delete DB bindings", "true");
        optionMap.put("cleanup on error", "true");
        return optionMap;
    }
}

