/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.cmd.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;
import com.sap.cloud.lm.sl.hcp.client.utils.CheckHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.Constants;
import java.text.MessageFormat;

public class DeployCommandValidator
implements IParameterValidator {
    public void validate(String param, String value) throws ParameterException {
        if (param.equals("--source") || param.equals("-s")) {
            CheckHelper.validateFileLocations(value, "-s", "--source", "mtar");
        } else if (param.equals("--extensions") || param.equals("-e")) {
            CheckHelper.validateFileLocations(value, "-e", "--extensions", "mtaext");
        } else if (param.equals("--mode")) {
            this.validateMode(value);
        }
    }

    private void validateMode(String value) {
        if (value == null || value.trim().equalsIgnoreCase("")) {
            throw new ParameterException(MessageFormat.format("Parameter ''{0}'' does not accept empty value", "--mode"));
        }
        if (!Constants.ImportMode.contains(value)) {
            throw new ParameterException(MessageFormat.format("Value of parameter ''{0}'' is not valid", "--mode"));
        }
    }
}

