/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.core;

import com.google.gson.Gson;
import com.sap.cloud.lm.sl.hcp.client.core.MTAsOperationParametersBuilder;
import com.sap.cloud.lm.sl.hcp.client.core.MtarRestClient;
import com.sap.cloud.lm.sl.hcp.client.core.MtarRestClientImpl;
import com.sap.cloud.lm.sl.hcp.client.core.OperationClient;
import com.sap.cloud.lm.sl.hcp.client.core.OperationException;
import com.sap.cloud.lm.sl.hcp.client.core.deploy.AsyncDeployProgressMonitor;
import com.sap.cloud.lm.sl.hcp.client.utils.OperationOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.UrlBuilder;
import com.sap.cloud.lm.sl.slp.client.HttpClientException;
import com.sap.cloud.lm.sl.slp.client.HttpResponseException;
import com.sap.cloud.lm.sl.slp.client.ISlpManagementClient;
import com.sap.cloud.lm.sl.slp.client.ISlpProcessClient;
import com.sap.cloud.lm.sl.slp.client.ResponseEntity;
import com.sap.cloud.lm.sl.slp.client.SlpClientFactory;
import com.sap.cloud.lm.sl.slp.client.communication.CommunicationException;
import com.sap.lmsl.slp.Process;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractMTAsOperationClientImpl
implements OperationClient {
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private static final String SLP_BASIC_URL = "slservice/slp/basic/%s/slp";
    private static final String SLP_START_ACTION = "start";
    private HttpClient httpClient = null;
    private String principal = null;
    private String operationId = null;
    private OperationOutputHelper operationOutputHelper = null;
    private Map<String, Object> operationStartParameters = null;

    public AbstractMTAsOperationClientImpl(HttpClient httpClient, String principal, OperationOutputHelper operationOutputHelper) {
        this.httpClient = httpClient;
        this.principal = principal;
        this.operationOutputHelper = operationOutputHelper;
    }

    protected void startOperation(MTAsOperationParametersBuilder mtasOperationParametersBuilder, Map<String, Object> operationStartParameters) throws OperationException {
        this.setOperationStartParamters(operationStartParameters);
        this.ensureOperationStartParameters(this.getOperationStartParameters());
        String host = (String)this.getOperationStartParameter("host");
        String subaccount = (String)this.getOperationStartParameter("account");
        String slpBaseURL = UrlBuilder.getSlServiceDestinationUrl(host, String.format(SLP_BASIC_URL, subaccount), this.LOGGER);
        SlpClientFactory factory = this.getSlpClientFactoryInstance();
        Process processRequest = mtasOperationParametersBuilder.build(operationStartParameters);
        try {
            ISlpManagementClient managementClient = factory.createManagementClient(slpBaseURL, this.httpClient);
            Process processResult = managementClient.createProcess(processRequest);
            this.setOperationId(processResult.getId());
            ISlpProcessClient processClient = factory.createProcessClient(slpBaseURL, processResult.getRootURL(), this.httpClient);
            processClient.executeAction(SLP_START_ACTION);
            String operationIdStartedMsg = this.operationOutputHelper.getOperationStartedMessage(this.getOperationId());
            this.LOGGER.log((Priority)Level.INFO, (Object)operationIdStartedMsg);
            OutputHelper.printMessageWithDate(operationIdStartedMsg);
        }
        catch (HttpClientException exception) {
            String msg = null;
            msg = this.getOperationId() == null ? MessageFormat.format("Failed to create ''{0}'' operation", this.getOperationName()) : MessageFormat.format("Failed to create ''{0}'' operation", this.getOperationName(), this.getOperationId());
            msg = this.decorateErrorMessageWithServerResponse(msg, exception);
            this.LOGGER.error((Object)exception);
            this.LOGGER.log((Priority)Level.ERROR, (Object)msg);
            throw new OperationException(msg, exception);
        }
    }

    @Override
    public List<com.sap.lmsl.slp.File> upload(List<String> filePaths, Map<String, Object> operationStartParameters) throws OperationException {
        this.setOperationStartParamters(operationStartParameters);
        this.ensureOperationStartParameters(this.getOperationStartParameters());
        String host = (String)this.getOperationStartParameter("host");
        String subaccount = (String)this.getOperationStartParameter("account");
        String slpBaseURL = UrlBuilder.getSlServiceDestinationUrl(host, String.format(SLP_BASIC_URL, subaccount), this.LOGGER);
        List result = null;
        try {
            SlpClientFactory factory = this.getSlpClientFactoryInstance();
            ISlpManagementClient managementClient = factory.createManagementClient(slpBaseURL, this.httpClient);
            ArrayList<File> files = new ArrayList<File>();
            for (String filePath : filePaths) {
                files.add(new File(filePath.trim()));
            }
            result = managementClient.uploadServiceFiles(this.getOperationName(), files.toArray(new File[files.size()]));
        }
        catch (ParseException exception) {
            this.logAndThrowOnUpload(exception);
        }
        catch (IllegalStateException exception) {
            this.logAndThrowOnUpload(exception);
        }
        catch (FactoryConfigurationError exception) {
            this.logAndThrowOnUpload(exception);
        }
        catch (HttpClientException exception) {
            this.logAndThrowOnUpload(exception);
        }
        return result;
    }

    @Override
    public void monitorOperation() throws OperationException {
        MtarRestClient monitoringRestClient = this.getMtarRestClient();
        AsyncDeployProgressMonitor asyncTracker = this.getAsyncDeployProgressMonitor(this.getOperationId(), monitoringRestClient);
        asyncTracker.start();
    }

    protected MtarRestClient getMtarRestClient() throws OperationException {
        String host = (String)this.getOperationStartParameter("host");
        String subaccount = (String)this.getOperationStartParameter("account");
        return new MtarRestClientImpl(this.principal, host, subaccount, new HashMap<String, String>(), this.httpClient);
    }

    protected AsyncDeployProgressMonitor getAsyncDeployProgressMonitor(String operationId, MtarRestClient monitoringRestClient) {
        return new AsyncDeployProgressMonitor(operationId, monitoringRestClient, this.operationOutputHelper);
    }

    private void ensureOperationStartParameters(Map<String, Object> operationStartParameters) throws OperationException {
        if (operationStartParameters == null || operationStartParameters.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    private Object getOperationStartParameter(String key) throws OperationException {
        Map<String, Object> operationStartParameters = this.getOperationStartParameters();
        Object startParameter = operationStartParameters.get(key);
        if (startParameter == null) {
            throw new OperationException(MessageFormat.format("Value of parameter ''{0}'' is not valid", key));
        }
        return startParameter;
    }

    private Map<String, Object> getOperationStartParameters() {
        return this.operationStartParameters;
    }

    private void setOperationStartParamters(Map<String, Object> operationStartParameters) {
        this.operationStartParameters = operationStartParameters;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    protected SlpClientFactory getSlpClientFactoryInstance() {
        return SlpClientFactory.getInstance();
    }

    protected InputStream getFileInputStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    private void logAndThrowOnUpload(Throwable cause) throws OperationException {
        this.LOGGER.error((Object)cause);
        this.LOGGER.log((Priority)Level.ERROR, (Object)"Failed to upload provided files");
        throw new OperationException("Failed to upload provided files", cause);
    }

    private String decorateErrorMessageWithServerResponse(String errorMessage, HttpClientException exception) {
        SlServiceError slServiceError;
        ResponseEntity responseEntity = this.extractResponseEntity(exception);
        if (responseEntity != null && (slServiceError = (SlServiceError)new Gson().fromJson(new String(responseEntity.getContent()), SlServiceError.class)) != null && slServiceError.getMessage() != null && !slServiceError.getMessage().isEmpty()) {
            errorMessage = String.format("%s. %s.", errorMessage, MessageFormat.format("Response is: ''{0}''", slServiceError.getMessage()));
        }
        return errorMessage;
    }

    private ResponseEntity extractResponseEntity(HttpClientException exception) {
        if (exception instanceof CommunicationException) {
            Throwable cause = ((CommunicationException)exception).getCause();
            if (cause instanceof HttpResponseException) {
                return ((HttpResponseException)cause).getResponseEntity();
            }
            if (cause instanceof HttpClientException) {
                return ((HttpClientException)cause).getResponseEntity();
            }
        }
        return null;
    }

    public static class SlServiceError {
        private String code;
        private String message;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

