/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.core;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.sap.cloud.lm.sl.hcp.client.core.MtarRestClient;
import com.sap.cloud.lm.sl.hcp.client.core.deploy.AsyncDeployProgressMonitor;
import com.sap.cloud.lm.sl.hcp.client.core.deploy.DeployOperationOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployStateObject;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.ResultBuilder;
import com.sap.cloud.lm.sl.hcp.client.utils.UrlBuilder;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class MtarRestClientImpl
implements MtarRestClient {
    private HttpClient client = null;
    private Map<String, String> commandMap = null;
    private String host = null;
    private String account = null;
    private String user = null;
    private static final Logger LOGGER = Logger.getLogger(MtarRestClientImpl.class);

    public MtarRestClientImpl(String user, String host, String account, Map<String, String> commandMap, HttpClient client) {
        assert (client != null) : "HttpClient must not be null";
        assert (commandMap != null) : "Parameters must not be null";
        assert (user != null) : "Parameter user must not be null";
        assert (host != null) : "Parameter host must not be null";
        assert (account != null) : "Parameter account must not be null";
        this.user = user;
        this.host = host;
        this.account = account;
        this.client = client;
        this.commandMap = commandMap;
    }

    private String getQueryParams() {
        String result = "";
        String mode = this.commandMap.get("mode");
        if (mode != null) {
            result = "?mode=" + mode;
        }
        return result;
    }

    private JsonObject toJson(String jsonObj) throws JsonSyntaxException {
        JsonParser parser = new JsonParser();
        return parser.parse(jsonObj).getAsJsonObject();
    }

    private JsonArray toJsonArray(String jsonArray) throws JsonSyntaxException {
        JsonParser parser = new JsonParser();
        return parser.parse(jsonArray).getAsJsonArray();
    }

    private void deployArchives() throws BackendException {
        String deployURL = UrlBuilder.getSlServiceDestinationUrl(this.host, String.format("/slservice/v1/basic/accounts/%s/mtars", this.account) + this.getQueryParams(), LOGGER);
        HttpPost post = new HttpPost(deployURL);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        ArrayList<String> fileNames = new ArrayList<String>();
        String archiveNamesStr = this.commandMap.get("source");
        fileNames.addAll(Arrays.asList(archiveNamesStr.split(",")));
        String extDescriptorNamesStr = this.commandMap.get("extensions");
        if (extDescriptorNamesStr != null) {
            fileNames.addAll(Arrays.asList(extDescriptorNamesStr.split(",")));
        }
        for (String fileName : fileNames) {
            fileName = fileName.trim();
            FileBody bin = new FileBody(new File(fileName));
            multipartEntityBuilder.addPart("file[]", (ContentBody)bin);
        }
        HttpEntity entity = multipartEntityBuilder.build();
        post.setEntity(entity);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new BackendException(MessageFormat.format("Response status code ''{0}'' and message ''{1}''.", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            HttpEntity resEntity = response.getEntity();
            String retBody = EntityUtils.toString((HttpEntity)resEntity);
            JsonObject jobject = this.toJson(retBody);
            if (jobject.get("id") == null) {
                throw new BackendException(MessageFormat.format("Can not parse ''{0}'' from server response", "operation-id"));
            }
            String operationId = jobject.get("id").getAsString();
            this.validateImportOperationId(operationId);
            OutputHelper.dump((String)MessageFormat.format("Deployment operation with id ''{0}'' started.", operationId));
            if (this.commandMap.get("synchronous").equalsIgnoreCase("true")) {
                this.trackingProgress(operationId);
            }
        }
        catch (ClientProtocolException ex) {
            throw new BackendException((Exception)((Object)ex));
        }
        catch (JsonSyntaxException jex) {
            throw new BackendException((Exception)((Object)jex));
        }
        catch (IOException ioe) {
            throw new BackendException((Exception)ioe);
        }
        catch (ParseException e) {
            throw new BackendException((Exception)((Object)e));
        }
    }

    private void validateImportOperationId(String operationId) {
        if (!operationId.matches("[a-z][0-9]{1,20}")) {
            throw new CommandException(MessageFormat.format("Import Operation ID ''{0}'' is not valid", operationId));
        }
    }

    private void trackingProgress(String operationId) throws BackendException {
        AsyncDeployProgressMonitor asyncTracker = new AsyncDeployProgressMonitor(operationId, this, new DeployOperationOutputHelper());
        asyncTracker.start();
    }

    private DeployStateObject formatNormalOutput(JsonObject retObj) {
        Gson gson = new Gson();
        DeployStateObject currentState = (DeployStateObject)gson.fromJson((JsonElement)retObj, DeployStateObject.class);
        return currentState;
    }

    private List<DeployStateObject> formatArrayOutput(JsonArray retArray) {
        Gson gson = new Gson();
        ArrayList<DeployStateObject> currentState = new ArrayList<DeployStateObject>();
        for (JsonElement retObj : retArray) {
            currentState.add((DeployStateObject)gson.fromJson((JsonElement)retObj.getAsJsonObject(), DeployStateObject.class));
        }
        return currentState;
    }

    @Override
    public void deploy() throws CommandException {
        this.deployArchives();
    }

    private String requestDeployStatus(String operationId) throws BackendException {
        HttpResponse response;
        String url = UrlBuilder.getSlServiceDestinationUrl(this.host, String.format("/slservice/v1/basic/accounts/%s/mtars/%s", this.account, operationId), LOGGER);
        HttpGet request = new HttpGet(url);
        try {
            response = this.client.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new BackendException((Exception)e);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            LOGGER.error((Object)MessageFormat.format("Could not get status for MTA operation {0}", operationId));
            LOGGER.error((Object)(response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase()));
            switch (response.getStatusLine().getStatusCode()) {
                case 401: {
                    throw new CommandException(ResultBuilder.getErrorMessageForHttpStatusUnauthorized(response));
                }
                case 404: {
                    throw new CommandException(MessageFormat.format("Unknown ID ''{0}''", operationId));
                }
                case 403: {
                    throw new CommandException(String.format("Access to %s is not allowed from your network. Contact SAP HANA Cloud Platform for help", url));
                }
                case 503: {
                    throw new CommandException("Could not connect to server. Possible reasons might be limited Internet access or misspelled SAP HANA Cloud Platform host.");
                }
            }
            throw new CommandException(MessageFormat.format("Could not get status for MTA operation {0}", operationId));
        }
        HttpEntity resEntity = response.getEntity();
        try {
            return EntityUtils.toString((HttpEntity)resEntity);
        }
        catch (ParseException e) {
            throw new BackendException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new BackendException((Exception)e);
        }
    }

    @Override
    public DeployStateObject getStatus(String operationId) throws CommandException {
        String bodyText = this.requestDeployStatus(operationId);
        try {
            JsonObject ret = this.toJson(bodyText);
            return this.formatNormalOutput(ret);
        }
        catch (JsonSyntaxException e) {
            throw new BackendException("Can not parse mta status from server", (Throwable)e);
        }
    }

    @Override
    public List<DeployStateObject> getStatus() throws CommandException {
        String bodyText = this.requestDeployStatus("");
        try {
            JsonArray ret = this.toJsonArray(bodyText);
            return this.formatArrayOutput(ret);
        }
        catch (JsonSyntaxException e) {
            throw new BackendException("Can not parse mta status from server", (Throwable)e);
        }
    }
}

