/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.core.deploy;

import com.sap.cloud.lm.sl.hcp.client.core.OperationProcessor;
import com.sap.cloud.lm.sl.hcp.client.core.json.DeployStateObject;
import com.sap.cloud.lm.sl.hcp.client.utils.Constants;
import com.sap.cloud.lm.sl.hcp.client.utils.OperationOutputHelper;
import com.sap.cloud.lm.sl.hcp.client.utils.OutputHelper;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.progress.ProgressListener;
import com.sap.jpaas.infrastructure.console.progress.ProgressMonitor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AsyncDeployProgressMonitor
extends ProgressListener<OperationProcessor, DeployStateObject> {
    private String operationId = null;
    ProgressMonitor monitor = null;
    private DeployStateObject newState = null;
    private OperationOutputHelper operationOutputHelper = null;

    public AsyncDeployProgressMonitor(String operationId, OperationProcessor operationProcessor, OperationOutputHelper operationOutputHelper) {
        this.operationId = operationId;
        this.operationOutputHelper = operationOutputHelper;
        this.setProcessor(operationProcessor);
    }

    public void failed() {
        String operationFailedMessage = this.operationOutputHelper.getOperationFailedMessage(this.operationId);
        if (operationFailedMessage != null) {
            OutputHelper.printMessageWithDate(operationFailedMessage);
        }
    }

    public void finished() {
        String operationFinishedMessage = this.operationOutputHelper.getOperationFinishedMessage(this.operationId);
        if (operationFinishedMessage != null) {
            OutputHelper.printMessageWithDate(operationFinishedMessage);
        }
    }

    public boolean progressCheck(ScheduledFuture arg0) throws CommandException {
        if (this.newState == null) {
            return false;
        }
        this.operationOutputHelper.printIncrementalDeployStatus(this.newState, (DeployStateObject)this.getStatusCheck());
        this.setStatusCheck(this.newState);
        if (((DeployStateObject)this.getStatusCheck()).getState().equalsIgnoreCase(Constants.DeployState.FAILED.toString())) {
            throw new CommandException("MTA deployment failed.", 1);
        }
        return ((DeployStateObject)this.getStatusCheck()).getState().equalsIgnoreCase(Constants.DeployState.DONE.toString());
    }

    public void start() throws CommandException {
        this.monitor = new ProgressMonitor();
        this.monitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AsyncDeployProgressMonitor.this.newState = ((OperationProcessor)AsyncDeployProgressMonitor.this.getProcessor()).getStatus(AsyncDeployProgressMonitor.this.operationId);
            }
        }, 1000L, 3000L, TimeUnit.MILLISECONDS);
        ScheduledFuture progressHandler = this.monitor.startProgress((ProgressListener)this, (long)Constants.DEPLOY_TIMER_INIT_WAITING, (long)Constants.DEPLOY_TIMER_INTERVAL, Constants.DEPLOY_TIMER_TIMEOUT_INTERVAL, (long)Constants.DEPLOY_TIMER_PROGRESS_NOTIFICATION_TIMEOUT, TimeUnit.MILLISECONDS);
        this.monitor.waitFor(progressHandler);
    }

    public void progressNotification() {
    }
}

