/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.core.subscribe;

import com.sap.lmsl.slp.ComponentVersion;
import com.sap.lmsl.slp.File;
import com.sap.lmsl.slp.Parameter;
import com.sap.lmsl.slp.Parameters;
import com.sap.lmsl.slp.Process;
import com.sap.lmsl.slp.SlpParameterType;
import com.sap.lmsl.slp.Tuple;
import com.sap.lmsl.slp.Versions;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class SubscribeParametersBuilder {
    public static Process buildProcessRequest(String providerAccount, String mtaId, List<File> extDescriptors) {
        Parameters slpParameters = SubscribeParametersBuilder.buildSlpParameters(providerAccount, mtaId, extDescriptors);
        return SubscribeParametersBuilder.buildSlpProcess("CTS_DEPLOY", "CTS_DEPLOY_VERSIONS_1.0", "1.0", slpParameters);
    }

    private static Process buildSlpProcess(String slpServiceId, String slpServiceVersionId, String slpServiceVersion, Parameters slpParameters) {
        Process process = new Process();
        process.setService(slpServiceId);
        Versions versions = new Versions();
        ComponentVersion componentVersion = new ComponentVersion();
        componentVersion.setId(slpServiceVersionId);
        componentVersion.setComponent(slpServiceId);
        componentVersion.setVersion(slpServiceVersion);
        versions.getComponentVersion().add(componentVersion);
        process.setVersions(versions);
        process.setParameters(slpParameters);
        return process;
    }

    private static Parameters buildSlpParameters(String providerAccountValue, String mtaId, List<File> extDescriptors) {
        Parameters parameters = new Parameters();
        Parameter ctsProcessId = new Parameter();
        ctsProcessId.setId("ctsProcessId");
        ctsProcessId.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
        ctsProcessId.setValue(UUID.randomUUID().toString());
        parameters.getParameter().add(ctsProcessId);
        Parameter applType = new Parameter();
        applType.setId("applType");
        applType.setValue("HCP");
        parameters.getParameter().add(applType);
        Parameter importMode = new Parameter();
        importMode.setId("importMode");
        importMode.setValue("consumerImport");
        importMode.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
        parameters.getParameter().add(importMode);
        Parameter generateExtDescriptor = new Parameter();
        generateExtDescriptor.setId("generateDescriptorTemplate");
        generateExtDescriptor.setValue("false");
        generateExtDescriptor.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
        parameters.getParameter().add(generateExtDescriptor);
        Parameter providerAccount = new Parameter();
        providerAccount.setId("providerAccount");
        providerAccount.setValue(providerAccountValue);
        providerAccount.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
        parameters.getParameter().add(providerAccount);
        parameters.getParameter().add(SubscribeParametersBuilder.buildSubscribeMtasListParameter(mtaId));
        if (extDescriptors != null && !extDescriptors.isEmpty()) {
            parameters.getParameter().add(SubscribeParametersBuilder.buildSubscribeExtDescriptorsListParameter(extDescriptors));
        }
        return parameters;
    }

    private static Parameter buildSubscribeMtasListParameter(String mtaId) {
        List<String> mtaIds = Arrays.asList(mtaId);
        Parameter subscribeMtasList = new Parameter();
        subscribeMtasList.setId("mtaId");
        Parameter.Tablevalue tableValue = new Parameter.Tablevalue();
        for (int i = 0; i < mtaIds.size(); ++i) {
            Tuple tuple = new Tuple();
            Parameters tupleValue = new Parameters();
            tuple.setValue(tupleValue);
            tuple.setId(Integer.toString(i + 1));
            Parameter mtaIdParameter = new Parameter();
            mtaIdParameter.setId("mtaId");
            mtaIdParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            mtaIdParameter.setValue(mtaIds.get(i).trim());
            tupleValue.getParameter().add(mtaIdParameter);
            tableValue.getTuple().add(tuple);
        }
        subscribeMtasList.setTablevalue(tableValue);
        return subscribeMtasList;
    }

    private static Parameter buildSubscribeExtDescriptorsListParameter(List<File> extDescriptors) {
        Parameter extDescritporsList = new Parameter();
        extDescritporsList.setId("extensionDescriptorList");
        Parameter.Tablevalue tableValue = new Parameter.Tablevalue();
        for (int i = 0; i < extDescriptors.size(); ++i) {
            Tuple tuple = new Tuple();
            Parameters tupleValue = new Parameters();
            tuple.setValue(tupleValue);
            tuple.setId(Integer.toString(i + 1));
            Parameter fileIdParameter = new Parameter();
            fileIdParameter.setId("fileId");
            fileIdParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            fileIdParameter.setValue(extDescriptors.get(i).getId());
            tupleValue.getParameter().add(fileIdParameter);
            Parameter fileNameParameter = new Parameter();
            fileNameParameter.setId("fileName");
            fileNameParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            fileNameParameter.setValue(extDescriptors.get(i).getFileName());
            tupleValue.getParameter().add(fileNameParameter);
            Parameter filePathParameter = new Parameter();
            filePathParameter.setId("filePath");
            filePathParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            filePathParameter.setValue(extDescriptors.get(i).getFilePath());
            tupleValue.getParameter().add(filePathParameter);
            Parameter digestAlgorithmParameter = new Parameter();
            digestAlgorithmParameter.setId("digestAlgorithm");
            digestAlgorithmParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            digestAlgorithmParameter.setValue(extDescriptors.get(i).getDigestAlgorithm());
            tupleValue.getParameter().add(digestAlgorithmParameter);
            Parameter digestParameter = new Parameter();
            digestParameter.setId("digest");
            digestParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            digestParameter.setValue(extDescriptors.get(i).getDigest());
            tupleValue.getParameter().add(digestParameter);
            tableValue.getTuple().add(tuple);
        }
        extDescritporsList.setTablevalue(tableValue);
        return extDescritporsList;
    }
}

