/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.core.undeploy;

import com.sap.lmsl.slp.ComponentVersion;
import com.sap.lmsl.slp.Parameter;
import com.sap.lmsl.slp.Parameters;
import com.sap.lmsl.slp.Process;
import com.sap.lmsl.slp.SlpParameterType;
import com.sap.lmsl.slp.Tuple;
import com.sap.lmsl.slp.Versions;
import java.text.MessageFormat;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class UndeployParametersBuilder {
    private static final Logger LOGGER = Logger.getLogger(UndeployParametersBuilder.class);

    public static Process buildProcessRequest(List<String> mtaIds) {
        Parameters slpParameters = UndeployParametersBuilder.buildSlpParameters(mtaIds);
        return UndeployParametersBuilder.buildSlpProcess("MTAS_UNDEPLOY", "MTAS_UNDEPLOY_VERSIONS_1.0", "1.0", slpParameters);
    }

    private static Process buildSlpProcess(String slpServiceId, String slpServiceVersionId, String slpServiceVersion, Parameters slpParameters) {
        Process process = new Process();
        process.setService(slpServiceId);
        Versions versions = new Versions();
        ComponentVersion componentVersion = new ComponentVersion();
        componentVersion.setId(slpServiceVersionId);
        componentVersion.setComponent(slpServiceId);
        componentVersion.setVersion(slpServiceVersion);
        versions.getComponentVersion().add(componentVersion);
        process.setVersions(versions);
        process.setParameters(slpParameters);
        return process;
    }

    private static Parameters buildSlpParameters(List<String> mtaIds) {
        Parameters parameters = new Parameters();
        Parameter ctsProcessId = new Parameter();
        ctsProcessId.setId("ctsProcessId");
        ctsProcessId.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
        ctsProcessId.setValue(UUID.randomUUID().toString());
        parameters.getParameter().add(ctsProcessId);
        Parameter applType = new Parameter();
        applType.setId("applType");
        applType.setValue("HCP");
        parameters.getParameter().add(applType);
        parameters.getParameter().add(UndeployParametersBuilder.buildUndeployMtasListParameter(mtaIds));
        return parameters;
    }

    private static Parameter buildUndeployMtasListParameter(List<String> mtaIds) {
        Parameter undeployMtasList = new Parameter();
        undeployMtasList.setId("undeployMtasList");
        Parameter.Tablevalue tableValue = new Parameter.Tablevalue();
        for (int i = 0; i < mtaIds.size(); ++i) {
            Tuple tuple = new Tuple();
            Parameters tupleValue = new Parameters();
            tuple.setValue(tupleValue);
            tuple.setId(Integer.toString(i + 1));
            Parameter mtaIdParameter = new Parameter();
            mtaIdParameter.setId("mtaId");
            mtaIdParameter.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            mtaIdParameter.setValue(mtaIds.get(i).trim());
            tupleValue.getParameter().add(mtaIdParameter);
            Parameter ignoreExternalDependencies = new Parameter();
            ignoreExternalDependencies.setId("ignoreExternalDependencies");
            ignoreExternalDependencies.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            ignoreExternalDependencies.setValue("true");
            tupleValue.getParameter().add(ignoreExternalDependencies);
            LOGGER.log((Priority)Level.INFO, (Object)MessageFormat.format("Ignore external dependencies option set to ''{1}'' for MTA with ID ''{0}''", mtaIdParameter.getValue(), ignoreExternalDependencies.getValue()));
            Parameter deleteSharedResources = new Parameter();
            deleteSharedResources.setId("deleteSharedResources");
            deleteSharedResources.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            deleteSharedResources.setValue("true");
            tupleValue.getParameter().add(deleteSharedResources);
            LOGGER.log((Priority)Level.INFO, (Object)MessageFormat.format("Delete shared resources option set to ''{1}'' for MTA with ID ''{0}''", mtaIdParameter.getValue(), deleteSharedResources.getValue()));
            Parameter deleteCustomEntities = new Parameter();
            deleteCustomEntities.setId("deleteCustomEntities");
            deleteCustomEntities.setType(SlpParameterType.SLP_PARAMETER_TYPE_SCALAR);
            deleteCustomEntities.setValue("true");
            tupleValue.getParameter().add(deleteCustomEntities);
            LOGGER.log((Priority)Level.INFO, (Object)MessageFormat.format("Delete custom entities option set to ''{1}'' for MTA with ID ''{0}''", mtaIdParameter.getValue(), deleteCustomEntities.getValue()));
            tableValue.getTuple().add(tuple);
        }
        undeployMtasList.setTablevalue(tableValue);
        return undeployMtasList;
    }
}

