/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.hcp.client.inventory;

import com.google.gson.Gson;
import com.sap.cloud.lm.sl.hcp.client.core.InventoryException;
import com.sap.cloud.lm.sl.hcp.client.inventory.InventoryClient;
import com.sap.cloud.lm.sl.hcp.client.inventory.json.DeployedMta;
import com.sap.cloud.lm.sl.hcp.client.utils.UrlBuilder;
import com.sap.jpaas.infrastructure.console.exception.BackendException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class InventoryClientImpl
implements InventoryClient {
    private static final Logger LOGGER = Logger.getLogger(InventoryClientImpl.class);
    private static final String SL_SERVICE_BASIC_URL = "slservice/v1/basic/accounts";
    private static final String INVENTORY_BASIC_URL = "slservice/v1/basic/accounts/%s/mtas";
    private static final String INVENTORY_PROVIDED_MTAS_BASIC_URL = "slservice/v1/basic/accounts/%s/providedMtas";
    private HttpClient httpClient = null;
    private String inventoryUrl = null;
    private String providedMtasUrl = null;

    public InventoryClientImpl(HttpClient httpClient, String host, String subaccount) {
        this.httpClient = httpClient;
        this.inventoryUrl = UrlBuilder.getSlServiceDestinationUrl(host, String.format(INVENTORY_BASIC_URL, subaccount), LOGGER);
        this.providedMtasUrl = UrlBuilder.getSlServiceDestinationUrl(host, String.format(INVENTORY_PROVIDED_MTAS_BASIC_URL, subaccount), LOGGER);
    }

    private List<DeployedMta> getDeployedMtas(HttpUriRequest httpRequest) throws InventoryException {
        try {
            HttpResponse response = this.httpClient.execute(httpRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new BackendException(MessageFormat.format("Response status code ''{0}'' and message ''{1}''.", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            HttpEntity resEntity = response.getEntity();
            String retBody = EntityUtils.toString((HttpEntity)resEntity);
            DeployedMta[] deployedMtas = this.fromJson(retBody, DeployedMta[].class);
            return new ArrayList<DeployedMta>(Arrays.asList(deployedMtas));
        }
        catch (ClientProtocolException exception) {
            throw new InventoryException(exception);
        }
        catch (IOException exception) {
            throw new BackendException((Exception)exception);
        }
    }

    @Override
    public List<DeployedMta> getMtas() throws InventoryException {
        HttpGet get = new HttpGet(this.inventoryUrl);
        return this.getDeployedMtas((HttpUriRequest)get);
    }

    @Override
    public List<DeployedMta> getEligibleForSubscriptionMtas() throws InventoryException {
        HttpGet get = new HttpGet(this.providedMtasUrl);
        return this.getDeployedMtas((HttpUriRequest)get);
    }

    @Override
    public DeployedMta getMta(String mtaId) throws InventoryException {
        HttpGet get = new HttpGet(String.format("%s/%s", this.inventoryUrl, mtaId));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new BackendException(MessageFormat.format("Cannot find Multi-Target Application with ID ''{0}''", mtaId));
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new BackendException(MessageFormat.format("Response status code ''{0}'' and message ''{1}''.", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            HttpEntity resEntity = response.getEntity();
            String retBody = EntityUtils.toString((HttpEntity)resEntity);
            DeployedMta deployedMta = this.fromJson(retBody, DeployedMta.class);
            return deployedMta;
        }
        catch (ClientProtocolException exception) {
            throw new InventoryException(exception);
        }
        catch (IOException exception) {
            throw new BackendException((Exception)exception);
        }
    }

    private <T> T fromJson(String entity, Class<T> clazz) throws InventoryException {
        Gson gson = new Gson();
        try {
            return (T)gson.fromJson(entity, clazz);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Failed to deserialize inventory model", (Throwable)exception);
            throw new InventoryException("Failed to transform Multi-Target Application. Contact SAP support.", exception);
        }
    }
}

